package com.elitesland.tw.tw5.server.yeedoc.service;

import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.yeedoc.service.YeedocWorkflowService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 易稻壳工作流交互
 *
 * @author carl
 * @date 2023-07-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class YeedocWorkflowServiceImpl extends BaseServiceImpl implements YeedocWorkflowService {
    private final WorkflowUtil workflowUtil;
    private final HttpUtil httpUtil;

    @Value("${yeedoc.queryGroupTypeUrl:https://yeedoc-test.tw.elitesland.com/userapi/Organization/GetGroupTypes}")
    private String queryGroupTypeUrl;
    @Value("${yeedoc.queryGroupDataUrl:https://yeedoc-test.tw.elitesland.com/userapi/Organization/GetGroupDataByGroupTypeId}")
    private String queryGroupDataUrl;


    @Override
    public ProcessInfo submitProcess(StartProcessPayload payload) {
        //发起流程审批
        System.out.println("易稻壳创建工作流:::" + payload.toString());
        ProcessInfo processInfo = workflowUtil.startProcess(payload);
        return processInfo;
    }

    @Override
    public Object queryGroupType() {
        //如果需要其它的请求头信息、都可以在这里追加
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json;charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("Source","1");
        HttpEntity httpEntity = new HttpEntity<>(httpHeaders);
        String result = httpUtil.sendGetExchange(queryGroupTypeUrl,null,httpEntity);
      //  String result = httpUtil.sendGet(queryGroupTypeUrl, null,httpEntity);
        Object yeedocResultData = httpUtil.getYeedocResultData(result);

        return yeedocResultData;
    }

    @Override
    public Object queryGroupData(String key) {

        //如果需要其它的请求头信息、都可以在这里追加
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json;charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("Source","1");
        HttpEntity httpEntity = new HttpEntity<>(httpHeaders);
        Map<String,Object> map= new HashMap<>();
        map.put("key",key);
        String result = httpUtil.sendGetExchange(queryGroupDataUrl,map,httpEntity);
      //  String result = httpUtil.sendGet(queryGroupDataUrl,map);
        Object yeedocResultData = httpUtil.getYeedocResultData(result);
        return yeedocResultData;
    }
}
