package com.elitesland.tw.tw5.server.common;

import java.util.List;

/**
 * 对象转换基类 mapstruct
 *
 * @author duwh
 * @date 2022/08/08
 */
public interface BaseConvertMapper<D, E> {

    /**
     * DTO转Entity
     * @param dto /
     * @return /
     */
    E toEntity(D dto);

    /**
     * Entity转DTO
     * @param entity /
     * @return /
     */
    //D toDto(E entity);

    /**
     * DTO集合转Entity集合
     * @param dtoList /
     * @return /
     */
    List <E> toEntity(List<D> dtoList);

    /**
     * DO集合转VO集合
     * @param entityList /
     * @return /
     */
    List <D> toVoList(List<E> entityList);

}
