
package com.elitesland.tw.tw5.server.common.funConfig.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * sql字段转java
 *
 * @author Zheng Jie
 * @date 2019-01-03
 */
public class ColUtil {
    private static final Logger log = LoggerFactory.getLogger(ColUtil.class);

    private static final Map<String, String> config = new HashMap();

    static {
        // 数据库类型转Java类型
        config.put("tinyint", "Integer");
        config.put("smallint", "Integer");
        config.put("mediumint", "Integer");
        config.put("int", "Integer");
        config.put("integer", "Integer");
        config.put("bigint", "Long");
        config.put("float", "Float");
        config.put("double", "Double");
        config.put("decimal", "BigDecimal");
        config.put("bit", "Boolean");
        config.put("char", "String");
        config.put("varchar", "String");
        config.put("tinytext", "String");
        config.put("text", "String");
        config.put("mediumtext", "String");
        config.put("longtext", "String");
        config.put("date", "LocalDate");
        config.put("datetime", "LocalDateTime");
        config.put("timestamp", "Timestamp");


    }

    /**
     * 转换mysql数据类型为java数据类型
     *
     * @param type 数据库字段类型
     * @return String
     */
    static String cloToJava(String type) {
        return config.get(type);
    }

}
