package com.elitesland.tw.tw5.server.common;

import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import java.io.Serializable;

/**
 * @author zoey
 * @Description:
 * @date 2022/6/9 - 15:53
 */
public class PageUtil extends com.elitescloud.cloudt.common.util.PageUtil {
    public static Pageable defaultSort(Pageable pageable) {
        if (pageable.getSort().equals(Sort.unsorted())) {
            Sort sort = Sort.by(Sort.Direction.DESC, "createTime");
            pageable = PageRequest.of(pageable.getPageNumber(), pageable.getPageSize(), sort);
        }
        return pageable;
    }

    public static <T extends Serializable> PagingVO<T> toPageVo(Page page) {
        return PagingVO.<T>builder().records(page.getContent()).total(page.getTotalElements()).build();
    }

}
