package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitesland.tw.tw5.api.common.funConfig.dto.BusinessPageJsonDTO;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessPageSearchJsonQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessPageListVO;
import com.elitesland.tw.tw5.server.common.constants.BusinessPageTypeEnum;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessPageRepo;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessPageDAO;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessPageConvert;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessPageService;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessPagePayload;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessPageDO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessPageVO;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessPageQuery;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessPageConvert;
import com.elitesland.tw.tw5.server.common.funConfig.util.BusinessPageJsonUtil;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 页面配置
 *
 * @author duwh
 * @date 2023-06-20
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessPageServiceImpl extends BaseServiceImpl implements BusinessPageService {

    private final BusinessPageRepo businessPageRepo;
    private final BusinessPageDAO businessPageDAO;

    @Override
    public PagingVO<BusinessPageListVO> querySimplePaging(BusinessPageQuery query) {
        return businessPageDAO.querySimplePaging(query);
    }

    @Override
    public PagingVO<BusinessPageVO> queryPaging(BusinessPageQuery query) {
        return businessPageDAO.queryPaging(query);
    }

    @Override
    public List<BusinessPageVO> queryListDynamic(BusinessPageQuery query) {
        List<BusinessPageVO> list = businessPageDAO.queryListDynamic(query);
        return list;
    }

    @Override
    public List<BusinessPageListVO> querySimpleListDynamic(BusinessPageQuery query) {
        List<BusinessPageListVO> list = businessPageDAO.querySimpleListDynamic(query);
//        expressionCondition(query,list);
        return list;
    }

    public List<BusinessPageVO> queryListDynamicPro(BusinessPageQuery query) {
        List<BusinessPageVO> list = businessPageDAO.queryListDynamic(query);
        expressionCondition(query, list);
        return list;
    }

    private void expressionCondition(BusinessPageQuery query, List<BusinessPageVO> list) {
        String visitTaskType = "";
        Long partnerId = 0L;

        // 获取客户
        if (query.getType() != null && query.getType().equals(BusinessPageTypeEnum.VIRTUAL.getCode())) {

        }

    }

    @Override
    public Long count(BusinessPageQuery query) {
        return businessPageDAO.count(query);
    }


    @Override
    public BusinessPageVO queryByKey(Long key) {
        BusinessPageDO entity = businessPageRepo.findById(key).orElseGet(BusinessPageDO::new);
        Assert.notNull(entity.getId(), "页面配置不存在");
        BusinessPageVO vo = BusinessPageConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessPageVO insert(BusinessPagePayload payload) {
        BusinessPageDO entityDo = BusinessPageConvert.INSTANCE.toDo(payload);
        return BusinessPageConvert.INSTANCE.toVo(businessPageRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessPageVO update(BusinessPagePayload payload) {
        BusinessPageDO entity = businessPageRepo.findById(payload.getId()).orElseGet(BusinessPageDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessPageDO entityDo = BusinessPageConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessPageConvert.INSTANCE.toVo(businessPageRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessPagePayload payload) {
        BusinessPageDO entity = businessPageRepo.findById(payload.getId()).orElseGet(BusinessPageDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessPageDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<BusinessPageDO> optional = businessPageRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessPageDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    businessPageRepo.save(entity);
                }
            });
        }
    }

    @Override
    public BusinessPageVO getJson(BusinessPageSearchJsonQuery query) {
        if (null != query) {
            BusinessPageDO entity = null;
            if (null != query.getId()) {
                entity = businessPageRepo.findById(query.getId()).orElseGet(BusinessPageDO::new);
            } else if (StringUtils.hasText(query.getCode())) {
                entity = businessPageRepo.findByCode(query.getCode());
            }
            Assert.notNull(entity.getId(), "页面配置不存在");
            BusinessPageVO vo = BusinessPageConvert.INSTANCE.toVo(entity);

            String content = BusinessPageJsonUtil.parseExpression(vo.getJsonContent(), query.getContextMap());
            vo.setJsonContent(content);
//            List<BusinessPageJsonDTO> pageJsonDTOList = BusinessPageJsonUtil.jsonToList(vo.getJsonDto());
//            BusinessPageJsonUtil.parseExpression(pageJsonDTOList, query.getContextMap());

            return vo;
        }
        return null;
    }

    @Override
    public BusinessPageVO getByCode(String code) {
        if (StringUtils.hasText(code)) {
            return businessPageDAO.queryByCode(code);
        }
        return null;
    }

}
