package com.elitesland.tw.tw5.server.common.util;

import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class DataUtil {

    public static final int[] constellationEdgeDay = {20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};

    public static final String[] CONSTELLATION_ARR = {"摩羯座", "水瓶座 ", "双鱼座 ", "白羊座 ", "金牛座 ", "双子座 ", "巨蟹座 ", " 狮子座 ", "处女座 ",
            " 天秤座 ", "天蝎座", "射手座", "魔羯座" };

    /**
     * 根据出生日期计算星座，年龄，月日
     *
     * @param date
     * @return
     */
    public static Map<String, String> getConstellation(LocalDate date) {
        Map<String, String> map = new HashMap<>();
        if (ObjectUtils.isEmpty(date)) {
            return map;
        }
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        String csonstel = day < constellationEdgeDay[month - 1] ? CONSTELLATION_ARR[month - 1] : CONSTELLATION_ARR[month];
        String dayOfMonth = month + "月" + day + "日";
        String age = (LocalDate.now().getYear() - date.getYear()) + "岁";
        map.put("csonstel", csonstel);
        map.put("dayOfMonth", dayOfMonth);
        map.put("age", age);
        return map;

    }
}
