package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAccountPayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbAccountService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAccountVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbAccountConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbAccountDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAccountDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Author carl.wang
 * @Description 银行账户管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdAbAccountServiceImpl implements PrdAbAccountService {
    private final CacheUtil cacheUtil;
    private final PrdAbAccountDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;

    @Value("${tw4.account.operation}")
    private String account_operation;

    @Value("${tw4.account.del}")
    private String account_del;

    @Transactional
    @Override
    public PrdAbAccountVO save(PrdAbAccountPayload payload) {
        //同步到4.0
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //String result = httpUtil.sendSyncPost(account_operation, map);
        //String accountId = httpUtil.geResultData(result);
        long accountIdV4 = 0;
        //if (StringUtils.hasText(accountId)) {
        //    if (StringUtil.isInteger(accountId)) {
        //        accountIdV4 = Long.valueOf(accountId);
        //    }
        //}

        PrdAbAccountDO contactsDO = PrdAbAccountConvert.INSTANCE.toDo(payload);
        contactsDO.setAccountIdV4(accountIdV4);
        contactsDO = dao.save(contactsDO);
        saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.CREATE.getDesc());
        return PrdAbAccountConvert.INSTANCE.toVo(contactsDO);
    }

    /**
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @param logType    记录内容
     */
    void saveBaseLog(Long bookId, String objectType, String logType) {
//        Long customerId = dao.queryIdByBookId(bookId);
//        logService.saveNewLog(customerId, objectType, logType + "银行账户");

    }

    @Transactional
    @Override
    public boolean delete(Long bookId, String objectType, List<Long> keys) {
        //同步到4.0

        //Map<String, Object> map = new HashMap<>();
        //map.put("ids", org.apache.commons.lang3.StringUtils.join(dao.queryTW4IdsByIds(keys), ","));
        //String result = httpUtil.sendSyncGet(account_del, map);
        //httpUtil.geResultData(result);

        dao.delete(keys);
        saveBaseLog(bookId, objectType, PrdSystemLogEnum.DELETE.getDesc());
        return true;
    }

    @Transactional
    @Override
    public boolean update(PrdAbAccountPayload payload) {
        //同步到4.0
        //Long accountIdV4 = dao.queryTW4IdById(payload.getId());
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //map.put("id", accountIdV4);
        //String result = httpUtil.sendSyncPost(account_operation, map);
        //httpUtil.geResultData(result);

        PrdAbAccountDO contactsDO = PrdAbAccountConvert.INSTANCE.toDo(payload);
        //contactsDO.setAccountIdV4(accountIdV4);
        dao.save(contactsDO);
        saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.UPDATE.getDesc());
        return true;
    }

    @Override
    public List<PrdAbAccountVO> queryList(Long bookId) {
        List<PrdAbAccountVO> contactsVOS = dao.queryList(bookId);
        contactsVOS.forEach(contactsVO -> transferSystemSelection(contactsVO));
        return contactsVOS;
    }

    @Override
    public List<PrdAbAccountVO> queryList(Long bookId,String accountType, Boolean defaultFlag,String accountNo) {
        List<PrdAbAccountVO> contactsVOS = dao.queryList(bookId, accountType, defaultFlag,accountNo);
        contactsVOS.forEach(contactsVO -> transferSystemSelection(contactsVO));
        return contactsVOS;
    }

    /**
     * 全局翻译
     *
     * @param vo
     */
    void transferSystemSelection(PrdAbAccountVO vo) {
        vo.setAccountTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbAccount_type.getCode(), vo.getAccountType()));
        vo.setCurrencyName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCurrCode.getCode(), vo.getCurrency()));
    }
}
