package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.VacationPlayload;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.VacationVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * @author sunxw
 * @description 假期
 * @Date 2023/5/9
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/vacation")
@Slf4j
public class VacationController {

    private final VacationService vacationService;

    /**
     * 查询时间范围内的工作小时数
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @return 总计小时数
     */
    @GetMapping("/workHours")
    public TwOutputUtil selectWorkHoursByDate(String startDate, String endDate) {
        Double workHours = vacationService.selectWorkHoursByDate(TimeUtil.dateFromYmd(startDate), TimeUtil.dateFromYmd(endDate));
        return TwOutputUtil.ok(workHours);
    }

    /**
     * 查询某一年的假期
     */
    @GetMapping("/{year}")
    public TwOutputUtil findVacation(@PathVariable int year) {
        List<VacationVO> list = vacationService.findListByYear(year);
        List<Map<String, Float>> mapList = new ArrayList<>();
        list.forEach(twVacationView -> {
            HashMap<String, Float> map = new HashMap<>();
            map.put(TimeUtil.dateToYmd(twVacationView.getNaturalDate()), twVacationView.getWorkHours());
            mapList.add(map);
        });
        return TwOutputUtil.ok(mapList);
    }

    /**
     * 保存假期
     */
    @PostMapping("/save")
    public TwOutputUtil saveVacation(@RequestBody List<Map<String, Float>> list) {
        List<VacationPlayload> vacationPlayloadList = new ArrayList<>();
        list.forEach(o -> {
            Map<String, Float> map = o;
            Set<String> keys = map.keySet();
            keys.forEach(key -> {
                VacationPlayload vacationPlayload = new VacationPlayload();
                vacationPlayload.setNaturalDate(TimeUtil.dateFromYmd(key));
                vacationPlayload.setWorkHours(map.get(key));
                vacationPlayloadList.add(vacationPlayload);
            });
        });
        vacationService.saveVacation(vacationPlayloadList);
        return TwOutputUtil.ok();
    }

    /**
     * 保存jde配置
     *
     * @return
     */
    @PostMapping("/saveJde")
    public TwOutputUtil saveJdeExport(@RequestBody List<Map<String, Byte>> list) {
        List<VacationPlayload> vacationPlayloadList = new ArrayList<>();
        list.forEach(o -> {
            Map<String, Byte> map = o;
            Set<String> keys = map.keySet();
            keys.forEach(key -> {
                VacationPlayload vacationPlayload = new VacationPlayload();
                vacationPlayload.setNaturalDate(TimeUtil.dateFromYmd(key));
                vacationPlayload.setJdeExportFlag(map.get(key));
                vacationPlayloadList.add(vacationPlayload);
            });
        });
        vacationService.saveJdeExport(vacationPlayloadList);
        return TwOutputUtil.ok();
    }

}
