package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgCompanyRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PrdOrgCompanyDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgCompanyRepo repo;
    private final QPrdOrgCompanyDO qdo = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdAbDO qdoAb = QPrdAbDO.prdAbDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgCompanyVO> getJpaQuerySelect() {
        JPAQuery<PrdOrgCompanyVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgCompanyVO.class,
                qdo.id,
                qdo.bookId,
                qdoAb.bookNo.as("companyNo"),
                qdo.companyName,
                qdo.companyIndustry,
                qdo.companyPhone,
                qdo.companyEmail,
                qdo.companyAddress,
                qdo.companyWebsite,
                qdo.companyScale,
                qdo.taxNo,
                qdo.currency,
                qdo.language,
                qdo.companyNature
        )).from(qdo).leftJoin(qdoAb).on(qdo.bookId.longValue().eq(qdoAb.id.longValue()));
        return jpaQuery;
    }

    /**
     * 获取公司数据
     *
     * @param relateType 相关主档
     * @return 结果
     */
    public List<PrdOrgCompanyVO> queryList(String relateType) {
        JPAQuery<PrdOrgCompanyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdoAb.bookType.eq(SystemDefaultEnum.DefaultAbType.getCode()));
        jpaQuery.where(qdoAb.relateType.contains(relateType));
        jpaQuery.where(qdoAb.deleteFlag.eq(0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, null));
        return jpaQuery.fetch();
    }

    /**
     * 主键查询名称
     *
     * @param key 主键id
     * @return 结果
     */
    public String queryNameByKey(Long key) {
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(qdo.companyName).from(qdo);
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }
}
