package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdMessageConfigQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 消息配置管理
 *
 * @author wangding
 */
@Api("消息配置管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_SYSTEM)
@RequestMapping("/api/system")
@Slf4j
public class PrdMessageConfigController {

    private final PrdMessageConfigService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/message/insert")
    public TwOutputUtil insert(PrdMessageConfigPayload entity) {
        PrdMessageConfigVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }
    /**
     * 邮件发送
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("邮件发送")
    @PostMapping("/message/sendEmail")
    public TwOutputUtil sendEmail(PrdMessageConfigPayload entity) {
        service.sendEmail(entity);
        return TwOutputUtil.ok();
    }
//    /**
//     * 保存并发布
//     *
//     * @param entity po类
//     * @return result
//     */
//    @ApiOperation("保存并发布")
//    @PostMapping("/message/release")
//    public TwOutputUtil release(PrdMessageConfigPayload entity) {
//        PrdMessageConfigVO vo = service.release(entity);
//        return TwOutputUtil.ok(vo);
//    }

    /**
     * 撤回
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("撤回")
    @PutMapping("/message/recall")
    public TwOutputUtil recall(Long[] keys) {
        service.recall(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/message/update")
    public TwOutputUtil update(PrdMessageConfigPayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/message/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 通过通知范围查询通知数据
     *
     * @param noticeScope 通知范围
     * @return result
     */
    @ApiOperation("通过通知范围查询通知数据")
    @GetMapping("/message/queryDatas")
    public TwOutputUtil queryDatas(String noticeScope) {
        return TwOutputUtil.ok(service.queryDatas(noticeScope));
    }

    /**
     * 查询发布来源数据
     *
     * @param releaseSource 发布来源
     * @return result
     */
    @ApiOperation("查询发布来源数据")
    @GetMapping("/message/queryMyDatas")
    public TwOutputUtil queryMyDatas(String releaseSource) {
        return TwOutputUtil.ok(service.queryMyDatas(releaseSource));
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("物理删除")
    @DeleteMapping("/message/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/message/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdMessageConfigVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页查询
     *
     * @return result
     */
    @ApiOperation("分页查询")
    @GetMapping("/message/paging")
    public TwOutputUtil paging(PrdMessageConfigQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 一键发布
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("一键发布")
    @PutMapping("/message/onKeyRelease")
    public TwOutputUtil onKeyRelease(Long[] keys) {
        service.onKeyRelease(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
