package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.common.TwCommonVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdMessageConfigQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.crontask.XxlJobInfo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QPrdUserMessageDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.MessageNoticeWayEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserMessageDO;
import com.elitesland.tw.tw5.server.prd.my.repo.PrdUserMessageRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 系统选择项dao
 *
 * @author wangding
 */
@Repository
@RequiredArgsConstructor
public class PrdMessageConfigDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdMessageConfigRepo repo;
    private final PrdUserMessageRepo repoUser;
    private final QPrdMessageConfigDO qdo = QPrdMessageConfigDO.prdMessageConfigDO;
    private final QPrdUserMessageDO qdoUser = QPrdUserMessageDO.prdUserMessageDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgEmployeeRefDO qdoEmployeeRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgPersonDO qdoPerson = QPrdOrgPersonDO.prdOrgPersonDO;
    private final QPrdSystemRoleDO qdoRole = QPrdSystemRoleDO.prdSystemRoleDO;

    private final QPrdSystemUserRoleDO qdoUserRole = QPrdSystemUserRoleDO.prdSystemUserRoleDO;
    private final EntityManager em;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdMessageConfigDO save(PrdMessageConfigDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存
     *
     * @param ados do对象
     * @return 保存后的对象
     */
    public List<PrdUserMessageDO> saveUserMessages(List<PrdUserMessageDO> ados) {
        return repoUser.saveAll(ados);
    }

    /**
     * 根据配置id查询组织名称
     *
     * @param id do对象
     * @return 保存后的对象
     */
    public String getOrgNames(Long id) {
        return repo.getOrgNames(id);
    }

    /**
     * 根据配置id查询角色名称
     *
     * @param id do对象
     * @return 保存后的对象
     */
    public String getRoleNames(Long id) {
        return repo.getRoleNames(id);
    }

    /**
     * 根据配置id查询所有指定组织人员
     *
     * @param ids do对象
     * @return 保存后的对象
     */
    public List<String[]> getOrgMessageDatas(List<Long> ids) {
        return repo.getOrgMessageDatas(ids);
    }

    /**
     * 根据配置id查询所有指定角色人员
     *
     * @param ids do对象
     * @return 保存后的对象
     */
    public List<String[]> getRoleMessageDatas(List<Long> ids) {
        return repo.getRoleMessageDatas(ids);
    }

    public void deleteXxlJobById(List<String> ids) {
        repo.deleteXxlJobById(ids);
    }

    /**
     * 根据配置id查询用户名称
     *
     * @param id do对象
     * @return 保存后的对象
     */
    public String getUserNames(Long id) {
        return repo.getUserNames(id);
    }

    /**
     * 根据消息id更新定时任务
     *
     * @param id do对象
     * @return 定时任务id
     */
    public void updateXxlJobById(String id, int trigger_status) {
        repo.updateXxlJobById(id, trigger_status);
    }

    /**
     * 根据消息id查询定时任务
     *
     * @param id do对象
     * @return 定时任务id
     */
    public List<Integer> getXxlJobByMessageId(String id) {
        return repo.getXxlJobByMessageId(id);
    }

    /**
     * 保存定时任务
     *
     * @param xxlJob do对象
     * @return 定时任务id
     */
    public int saveXxlJob(XxlJobInfo xxlJob) {
        String sql = "insert into xxl_job_info (job_group,job_cron,job_desc,add_time,update_time,author,alarm_email," +
                "executor_route_strategy,executor_handler,executor_param,executor_block_strategy,executor_timeout," +
                "executor_fail_retry_count,glue_type,glue_source,glue_remark,glue_updatetime,child_jobid,trigger_status," +
                "trigger_last_time,trigger_next_time) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Query query = em.createNativeQuery(sql);
        query.setParameter(1, xxlJob.getJobGroup());
        query.setParameter(2, xxlJob.getJobCron());
        query.setParameter(3, xxlJob.getJobDesc());
        query.setParameter(4, xxlJob.getAddTime());
        query.setParameter(5, xxlJob.getUpdateTime());
        query.setParameter(6, xxlJob.getAuthor());
        query.setParameter(7, xxlJob.getAlarmEmail());
        query.setParameter(8, xxlJob.getExecutorRouteStrategy());
        query.setParameter(9, xxlJob.getExecutorHandler());
        query.setParameter(10, xxlJob.getExecutorParam());
        query.setParameter(11, xxlJob.getExecutorBlockStrategy());
        query.setParameter(12, xxlJob.getExecutorTimeout());
        query.setParameter(13, xxlJob.getExecutorFailRetryCount());
        query.setParameter(14, xxlJob.getGlueType());
        query.setParameter(15, xxlJob.getGlueSource());
        query.setParameter(16, xxlJob.getGlueRemark());
        query.setParameter(17, xxlJob.getGlueUpdatetime());
        query.setParameter(18, xxlJob.getChildJobid());
        query.setParameter(19, xxlJob.getTriggerStatus());
        query.setParameter(20, xxlJob.getTriggerLastTime());
        query.setParameter(21, xxlJob.getTriggerNextTime());
        return query.executeUpdate();
    }

    /**
     * 获取user所在组织
     *
     * @return jpaQuery对象
     */
    private JPAQuery<String> getJpaQuerySelectOrg() {
        return jpaQueryFactory.select(
                qdoOrg.orgName
        ).from(qdoEmployeeRef).leftJoin(qdoOrg).on(qdoOrg.id.eq(qdoEmployeeRef.orgId));
    }


    /**
     * 查询所有用户
     *
     * @return 结果
     */
    public List<Long> queryAllUser() {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoEmployee.userId).from(qdoEmployee).where(qdoEmployee.deleteFlag.eq(0));
        jpaQuery.where(qdoEmployee.deleteFlag.eq(0));
        jpaQuery.where(qdoEmployee.resourceStatus.eq(SystemDefaultEnum.DefaultResourceStatus.getCode()));
        jpaQuery.where(qdoEmployee.hrStatus.eq(SystemDefaultEnum.DefaultHrStatus.getCode()));
        return jpaQuery.fetch();
    }


    /**
     * 获取系统邮箱
     *
     * @return jpaQuery对象
     */
    private JPAQuery<String> getJpaQuerySelectUserEmail() {
        return jpaQueryFactory.select(
                qdoPerson.email
        ).from(qdoEmployee).leftJoin(qdoPerson).on(qdoEmployee.personId.eq(qdoPerson.id));
    }

    /**
     * 根据用户id查询用户邮箱
     *
     * @return 结果
     */
    public List<String> queryUserEmailByIds(List<Long> userIds) {
        JPAQuery<String> jpaQuery = getJpaQuerySelectUserEmail();
        jpaQuery.where(qdoEmployee.deleteFlag.eq(0)).where(qdoPerson.deleteFlag.eq(0));
        jpaQuery.where(qdoEmployee.resourceStatus.eq(SystemDefaultEnum.DefaultResourceStatus.getCode()));
        jpaQuery.where(qdoEmployee.hrStatus.eq(SystemDefaultEnum.DefaultHrStatus.getCode()));
        jpaQuery.where(qdoPerson.enabled.eq(true));
        jpaQuery.where(qdoEmployee.userId.in(userIds));
        return jpaQuery.fetch();
    }

    /**
     * 查询所有用户邮箱
     *
     * @return 结果
     */
    public List<String> queryAllUserEmail() {
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(qdoPerson.email).from(qdoPerson).leftJoin(qdoEmployee).on(qdoPerson.id.eq(qdoEmployee.personId)).where(qdoPerson.enabled.eq(true)).where(qdoPerson.deleteFlag.eq(0)).where(qdoEmployee.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }


    /**
     * 根据用户id查询用户企业微信
     *
     * @return 结果
     */
    public List<String> queryUserWeComByIds(List<Long> userIds) {
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(qdoEmployee.wecomId).from(qdoEmployee).where(qdoEmployee.deleteFlag.eq(0)).where(qdoEmployee.wecomId.isNotNull()).where(qdoEmployee.wecomId.isNotEmpty());
        if (userIds.size() > 0) {
            jpaQuery.where(qdoEmployee.userId.in(userIds));
        }
        return jpaQuery.fetch();
    }

    /**
     * 根据用户id查询默认组织
     *
     * @param userId 用户id
     * @return 结果
     */
    public String queryOrgByUserId(Long userId) {
        JPAQuery<String> jpaQuery = getJpaQuerySelectOrg();
        jpaQuery.where(qdoEmployeeRef.userId.eq(userId))
                .where(qdoEmployeeRef.deleteFlag.eq(0))
                .where(qdoEmployeeRef.isCopy.eq(0))
                .where(qdoEmployeeRef.isDefault.eq(0))
                .where(qdoOrg.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdMessageConfigVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdMessageConfigVO.class,
                qdo.id,
                qdo.triggerTime,
                qdo.messageTitle,
                qdo.createSource,
                qdo.messageContent,
                qdo.contentType,
                qdo.contentBigType,
                qdo.releaseSource,
                qdo.noticeWay,
                qdo.noticeScope,
                qdo.noticeSource,
                qdo.triggerWay,
                qdo.triggerTimeExpression,
                qdo.expressionExplain,
                qdo.messageTag,
                qdo.releaseStatus,
                qdo.messageType,
                qdo.isEnable,
                qdo.remark,
                qdo.creator,
                qdo.deleteFlag,
                qdo.createUserId,
                qdo.createTime,
                qdo.ccEmails,
                qdo.ccSource,
                qdo.messageCode
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdMessageConfigVO> getJpaQueryWhere(PrdMessageConfigQuery query) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getMessageCode())) {
            jpaQuery.where(qdo.messageCode.eq(query.getMessageCode()));
        }
        if (!ObjectUtils.isEmpty(query.getMessageTitle())) {
            jpaQuery.where(qdo.messageTitle.like(SqlUtil.toSqlLikeString(query.getMessageTitle())));
        }
        if (!ObjectUtils.isEmpty(query.getMessageContent())) {
            jpaQuery.where(qdo.messageContent.like(SqlUtil.toSqlLikeString(query.getMessageContent())));
        }
        if (!ObjectUtils.isEmpty(query.getCreateSource())) {
            jpaQuery.where(qdo.createSource.like(SqlUtil.toSqlLikeString(query.getCreateSource())));
        }
        if (!ObjectUtils.isEmpty(query.getContentType())) {
            jpaQuery.where(qdo.contentType.eq(query.getContentType()));
        }
        if (!ObjectUtils.isEmpty(query.getContentBigType())) {
            jpaQuery.where(qdo.contentBigType.eq(query.getContentBigType()));
        }
        if (!ObjectUtils.isEmpty(query.getReleaseSource())) {
            jpaQuery.where(qdo.releaseSource.eq(query.getReleaseSource()));
        }
        if (!ObjectUtils.isEmpty(query.getNoticeWay())) {
            jpaQuery.where(qdo.noticeWay.eq(query.getNoticeWay()));
        }
        if (!ObjectUtils.isEmpty(query.getNoticeScope())) {
            jpaQuery.where(qdo.noticeScope.eq(query.getNoticeScope()));
        }
        if (!ObjectUtils.isEmpty(query.getNoticeSource())) {
            jpaQuery.where(qdo.noticeSource.eq(query.getNoticeSource()));
        }

        if (!ObjectUtils.isEmpty(query.getTriggerWay())) {
            jpaQuery.where(qdo.triggerWay.eq(query.getTriggerWay()));
        }
        if (!ObjectUtils.isEmpty(query.getTriggerTimeExpression())) {
            jpaQuery.where(qdo.triggerTimeExpression.eq(query.getTriggerTimeExpression()));
        }
        if (!ObjectUtils.isEmpty(query.getExpressionExplain())) {
            jpaQuery.where(qdo.expressionExplain.eq(query.getExpressionExplain()));
        }
        if (!ObjectUtils.isEmpty(query.getMessageTag())) {
            jpaQuery.where(qdo.messageTag.eq(query.getMessageTag()));
        }
        if (!ObjectUtils.isEmpty(query.getReleaseStatus())) {
            jpaQuery.where(qdo.releaseStatus.eq(query.getReleaseStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getMessageType())) {
            jpaQuery.where(qdo.messageType.eq(query.getMessageType()));
        }
        if (!ObjectUtils.isEmpty(query.getIsEnable())) {
            jpaQuery.where(qdo.isEnable.eq(query.getIsEnable()));
        }
        if (!ObjectUtils.isEmpty(query.getReleaseTimeStart())) {
            jpaQuery.where(qdo.triggerTime.goe(query.getReleaseTimeStart()));
        }
        if (!ObjectUtils.isEmpty(query.getReleaseTimeEnd())) {
            jpaQuery.where(qdo.triggerTime.loe(query.getReleaseTimeEnd()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }


    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdMessageConfigPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getMessageCode() != null) {
            update.set(qdo.messageCode, payload.getMessageCode());
        }
        if (payload.getMessageTitle() != null) {
            update.set(qdo.messageTitle, payload.getMessageTitle());
        }
        if (payload.getMessageContent() != null) {
            update.set(qdo.messageContent, payload.getMessageContent());
        }
        if (payload.getContentType() != null) {
            update.set(qdo.contentType, payload.getContentType());
        }
        if (payload.getContentBigType() != null) {
            update.set(qdo.contentBigType, payload.getContentBigType());
        }
        if (payload.getReleaseSource() != null) {
            update.set(qdo.releaseSource, payload.getReleaseSource());
        }
        if (payload.getNoticeWay() != null) {
            update.set(qdo.noticeWay, payload.getNoticeWay());
        }
        if (payload.getNoticeScope() != null) {
            update.set(qdo.noticeScope, payload.getNoticeScope());
        }
        if (payload.getNoticeSource() != null) {
            update.set(qdo.noticeSource, payload.getNoticeSource());
        }
        if (payload.getTriggerTime() != null) {
            update.set(qdo.triggerTime, payload.getTriggerTime());
        }
        if (payload.getTriggerWay() != null) {
            update.set(qdo.triggerWay, payload.getTriggerWay());
        }
        if (payload.getTriggerTimeExpression() != null) {
            update.set(qdo.triggerTimeExpression, payload.getTriggerTimeExpression());
        }
        if (payload.getExpressionExplain() != null) {
            update.set(qdo.expressionExplain, payload.getExpressionExplain());
        }
        if (payload.getMessageTag() != null) {
            update.set(qdo.messageTag, payload.getMessageTag());
        }
        if (payload.getIsEnable() != null) {
            update.set(qdo.isEnable, payload.getIsEnable());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.releaseStatus.eq(0).or(qdo.releaseStatus.eq(2).or(qdo.releaseStatus.eq(1).and(qdo.isEnable.eq(1)))))
                .where(qdo.id.in(keys));

        return update.execute();
    }

    /**
     * 撤回
     *
     * @param keys 主键
     * @return 修改的行数
     */
    public long recall(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.releaseStatus, 2)
                .where(qdo.messageType.eq(2))
                .where(qdo.noticeWay.eq(MessageNoticeWayEnum.INSTATION.getCode()))
                .where(qdo.releaseStatus.eq(3))
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 行政消息以发送
     *
     * @param keys 主键
     * @return 修改的行数
     */
    public long updateAdminStatus(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.releaseStatus, 3)
                .set(qdo.triggerTime, LocalDateTime.now())
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 运维消息以发送
     *
     * @param keys 主键
     * @return 修改的行数
     */
    public long updateOperStatus(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.releaseStatus, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 物理删除用户信息
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteUserMessage(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdoUser).where(qdoUser.messageId.in(keys));
        return delete.execute();
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdMessageConfigVO queryByKey(Long id) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据code查询配置
     *
     * @param messageCode
     * @return
     */
    public PrdMessageConfigVO queryByMessageCode(String messageCode) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.messageCode.eq(messageCode));
        return jpaQuery.fetchFirst();
    }


    /**
     * 根据编号查询
     *
     * @param code 编号
     * @return 结果
     */
    public PrdMessageConfigVO queryByCode(String code) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.messageCode.eq(code));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param keys 主键
     * @return 结果
     */
    public List<PrdMessageConfigVO> queryByKeys(List<Long> keys, int messageType, String triggerWay) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.isEnable.eq(0))//启用的消息
                .where(qdo.releaseStatus.ne(3))//未发布的消息
                .where(qdo.id.in(keys));
        if (triggerWay != null && !triggerWay.equals("")) {
            jpaQuery.where(qdo.triggerWay.eq(triggerWay));
        }
        if (messageType != 0) {
            jpaQuery.where(qdo.messageType.eq(messageType));
        }
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdMessageConfigVO> queryPaging(PrdMessageConfigQuery query) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdMessageConfigVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdMessageConfigVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TwCommonVO> getJpaQueryOrgDataSelect() {
        return jpaQueryFactory.select(Projections.bean(TwCommonVO.class,
                qdoEmployeeRef.orgId.as("id"),
                qdoOrg.orgName.as("name")
        )).from(qdoEmployeeRef).leftJoin(qdoOrg).on(qdoEmployeeRef.orgId.longValue().eq(qdoOrg.id));
    }


    /**
     * 查询所有
     *
     * @return 结果
     */
    public List<TwCommonVO> queryOrgListByUserId(Long userId) {
        JPAQuery<TwCommonVO> jpaQuery = getJpaQueryOrgDataSelect();
        jpaQuery.where(qdoEmployeeRef.userId.eq(userId));
        jpaQuery.where(qdoEmployeeRef.deleteFlag.eq(0));
        jpaQuery.where(qdoEmployeeRef.isCopy.eq(0));
        jpaQuery.where(qdoOrg.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TwCommonVO> getJpaQueryRoleDataSelect() {
        return jpaQueryFactory.select(Projections.bean(TwCommonVO.class,
                qdoUserRole.roleId.as("id"),
                qdoRole.roleName.as("name")
        )).from(qdoUserRole).leftJoin(qdoRole).on(qdoUserRole.roleId.longValue().eq(qdoRole.id));
    }


    /**
     * 查询所有
     *
     * @return 结果
     */
    public List<TwCommonVO> queryRoleListByUserId(Long userId) {
        JPAQuery<TwCommonVO> jpaQuery = getJpaQueryRoleDataSelect();
        jpaQuery.where(qdoUserRole.userId.eq(userId));
        jpaQuery.where(qdoUserRole.deleteFlag.eq(0));
        jpaQuery.where(qdoRole.enabled.eq(true));
        jpaQuery.where(qdoRole.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    public List<PrdMessageConfigDO> queryByObjectIdAndAction(Long objectId, String action) {
        return repo.findByObjectIdAndAction(objectId, action);
    }


}
