package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdTemporaryStoragePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdTemporaryStorageQuery;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdTemporaryStorageDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdTemporaryStorageRepo;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/7/1 - 16:19
 */
@Repository
@RequiredArgsConstructor
public class PrdTemporaryStorageDAO {
    private final PrdTemporaryStorageRepo repo;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdTemporaryStorageDO save(PrdTemporaryStorageDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdTemporaryStorageDO> saveAll(List<PrdTemporaryStorageDO> dos) {
        return repo.saveAll(dos);
    }


    public Specification<PrdTemporaryStorageDO> getSpec(PrdTemporaryStorageQuery query) {
        Specification<PrdTemporaryStorageDO> querySpecifi = (root, criteriaQuery, cb) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (!StringUtils.isEmpty(query.getRemark())) {
                predicates.add(cb.like(root.get("remark").as(String.class), SqlUtil.toSqlLikeString(query.getRemark())));
            }
            if (!StringUtils.isEmpty(query.getStorageUrl())) {
                predicates.add(cb.like(root.get("storageUrl").as(String.class), SqlUtil.toSqlLikeString(query.getStorageUrl())));
            }
            if (!StringUtils.isEmpty(query.getStorageContent())) {
                predicates.add(cb.like(root.get("storageContent").as(String.class), SqlUtil.toSqlLikeString(query.getStorageContent())));
            }
            if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
                predicates.add(cb.equal(root.get("createUserId").as(String.class), query.getCreateUserId()));
            }
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        return querySpecifi;
    }

    public List<PrdTemporaryStorageDO> findAll(Specification<PrdTemporaryStorageDO> spec) {
        return repo.findAll(spec);
    }

    public Page<PrdTemporaryStorageDO> findAll(Specification<PrdTemporaryStorageDO> spec, Pageable pageable) {
        pageable= PageUtil.defaultSort(pageable);
        return repo.findAll(spec, pageable);
    }

    public PrdTemporaryStorageDO queryById(Long id) {
        return repo.findById(id).orElse(null);
    }

    public void updateByKeyDynamic(PrdTemporaryStoragePayload payload) {
        //查询出当前的do
        PrdTemporaryStorageDO storageDO = repo.findById(payload.getId()).orElse(null);
        if(storageDO!=null){
            if (payload.getStorageUrl() != null) {
                storageDO.setStorageUrl(payload.getStorageUrl());
            }
            if (payload.getStorageContent() != null){
                storageDO.setStorageContent(payload.getStorageContent());
            }
            if (payload.getRemark()!= null){
                storageDO.setRemark(payload.getRemark());
            }
            if (payload.getDeleteFlag()!= null){
                storageDO.setDeleteFlag(payload.getDeleteFlag());
            }
            repo.save(storageDO);
        }
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public void deleteSoft(List<Long> keys) {
        for (Long key : keys) {
            PrdTemporaryStoragePayload payload = new PrdTemporaryStoragePayload();
            payload.setId(key);
            payload.setDeleteFlag(1);
            updateByKeyDynamic(payload);
        }
    }

}
