package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.common.TwCommonVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdMessageConfigQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.crontask.CmadCronTask;
import com.elitesland.tw.tw5.server.common.crontask.XxlJobInfo;
import com.elitesland.tw.tw5.server.common.util.JavaMailPayload;
import com.elitesland.tw.tw5.server.common.util.JavaMailUtil;
import com.elitesland.tw.tw5.server.common.util.SpelUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserMessageDO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdMessageConfigConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdMessageConfigDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 菜单管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdMessageConfigServiceImpl extends BaseServiceImpl implements PrdMessageConfigService {
    private final PrdMessageConfigDAO dao;

    private final PrdSystemRoleDAO daoSysRole;
    private final CacheUtil cacheUtil;
    private final JavaMailUtil mailUtil;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService organizationService;
    private final QyWxCommunicationService qyWxCommunicationService;
    // @DubboReference(version = "${provider.service.version}")
//    @Autowired
    //private SysNumberRuleService numberRuleService;
    private final String timing = "timing";
    @Value("${tw5.mail.message_email}")
    private String message_email;

    //判断需要不需要创建定时任务
    boolean checkTriggerTime(PrdMessageConfigPayload payload) {
        boolean isTime = false;
        if (timing.equals(payload.getTriggerWay())) {
            //运维消息模板
            if (payload.getMessageType() == 1) {
                if (StringUtils.hasText(payload.getTriggerTimeExpression())) {
                    if (!CronExpression.isValidExpression(payload.getTriggerTimeExpression())) {
                        throw TwException.error("", "无效的时间表达式格式");
                    }
                    isTime = true;
                }
            } else {
                if (payload.getTriggerTime() != null) {
                    //行政消息
                    if (payload.getTriggerTime().isBefore(LocalDateTime.now())) {
                        throw TwException.error("", "发布时间不可小于当前时间");
                    }
                    payload.setTriggerTimeExpression(payload.getTriggerTime().format(DateTimeFormatter.ofPattern("ss mm HH dd MM ? yyyy")));
                    isTime = true;
                }
            }
        }
        return isTime;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public PrdMessageConfigVO insert(PrdMessageConfigPayload payload) {
        //如果企业微信发动，过滤标签
        if (payload.getNoticeWay().equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) {
            payload.setMessageContent(GlobalUtil.stringHtmlFilter(payload.getMessageContent()));
        }
        boolean isTime = checkTriggerTime(payload);
        if (isTime) {
            payload.setReleaseStatus(0);
        } else {
            payload.setTriggerTime(LocalDateTime.now());
            payload.setReleaseStatus(3);
        }
        String code = generateSeqNum("MESSAGE_CONFIG_NO");
        payload.setMessageCode(code);
        PrdMessageConfigDO ado = PrdMessageConfigConvert.INSTANCE.toDo(payload);
        getCreateSource(ado);
        ado = dao.save(ado);
        PrdMessageConfigVO configVO = PrdMessageConfigConvert.INSTANCE.toVo(ado);
        if (isTime) {
            createXXLJob(ado);
        } else {
            releaseMessage(Arrays.asList(configVO));
        }
        return PrdMessageConfigConvert.INSTANCE.toVo(ado);
    }

    /*
    创建定时任务
     */
    void createXXLJob(PrdMessageConfigDO ado) {

        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setAuthor(ado.getCreator());
        xxlJobInfo.setJobGroup(Integer.valueOf(cacheUtil.getSystemSetting(FunctionSettingEnum.JOB_GROUP.getCode()).getSettingValue()));
        xxlJobInfo.setJobCron(ado.getTriggerTimeExpression());
        xxlJobInfo.setJobDesc(ado.getMessageTitle());
        xxlJobInfo.setExecutorHandler(CmadCronTask.messageXxlJobValue);
        xxlJobInfo.setExecutorParam(ado.getId() + "");
        xxlJobInfo.setTriggerStatus(ado.getIsEnable() == 0 ? 1 : 0);
        dao.saveXxlJob(xxlJobInfo);
    }

    @Transactional
    @Override
    public PrdMessageConfigVO release(PrdMessageConfigPayload payload) {
        payload.setReleaseStatus(3);
        PrdMessageConfigDO ado = PrdMessageConfigConvert.INSTANCE.toDo(payload);
        ado.setTriggerTime(LocalDateTime.now());
        getCreateSource(ado);
        ado = dao.save(ado);
        if (payload.getId() != null && payload.getId().longValue() > 0) {
            List<String> messageIds = new ArrayList<>();
            messageIds.add(payload.getId() + "");
            dao.deleteXxlJobById(messageIds);
        }
        PrdMessageConfigVO configVO = PrdMessageConfigConvert.INSTANCE.toVo(ado);
        releaseMessage(Arrays.asList(configVO));
        return configVO;
    }


    @Transactional
    @Override
    public Long update(PrdMessageConfigPayload payload) {
        PrdMessageConfigVO messageConfigVO = dao.queryByKey(payload.getId());
        if (messageConfigVO.getReleaseStatus() == 3) {
            throw TwException.error("", "已发送消息不可编辑");
        }
        //如果企业微信发动，过滤标签
        if (payload.getNoticeWay().equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) {
            payload.setMessageContent(GlobalUtil.stringHtmlFilter(payload.getMessageContent()));
        }
        payload.setReleaseStatus(0);//状态改为新建
        boolean isTime = checkTriggerTime(payload);//判断是否是定时任务
        boolean isNew = false;//判断是否需要穿件定时执行器
        boolean isRelese = false;//判断是否要立即发布
        List<String> deleteIds = new ArrayList<>();
        //首先判断修改后是不是时间表达式
        if (isTime) {
            //判断修改前是不是时间表达式
            if (timing.equals(messageConfigVO.getTriggerWay())) {
                //判断修改前后时间表达式是否相同
                if (!payload.getTriggerTimeExpression().equals(messageConfigVO.getTriggerTimeExpression())) {
                    deleteIds.add(payload.getId() + "");
                    isNew = true;
                }
                if (!messageConfigVO.getIsEnable().equals(payload.getIsEnable())) {
                    dao.updateXxlJobById(payload.getId() + "", payload.getIsEnable() == 0 ? 1 : 0);
                }
            } else {
                isNew = true;
            }

        } else {
            if (timing.equals(messageConfigVO.getTriggerWay())) {
                deleteIds.add(payload.getId() + "");
            }
            //如果是行政消息直接发布
            if (payload.getMessageType() == 2) {
                payload.setTriggerTime(LocalDateTime.now());
                payload.setReleaseStatus(3);
                isRelese = true;
            }
        }
        if (deleteIds.size() > 0) {
            dao.deleteXxlJobById(deleteIds);
        }

        PrdMessageConfigDO ado = PrdMessageConfigConvert.INSTANCE.toDo(payload);
        ado.setCreator(messageConfigVO.getCreator());
        ado.setCreateUserId(messageConfigVO.getCreateUserId());
        getCreateSource(ado);
        ado = dao.save(ado);
        if (isNew) {
            createXXLJob(ado);
        }
        if (isRelese) {
            PrdMessageConfigVO configVO = PrdMessageConfigConvert.INSTANCE.toVo(ado);
            releaseMessage(Arrays.asList(configVO));
        }
        return 0L;
    }

    @Transactional
    @Override
    public boolean recall(List<Long> keys) {
        dao.recall(keys);
        dao.deleteUserMessage(keys);
        return true;
    }

    @Transactional
    @Override
    public boolean delete(List<Long> keys) {
        dao.delete(keys);
        List<String> adminStrIds = keys.stream().map(String::valueOf).collect(Collectors.toList());
        dao.deleteXxlJobById(adminStrIds);
        return true;
    }

    @Transactional
    @Override
    public boolean deleteSoft(List<Long> keys) {

        dao.deleteSoft(keys);
        List<String> adminStrIds = keys.stream().map(String::valueOf).collect(Collectors.toList());
        dao.deleteXxlJobById(adminStrIds);
        return true;
    }

    @Override
    public PrdMessageConfigVO queryByKey(Long key) {
        PrdMessageConfigVO messageConfigVO = dao.queryByKey(key);
        transferSystemSelection(messageConfigVO);
        String name = getNoticeSourceName(messageConfigVO.getId(), messageConfigVO.getNoticeScope(), messageConfigVO.getNoticeSource());
//        String name = messageConfigVO.getNoticeSource();
//        if (StringUtils.hasText(messageConfigVO.getNoticeSource())) {
//            String noticeScope = messageConfigVO.getNoticeScope();
//            if (noticeScope.equals(MessageNoticeScopeEnum.APPOINT_ORG.getCode())) {
//                name = dao.getOrgNames(messageConfigVO.getId());
//            }
//            if (noticeScope.equals(MessageNoticeScopeEnum.APPIONT_PEOPLE.getCode())) {
//                name = dao.getUserNames(messageConfigVO.getId());
//            }
//            if (noticeScope.equals(MessageNoticeScopeEnum.APPOINT_ROLE.getCode())) {
//                //TODO 查询可选择角色 待定
//            }
//        }
        messageConfigVO.setNoticeSourceName(name);
        return messageConfigVO;
    }

    public String getNoticeSourceName(Long messageId, String noticeScope, String noticeSource) {
        String name = noticeSource;
        if (StringUtils.hasText(noticeSource)) {
            if (noticeScope.equals(MessageNoticeScopeEnum.APPOINT_ORG.getCode())) {
                name = dao.getOrgNames(messageId);
            }
            if (noticeScope.equals(MessageNoticeScopeEnum.APPIONT_PEOPLE.getCode())) {
                List<String> userNames = new ArrayList<>();
                for (String sourceId : noticeSource.split(",")) {
                    String userName = cacheUtil.getUserName(Long.parseLong(sourceId));
                    userNames.add(userName);
                }
                name = String.join(",", userNames);
//                name = dao.getUserNames(messageId);
            }
            if (noticeScope.equals(MessageNoticeScopeEnum.APPOINT_ROLE.getCode())) {
                name = dao.getRoleNames(messageId);
            }
        }
        return name;
    }

    @Override
    public List<TwCommonVO> queryDatas(String noticeScope) {
        List<TwCommonVO> list = new ArrayList<>();
        if (noticeScope.equals(MessageNoticeScopeEnum.APPOINT_ROLE.getCode())) {
            List<PrdSystemRoleVO> roleVOS = daoSysRole.queryList();
            roleVOS.forEach(refVo -> {
                TwCommonVO vo = new TwCommonVO();
                vo.setId(refVo.getId());
                vo.setName(refVo.getRoleName());
                list.add(vo);
            });
        }
        if (noticeScope.equals(MessageNoticeScopeEnum.APPOINT_ORG.getCode())) {
            List<PrdOrgOrganizationRefVO> refVOS = organizationService.queryAll(null, null);
            refVOS.forEach(refVo -> {
                TwCommonVO vo = new TwCommonVO();
                vo.setId(refVo.getOrgId());
                vo.setName(refVo.getOrgName());
                list.add(vo);
            });
        }

        if (noticeScope.equals(MessageNoticeScopeEnum.APPIONT_PEOPLE.getCode())) {
            PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
            query.setEnabled(true);
            query.setResourceStatus(SystemDefaultEnum.DefaultResourceStatus.getCode());
            query.setHrStatus(SystemDefaultEnum.DefaultHrStatus.getCode());
            List<PrdOrgEmployeeVO> refVOS = employeeService.queryList(query);
            refVOS.forEach(refVo -> {
                TwCommonVO vo = new TwCommonVO();
                vo.setId(refVo.getUserId());
                vo.setName(refVo.getEmployeeName());
                list.add(vo);
            });
        }
        return list;
    }

    @Override
    public PagingVO<PrdMessageConfigVO> paging(PrdMessageConfigQuery query) {
        PagingVO<PrdMessageConfigVO> messageConfigVOPagingVOs = dao.queryPaging(query);
        List<PrdMessageConfigVO> configVOS = messageConfigVOPagingVOs.getRecords();
        configVOS.forEach(configVO -> transferSystemSelection(configVO));
        return messageConfigVOPagingVOs;
    }


    @Transactional
    @Override
    public boolean onKeyRelease(List<Long> keys) {
        List<PrdMessageConfigVO> configVOS = dao.queryByKeys(keys, 2, null);
        releaseMessage(configVOS);
        List<Long> ids = configVOS.stream().map(PrdMessageConfigVO::getId).collect(Collectors.toList());
        dao.updateAdminStatus(ids);
        List<String> adminStrIds = ids.stream().map(String::valueOf).collect(Collectors.toList());
        dao.deleteXxlJobById(adminStrIds);
        return true;
    }

    @Transactional
    @Override
    public void onJobHandlerRelease(String param) {
        System.out.println("onJobHandlerRelease param::" + param);
        if (StringUtil.isInteger(param)) {
            List<Long> messageIds = new ArrayList<>();
            messageIds.add(Long.valueOf(param));
            List<PrdMessageConfigVO> configVOS = dao.queryByKeys(messageIds, 0, timing);
            releaseMessage(configVOS);
            //行政管理人员消息
            List<Long> adminIds = configVOS.stream().filter(configVO -> configVO.getMessageType() == 2).map(PrdMessageConfigVO::getId).collect(Collectors.toList());
            if (adminIds.size() > 0) {
                dao.updateAdminStatus(adminIds);
                List<String> adminStrIds = adminIds.stream().map(String::valueOf).collect(Collectors.toList());
                dao.deleteXxlJobById(adminStrIds);
            }
            //运维管理人员消息
            List<Long> operIds = configVOS.stream().filter(configVO -> configVO.getMessageType() == 1).map(PrdMessageConfigVO::getId).collect(Collectors.toList());
            if (operIds.size() > 0) {
                dao.updateOperStatus(adminIds);
            }
        }

    }

    @Override
    public List<TwCommonVO> queryMyDatas(String releaseSource) {
        List<TwCommonVO> list = new ArrayList<>();
        GeneralUserDetails user = SecurityContextUtil.currentUser();

        if (releaseSource.equals(MessageReleaseSourceEnum.ORG.getCode())) {
            list = dao.queryOrgListByUserId(user.getUser().getId());
        }

        if (releaseSource.equals(MessageReleaseSourceEnum.ROLE.getCode())) {
            list = dao.queryRoleListByUserId(user.getUser().getId());
        }
        return list;
    }

    /**
     * 发送模板消息
     *
     * @param configVO
     * @param content      需要替换的对象
     * @param noticeScope  通知范围
     * @param noticeSource 通知资源
     */
    @Override
    public Object sendMessageConfig(PrdMessageConfigVO configVO, Object content, String noticeScope, String noticeSource) {
        String releaseTitle = SpelUtil.parseStringExpression(configVO.getMessageTitle(), content);
        String releaseBody = SpelUtil.parseStringExpression(configVO.getMessageContent(), content);
        configVO.setMessageTitle(releaseTitle);
        configVO.setMessageContent(releaseBody);
        configVO.setNoticeScope(noticeScope);
        configVO.setNoticeSource(noticeSource);
        List<PrdMessageConfigVO> prdMessageConfigVOS = Arrays.asList(configVO);
        releaseMessage(prdMessageConfigVOS);
        return prdMessageConfigVOS;
    }

    @Override
    public void releaseMessage(List<PrdMessageConfigVO> configVOS) {

        if (configVOS != null && configVOS.size() > 0) {
            List<PrdUserMessageDO> messageDOS = new ArrayList<>();
            //指定全员
            List<PrdMessageConfigVO> allUsers = configVOS.stream().filter(configVO -> configVO.getNoticeScope().equals(MessageNoticeScopeEnum.WHOLE.getCode())).collect(Collectors.toList());
            if (allUsers != null && allUsers.size() > 0) {
                releaseMessageAllUser(allUsers, messageDOS);
            }
            //指定人
            List<PrdMessageConfigVO> appointUsers = configVOS.stream().filter(configVO -> configVO.getNoticeScope().equals(MessageNoticeScopeEnum.APPIONT_PEOPLE.getCode())).collect(Collectors.toList());
            if (appointUsers != null && appointUsers.size() > 0) {
                releaseMessageAppointUser(appointUsers, messageDOS);
            }

            //指定组织
            List<PrdMessageConfigVO> appointOrgs = configVOS.stream().filter(configVO -> configVO.getNoticeScope().equals(MessageNoticeScopeEnum.APPOINT_ORG.getCode())).collect(Collectors.toList());
            if (appointOrgs != null && appointOrgs.size() > 0) {
                releaseMessageAppointOrg(appointOrgs, messageDOS);
            }
            //  指定角色
            List<PrdMessageConfigVO> appointRoles = configVOS.stream().filter(configVO -> configVO.getNoticeScope().equals(MessageNoticeScopeEnum.APPOINT_ROLE.getCode())).collect(Collectors.toList());//指定角色
            if (appointRoles != null && appointRoles.size() > 0) {
                releaseMessageAppointRole(appointRoles, messageDOS);
            }
            if (messageDOS.size() > 0) {
                dao.saveUserMessages(messageDOS);
            }
        }
    }

    //指定角色操作
    void releaseMessageAppointRole(List<PrdMessageConfigVO> appointRoles, List<PrdUserMessageDO> messageDOS) {
        List<Long> orgRefIds = appointRoles.stream().map(PrdMessageConfigVO::getId).collect(Collectors.toList());
        Map<Long, List<Long>> emailMap = new HashMap<>();
        Map<Long, List<Long>> weComMap = new HashMap<>();
        List<String[]> messageVOS = dao.getRoleMessageDatas(orgRefIds);
        for (String[] messageVO : messageVOS) {
            //站内信
            if (messageVO[3].equals(MessageNoticeWayEnum.INSTATION.getCode())) {
                PrdMessageConfigVO messageConfigVO = appointRoles.stream().filter(configVO -> configVO.getId().longValue() == Long.valueOf(messageVO[0])).findFirst().get();
                addMessageDO(messageDOS, Long.valueOf(messageVO[1]), messageConfigVO);
            }
            //邮件
            if (messageVO[3].equals(MessageNoticeWayEnum.EMAIL.getCode())) {
                long messageId = Long.valueOf(messageVO[0]);
                List<Long> userIds = emailMap.get(messageId);
                if (userIds == null) {
                    userIds = new ArrayList<>();
                    emailMap.put(messageId, userIds);
                }
                userIds.add(Long.valueOf(messageVO[1]));
            }
            //企业微信
            if (messageVO[3].equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) {
                long messageId = Long.valueOf(messageVO[0]);
                List<Long> userIds = weComMap.get(messageId);
                if (userIds == null) {
                    userIds = new ArrayList<>();
                    weComMap.put(messageId, userIds);
                }
                userIds.add(Long.valueOf(messageVO[1]));
            }
        }
        if (!emailMap.isEmpty()) {
            for (Map.Entry<Long, List<Long>> emailData : emailMap.entrySet()) {
                List<String> emails = dao.queryUserEmailByIds(emailData.getValue());
                PrdMessageConfigVO messageConfigVO = appointRoles.stream().filter(configVO -> configVO.getId().longValue() == emailData.getKey()).findFirst().get();
                // 获取所有抄送人电子邮件
                List<String> ccEmailsAll = getCcEmailsAll(messageConfigVO);
                sendEmail(emails, ccEmailsAll, messageConfigVO.getMessageTitle(), messageConfigVO.getMessageContent());
            }
        }
        if (!weComMap.isEmpty()) {
            for (Map.Entry<Long, List<Long>> weComData : weComMap.entrySet()) {
                List<String> weComs = dao.queryUserWeComByIds(weComData.getValue());
                PrdMessageConfigVO messageConfigVO = appointRoles.stream().filter(configVO -> configVO.getId().longValue() == weComData.getKey()).findFirst().get();
                sendWeCom(weComs, messageConfigVO);
            }
        }
    }

    //指定组织操作
    void releaseMessageAppointOrg(List<PrdMessageConfigVO> appointOrgs, List<PrdUserMessageDO> messageDOS) {
        List<Long> orgRefIds = appointOrgs.stream().map(PrdMessageConfigVO::getId).collect(Collectors.toList());
        Map<Long, List<Long>> emailMap = new HashMap<>();
        Map<Long, List<Long>> weComMap = new HashMap<>();
        List<String[]> messageVOS = dao.getOrgMessageDatas(orgRefIds);
        for (String[] messageVO : messageVOS) {
            //站内信
            if (messageVO[3].equals(MessageNoticeWayEnum.INSTATION.getCode())) {
                PrdMessageConfigVO messageConfigVO = appointOrgs.stream().filter(configVO -> configVO.getId().longValue() == Long.valueOf(messageVO[0])).findFirst().get();
                addMessageDO(messageDOS, Long.valueOf(messageVO[1]), messageConfigVO);
            }
            //邮件
            if (messageVO[3].equals(MessageNoticeWayEnum.EMAIL.getCode())) {
                long messageId = Long.valueOf(messageVO[0]);
                List<Long> userIds = emailMap.get(messageId);
                if (userIds == null) {
                    userIds = new ArrayList<>();
                    emailMap.put(messageId, userIds);
                }
                userIds.add(Long.valueOf(messageVO[1]));
            }
            //企业微信
            if (messageVO[3].equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) {
                long messageId = Long.valueOf(messageVO[0]);
                List<Long> userIds = weComMap.get(messageId);
                if (userIds == null) {
                    userIds = new ArrayList<>();
                    weComMap.put(messageId, userIds);
                }
                userIds.add(Long.valueOf(messageVO[1]));
            }
        }
        if (!emailMap.isEmpty()) {
            for (Map.Entry<Long, List<Long>> emailData : emailMap.entrySet()) {
                List<String> emails = dao.queryUserEmailByIds(emailData.getValue());
                PrdMessageConfigVO messageConfigVO = appointOrgs.stream().filter(configVO -> configVO.getId().longValue() == emailData.getKey()).findFirst().get();
                // 获取所有抄送人电子邮件
                List<String> ccEmailsAll = getCcEmailsAll(messageConfigVO);
                sendEmail(emails, ccEmailsAll, messageConfigVO.getMessageTitle(), messageConfigVO.getMessageContent());
            }
        }
        if (!weComMap.isEmpty()) {
            for (Map.Entry<Long, List<Long>> weComData : weComMap.entrySet()) {
                List<String> weComs = dao.queryUserWeComByIds(weComData.getValue());
                PrdMessageConfigVO messageConfigVO = appointOrgs.stream().filter(configVO -> configVO.getId().longValue() == weComData.getKey()).findFirst().get();
                sendWeCom(weComs, messageConfigVO);
            }
        }
    }

    //指定人操作
    void releaseMessageAppointUser(List<PrdMessageConfigVO> appointUsers, List<PrdUserMessageDO> messageDOS) {
        for (PrdMessageConfigVO configVO : appointUsers) {
            if (StringUtils.hasText(configVO.getNoticeSource())) {
                String[] userIds = configVO.getNoticeSource().split(",");

                //站内信
                if (configVO.getNoticeWay().equals(MessageNoticeWayEnum.INSTATION.getCode())) {
                    for (int i = 0; i < userIds.length; i++) {
                        addMessageDO(messageDOS, Long.valueOf(userIds[i]), configVO);
                    }
                }
                List<Long> operaIds = Arrays.asList(userIds).stream().map(s -> Long.valueOf(s.trim())).collect(Collectors.toList());

                //邮件
                if (configVO.getNoticeWay().equals(MessageNoticeWayEnum.EMAIL.getCode())) {
                    List<String> emails = dao.queryUserEmailByIds(operaIds);
                    // 获取所有抄送人电子邮件
                    List<String> ccEmailsAll = getCcEmailsAll(configVO);
                    sendEmail(emails, ccEmailsAll, configVO.getMessageTitle(), configVO.getMessageContent());
                }
                //企业微信
                if (configVO.getNoticeWay().equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) {
                    List<String> weComs = dao.queryUserWeComByIds(operaIds);
                    sendWeCom(weComs, configVO);
                }
            }
        }
    }

    /**
     * 获取所有抄送人电子邮件
     *
     * @param configVO 配置vo
     * @return {@link List}<{@link String}>
     */
    @NotNull
    private List<String> getCcEmailsAll(PrdMessageConfigVO configVO) {
        List<String> ccEmailsAll = new ArrayList<>();
        if (null != configVO) {
            if (StringUtils.hasText(configVO.getCcSource())) {
                String[] ccUserIds = configVO.getCcSource().split(",");
                List<Long> ccOperaIds = Arrays.asList(ccUserIds).stream().map(s -> Long.valueOf(s.trim())).collect(Collectors.toList());
                List<String> ccEmails = dao.queryUserEmailByIds(ccOperaIds);
                ccEmailsAll.addAll(ccEmails);
            }
            if (StringUtils.hasText(configVO.getCcEmails())) {
                List<String> ccEmails = Arrays.asList(configVO.getCcEmails().split(",")).stream().map(s -> s.trim()).collect(Collectors.toList());
                ccEmailsAll.addAll(ccEmails);
            }
        }
        return ccEmailsAll;
    }

    //全员操作
    void releaseMessageAllUser(List<PrdMessageConfigVO> allUsers, List<PrdUserMessageDO> messageDOS) {
        List<Long> userIds = null;
        List<String> emails = null;
        List<String> weComs = null;
        for (PrdMessageConfigVO messageVO : allUsers) {
            //站内信
            if (messageVO.getNoticeWay().equals(MessageNoticeWayEnum.INSTATION.getCode())) {
                if (userIds == null) {
                    userIds = dao.queryAllUser();
                }
                for (Long userId : userIds) {
                    addMessageDO(messageDOS, userId, messageVO);
                }
            }
            //邮件
            if (messageVO.getNoticeWay().equals(MessageNoticeWayEnum.EMAIL.getCode())) {
//                if (emails == null) {
//                    emails = dao.queryAllUserEmail();
//                }
                PrdSystemSettingVO systemSetting = cacheUtil.getSystemSetting(message_email);
                if (systemSetting != null) {
                    emails = Arrays.asList(systemSetting.getSettingValue());
                }
                // 获取所有抄送人电子邮件
                List<String> ccEmailsAll = getCcEmailsAll(messageVO);
                sendEmail(emails, ccEmailsAll, messageVO.getMessageTitle(), messageVO.getMessageContent());
            }
            //企业微信
            if (messageVO.getNoticeWay().equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) {
                if (weComs == null) {
                    weComs = dao.queryUserWeComByIds(new ArrayList<>());
                }
                sendWeCom(weComs, messageVO);
            }
        }
    }

    void sendWeCom(List<String> weComs, PrdMessageConfigVO messageConfigVO) {
//        /weComs.stream().filter(weCom -> StringUtils.hasText(weCom)).collect(Collectors.toList());
        String touser = org.apache.commons.lang3.StringUtils.join(weComs.stream().filter(weCom -> StringUtils.hasText(weCom)).collect(Collectors.toList()), "|");
        Map<String, Object> contentMap = new HashMap<>();
        contentMap.put("content", messageConfigVO.getMessageContent());
        Map<String, Object> map = new HashMap<>();
        map.put("touser", touser);
        map.put("msgtype", "text");
        map.put("text", contentMap);
        qyWxCommunicationService.sendMessageToUser(map);

    }

    void sendEmail(List<String> emails, List<String> ccEmails, String subject, String text) {
        JavaMailPayload mailPayload = new JavaMailPayload();
        mailPayload.setReceiveEmails(emails);
        mailPayload.setSubject(subject);
        mailPayload.setText(text);
        mailPayload.setCcEmails(ccEmails);
        mailUtil.sendEmailAsyncByAdmin(mailPayload);
    }

    void addMessageDO(List<PrdUserMessageDO> messageDOS, Long userId, PrdMessageConfigVO mvo) {
        int sortIndex = 99;
        if (StringUtils.hasText(mvo.getMessageTag())) {
            sortIndex = cacheUtil.transferSystemSelectionSortIndex(FunctionSelectionEnum.MessageTag.getCode(), mvo.getMessageTag());
        }
        PrdUserMessageDO messageDO = new PrdUserMessageDO();
        messageDO.setMessageId(mvo.getId());
        messageDO.setSortIndex(sortIndex);
        messageDO.setUserId(userId);
        messageDO.setContentBigType(mvo.getContentBigType());
        messageDO.setContentType(mvo.getContentType());
        messageDO.setCreateSource(mvo.getCreateSource());
        messageDO.setMessageContent(mvo.getMessageContent());
        messageDO.setMessageTag(mvo.getMessageTag());
        messageDO.setMessageTitle(mvo.getMessageTitle());
        messageDO.setNoticeScope(mvo.getNoticeScope());
        messageDO.setNoticeSource(mvo.getNoticeSource());
        messageDO.setTenantId(mvo.getTenantId());
        messageDOS.add(messageDO);
    }


    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public void addJobMessage(Long objectId, String action, LocalDateTime triggerTime, String createSource, String noticeSource, String title, String content, String urlTitle, String url) {
        StringBuffer messageContent = new StringBuffer();
        messageContent.append("<br/><br/>");
        messageContent.append("<div style='font-size:16px;'>");
        messageContent.append(String.format("<span style='font-size:18px;'>%s</span>", content));
        if (urlTitle != null) {
            messageContent.append(String.format("<p><a href=\"%s\">%s</a></p>", url, urlTitle));
        }
        messageContent.append("</div>");
        messageContent.append("<br/><br/>");
        messageContent.append("<br/><br/>");

        PrdMessageConfigPayload payload = new PrdMessageConfigPayload();
        payload.setObjectId(objectId);
        payload.setAction(action);
        payload.setMessageTitle(title);
        payload.setMessageContent(messageContent.toString());
        payload.setMessageType(2);
        payload.setContentBigType("businessMessage");
        payload.setContentType("crm");
        payload.setMessageTag("important");
        payload.setNoticeWay("instation");
        payload.setReleaseSource("profileMessage");
        payload.setCreateSource(createSource);
        payload.setNoticeScope("appoint_people");
        payload.setNoticeSource(noticeSource);
        payload.setTriggerTime(triggerTime);
        PrdMessageConfigVO insert = insert(payload);
//        onKeyRelease(Collections.singletonList(insert.getId()));
    }

    /**
     * @param objectId 业务数据id
     * @param action   执行的任务
     * @return
     */
    @Override
    public List<PrdMessageConfigVO> queryByObjectIdAndAction(Long objectId, String action) {
        List<PrdMessageConfigDO> messageConfig = dao.queryByObjectIdAndAction(objectId, action);
        List<PrdMessageConfigVO> prdMessageConfigVO = messageConfig.stream().map(e -> PrdMessageConfigConvert.INSTANCE.toVo(e)).collect(Collectors.toList());
        return prdMessageConfigVO;
    }

    @Override
    public PrdMessageConfigVO queryByMessageCode(String messageCode) {
        return dao.queryByMessageCode(messageCode);
    }

    @Override
    public void sendEmail(PrdMessageConfigPayload payload) {
        if(!StringUtils.hasText(payload.getSendEmails())){
            throw TwException.error("", "发送邮箱信息不存在");
        }
//        payload.setTriggerTime(LocalDateTime.now());
//        payload.setReleaseStatus(3);
//        String code = generateSeqNum("MESSAGE_CONFIG_NO");
//        payload.setMessageCode(code);
//        PrdMessageConfigDO ado = PrdMessageConfigConvert.INSTANCE.toDo(payload);
//        getCreateSource(ado);
//        ado = dao.save(ado);

        List<String> sendEmails = Arrays.asList(payload.getSendEmails().split(",")).stream().map(s -> s.trim()).collect(Collectors.toList());
        List<String> ccEmails = new ArrayList<>();
        if (StringUtils.hasText(payload.getCcEmails())) {
            ccEmails = Arrays.asList(payload.getCcEmails().split(",")).stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        sendEmail(sendEmails, ccEmails, payload.getMessageTitle(), payload.getMessageContent());
    }


    //获取发布者的资源，展示用
    void getCreateSource(PrdMessageConfigDO ado) {
        String releaseSource = ado.getReleaseSource();
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (releaseSource.equals("profileMessage") && ado.getCreateSource() != null) {
            if (user != null) {
                ado.setCreateSource(user.getUser().getFirstName());
            }
        }
//        if (releaseSource.equals("buMessage")) {
//            ado.setCreateSource(dao.queryOrgByUserId(user.getUser().getId()));
//        }
//        if (releaseSource.equals("roleMessage")) {
//            //TODO 角色暂未定义
//            ado.setCreateSource("角色");
//        }
    }

    //系统选择项翻译
    void transferSystemSelection(PrdMessageConfigVO vo) {

        vo.setContentTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ContentType.getCode(), vo.getContentType()));
        vo.setContentBigTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ContentBigType.getCode(), vo.getContentBigType()));
        vo.setReleaseSourceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ReleaseSource.getCode(), vo.getReleaseSource()));
        vo.setNoticeWayName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.NoticeWay.getCode(), vo.getNoticeWay()));
        vo.setTriggerWayName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.TriggerWay.getCode(), vo.getTriggerWay()));
        vo.setMessageTagName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.MessageTag.getCode(), vo.getMessageTag()));
        vo.setNoticeScopeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.NoticeScope.getCode(), vo.getNoticeScope()));

    }
}
