package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.demo.payload.DemoSimplePayload;
import com.elitesland.tw.tw5.api.demo.service.DemoSimpleService;
import com.elitesland.tw.tw5.api.demo.vo.DemoSimpleVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * @author yangzhibin
 * @date 2022/12/16
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "FLOW_DEMO" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class DemoWorkflowCallBackController implements WorkflowCallBack {
    private final DemoSimpleService demoSimpleService;
    private final PrdOrgEmployeeDAO employeeDAO;

    @Value("${tw5.user_default.user_id}")
    private Long default_role_id;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        String taskKey = payload.getTaskKey();
        String procDefKey = payload.getProcDefKey();
        String businessKey = payload.getBusinessKey();
        String customParams = payload.getCustomParams();
        log.info("====taskAssignee：任务节点：" + taskKey);
        ArrayList<String> userIds = taskAssigneeDemo(taskKey, businessKey, customParams);
//        ProcDefKey defKey = ProcDefKey.valueOf(procDefKey);
//        switch (defKey) {
//            case FLOW_DEMO:
//                userIds = taskAssigneeDemo(taskKey, businessKey, customParams);
//                break;
//            default:
//        }
        return WorkflowResult.success(userIds);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
      return   WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return   WorkflowResult.success(null);
    }

    /**
     * 动态指派操作人
     *
     * @param taskKey      任务key(流程审批节点的key)
     * @param businessKey  业务key
     * @param customParams 自定义参数
     */
    private ArrayList<String> taskAssigneeDemo(String taskKey, String businessKey, String customParams) {
        //根据业务key查询当前业务对象
        DemoSimpleVO demoSimpleVO = demoSimpleService.queryByKey(Long.valueOf(businessKey));
        ArrayList<String> list = new ArrayList<>();
        if (demoSimpleVO != null) {
            if (taskKey.equals("Activity_1gfnttf")) {
                //申请人上级
                Long createUserId = demoSimpleVO.getCreateUserId();
                PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(createUserId);
                Long parentId = prdOrgEmployeeRefVO.getParentId();
                if (parentId != null) {
                    list.add(parentId.toString());
                } else {
                    list.add(default_role_id + "");
//                    throw TwException.error("","申请人的资源上级为空，请联系管理员！");
                }
            }
            if (taskKey.equals("Activity_14qkle1")) {
                //指派王贝贝
                list.add("579786202115344318");
            }
        }
        return list;
    }


    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        DemoSimplePayload demoSimplePayload = new DemoSimplePayload();
        demoSimplePayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        DemoSimpleVO demoSimpleVO = demoSimpleService.queryByKey(Long.valueOf(businessKey));
        if (demoSimpleVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    demoSimplePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    demoSimplePayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                case INVALID://先删除流程再删除单据
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.INVALID.getCode());
                    demoSimplePayload.setDeleteFlag(1);
                    demoSimplePayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    demoSimplePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    demoSimplePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    demoSimplePayload.setApprovedTime(LocalDateTime.now());
                    break;
                case APPROVING:
                    demoSimplePayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            }
//            demoSimpleDAO.updateByKeyDynamic(demoSimplePayload);
        }
       return WorkflowResult.success(null);
    }
}
