/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import com.elitesland.tw.tw5.server.common.NotOnlineException;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwMessage;
import com.elitesland.workflow.exception.WorkflowException;
import java.util.ArrayList;
import java.util.List;

public class TwOutputUtil<T> {
    private String code;
    private boolean ok;
    private T data;
    private List<TwMessage> infos = new ArrayList<TwMessage>();
    private List<TwMessage> errors = new ArrayList<TwMessage>();
    private List<TwMessage> warns = new ArrayList<TwMessage>();

    private TwOutputUtil(boolean ok) {
        this.ok = ok;
    }

    public static TwOutputUtil output(boolean ok) {
        return new TwOutputUtil(ok);
    }

    public static TwOutputUtil ok() {
        TwOutputUtil outputUtil = new TwOutputUtil(true);
        outputUtil.infos.add(TwMessage.of("COM-SUCCESS", "\u64cd\u4f5c\u6210\u529f", null));
        return outputUtil;
    }

    public static <T> TwOutputUtil ok(T data) {
        TwOutputUtil<T> outputUtil = new TwOutputUtil<T>(true);
        outputUtil.setData(data);
        outputUtil.infos.add(TwMessage.of("COM-SUCCESS", "\u64cd\u4f5c\u6210\u529f", null));
        return outputUtil;
    }

    public static TwOutputUtil ok(String localeCode, String defaultMsg, Object data) {
        TwOutputUtil outputUtil = new TwOutputUtil(true);
        outputUtil.data = data;
        outputUtil.infos.add(TwMessage.of(localeCode, defaultMsg, data));
        return outputUtil;
    }

    public static TwOutputUtil error() {
        TwOutputUtil outputUtil = new TwOutputUtil(false);
        outputUtil.errors.add(TwMessage.of("COM-ERROR", "\u64cd\u4f5c\u5931\u8d25", null));
        return outputUtil;
    }

    public static TwOutputUtil error(String localeCode, String defaultMsg, Object data) {
        TwOutputUtil outputUtil = new TwOutputUtil(false);
        outputUtil.data = data;
        outputUtil.errors.add(TwMessage.of(localeCode, defaultMsg, data));
        return outputUtil;
    }

    public static TwOutputUtil error(String localeCode, String defaultMsg) {
        return TwOutputUtil.error(localeCode, defaultMsg, null);
    }

    public static TwOutputUtil error(String defaultMsg) {
        return TwOutputUtil.error("", defaultMsg, null);
    }

    public static TwOutputUtil addException(Exception exception) {
        TwOutputUtil outputUtil = new TwOutputUtil(false);
        outputUtil.errors.add(TwMessage.of("EXCEPTION", exception.getMessage(), null));
        return outputUtil;
    }

    public static TwOutputUtil addTwException(TwException twException) {
        TwOutputUtil outputUtil = new TwOutputUtil(false);
        outputUtil.data = twException.getData();
        outputUtil.code = twException.getCode();
        outputUtil.errors = twException.getErrors();
        outputUtil.warns = twException.getWarns();
        return outputUtil;
    }

    public static TwOutputUtil addNotOnlineException(NotOnlineException notOnlineException) {
        TwOutputUtil outputUtil = new TwOutputUtil(false);
        outputUtil.errors = notOnlineException.getErrors();
        outputUtil.warns = notOnlineException.getWarns();
        return outputUtil;
    }

    public static TwOutputUtil addWorkflowException(WorkflowException workflowException) {
        TwOutputUtil outputUtil = new TwOutputUtil(false);
        outputUtil.addError("" + workflowException.getCode(), workflowException.getMessage(), null);
        return outputUtil;
    }

    public TwOutputUtil addError(String localeCode, String defaultMsg, Object data) {
        this.errors.add(TwMessage.of(localeCode, defaultMsg, data));
        return this;
    }

    public static TwOutputUtil warn() {
        TwOutputUtil outputUtil = new TwOutputUtil(false);
        outputUtil.warns.add(TwMessage.of("COM-WARN", "\u662f\u5426\u786e\u8ba4\uff1f", null));
        return outputUtil;
    }

    public static TwOutputUtil warn(String localeCode, String defaultMsg, Object data) {
        TwOutputUtil outputUtil = new TwOutputUtil(false);
        outputUtil.data = data;
        outputUtil.warns.add(TwMessage.of(localeCode, defaultMsg, data));
        return outputUtil;
    }

    public TwOutputUtil addWarn(String localeCode, String defaultMsg, Object data) {
        this.warns.add(TwMessage.of(localeCode, defaultMsg, data));
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isOk() {
        return this.ok;
    }

    public T getData() {
        return this.data;
    }

    public List<TwMessage> getInfos() {
        return this.infos;
    }

    public List<TwMessage> getErrors() {
        return this.errors;
    }

    public List<TwMessage> getWarns() {
        return this.warns;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setInfos(List<TwMessage> infos) {
        this.infos = infos;
    }

    public void setErrors(List<TwMessage> errors) {
        this.errors = errors;
    }

    public void setWarns(List<TwMessage> warns) {
        this.warns = warns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwOutputUtil)) {
            return false;
        }
        TwOutputUtil other = (TwOutputUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOk() != other.isOk()) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        List<TwMessage> this$infos = this.getInfos();
        List<TwMessage> other$infos = other.getInfos();
        if (this$infos == null ? other$infos != null : !((Object)this$infos).equals(other$infos)) {
            return false;
        }
        List<TwMessage> this$errors = this.getErrors();
        List<TwMessage> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<TwMessage> this$warns = this.getWarns();
        List<TwMessage> other$warns = other.getWarns();
        return !(this$warns == null ? other$warns != null : !((Object)this$warns).equals(other$warns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TwOutputUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOk() ? 79 : 97);
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        List<TwMessage> $infos = this.getInfos();
        result = result * 59 + ($infos == null ? 43 : ((Object)$infos).hashCode());
        List<TwMessage> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<TwMessage> $warns = this.getWarns();
        result = result * 59 + ($warns == null ? 43 : ((Object)$warns).hashCode());
        return result;
    }

    public String toString() {
        return "TwOutputUtil(code=" + this.getCode() + ", ok=" + this.isOk() + ", data=" + this.getData() + ", infos=" + this.getInfos() + ", errors=" + this.getErrors() + ", warns=" + this.getWarns() + ")";
    }
}

