/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.change.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.change.payload.PrdSystemBusinessChangePayload;
import com.elitesland.tw.tw5.api.common.change.query.PrdSystemBusinessChangeQuery;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeFlagEnum;
import com.elitesland.tw.tw5.server.common.change.dao.PrdSystemBusinessChangeDAO;
import com.elitesland.tw.tw5.server.common.change.entity.PrdSystemBusinessChangeDO;
import com.elitesland.tw.tw5.server.common.change.repo.PrdSystemBusinessChangeRepo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="comBusinessChangeService")
public class PrdSystemBusinessChangeServiceImpl
implements PrdSystemBusinessChangeService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemBusinessChangeServiceImpl.class);
    private final PrdSystemBusinessChangeDAO dao;
    private final PrdSystemBusinessChangeRepo repo;

    @Transactional(rollbackOn={Exception.class})
    public Long saveNewLog(String changeType, BaseViewModel versionContent, String parentChangeType, String parentChangeDocId, Integer activeFlag) {
        Integer currentActiveVersion;
        int initVersionNo = 0;
        if (parentChangeType != null && parentChangeDocId != null && (currentActiveVersion = this.getCurrentActiveVersion(parentChangeType, parentChangeDocId)) != null) {
            initVersionNo = activeFlag == 1 ? 0 : currentActiveVersion + 1;
        }
        PrdSystemBusinessChangeDO changeDO = new PrdSystemBusinessChangeDO().setChangeType(changeType).setChangeDocId(versionContent.getId() == null ? "-1" : versionContent.getId().toString()).setVersionNo(initVersionNo).setVersionContent(JSONObject.toJSONString((Object)versionContent, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat})).setVersionStatus(activeFlag).setParentChangeType(parentChangeType).setParentChangeDocId(parentChangeDocId);
        changeDO.setCreateUserId(versionContent.getCreateUserId());
        PrdSystemBusinessChangeDO changeSave = this.dao.save(changeDO);
        if (changeSave == null) {
            return -1L;
        }
        return changeSave.getId();
    }

    public void updateVersionContent(Long logId, BaseViewModel baseViewModel) {
        PrdSystemBusinessChangeDO changeDO = this.repo.findById(logId).orElse(null);
        if (changeDO != null) {
            changeDO.setChangeDocId(baseViewModel.getId().toString());
            changeDO.setVersionContent(JSONObject.toJSONString((Object)baseViewModel, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
            this.repo.save((Object)changeDO);
        }
    }

    public Long saveVersionLog(String changeType, TwCommonPayload changePayload, String parentChangeType, String parentChangeDocId) {
        Integer newVersion = 0;
        if (parentChangeType != null && parentChangeDocId != null) {
            Integer currentActiveVersion = this.getCurrentActiveVersion(parentChangeType, parentChangeDocId);
            if (currentActiveVersion != null) {
                newVersion = currentActiveVersion + 1;
            }
        } else {
            Integer currentVersion = this.repo.findCurrentActiveVersion(changeType, changePayload.getId().toString());
            newVersion = currentVersion + 1;
            if (currentVersion == null) {
                throw TwException.error("", "\u672a\u627e\u5230\u4e0a\u4e00\u7248\u672c\u7684\u53d8\u66f4\u65e5\u5fd7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
        }
        PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
        if (changePayload.getId() == null) {
            query.setId(changePayload.getChangeLogId());
        } else {
            query.setChangeDocId(changePayload.getId().toString());
        }
        query.setChangeType(changeType);
        query.setVersionNo(newVersion);
        List<PrdSystemBusinessChangeVO> changeVOS = this.dao.queryListDynamic(query);
        if (changeVOS != null && !changeVOS.isEmpty()) {
            if (changePayload.getDeleteFlag() != null && changePayload.getDeleteFlag() == 1) {
                PrdSystemBusinessChangePayload payload = new PrdSystemBusinessChangePayload();
                payload.setChangeContent(null);
                payload.setId(changeVOS.get(0).getId());
                this.dao.updateByKeyDynamic(payload);
            } else {
                String changeContent = changeVOS.get(0).getChangeContent();
                HashMap changeContentMap = changeContent == null ? new HashMap() : JSON.parseObject((String)changeContent);
                JSONObject changeValue = JSON.parseObject((String)JSON.toJSONString((Object)changePayload, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
                changeContentMap.putAll(changeValue);
                PrdSystemBusinessChangePayload payload = new PrdSystemBusinessChangePayload();
                payload.setChangeContent(JSONObject.toJSONString(changeContentMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
                payload.setId(changeVOS.get(0).getId());
                this.dao.updateByKeyDynamic(payload);
            }
            return changeVOS.get(0).getId();
        }
        PrdSystemBusinessChangeDO changeDO = new PrdSystemBusinessChangeDO().setChangeType(changeType).setChangeDocId(changePayload.getId().toString()).setVersionNo(newVersion).setChangeContent(JSONObject.toJSONString((Object)changePayload, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat})).setVersionStatus(0).setParentChangeType(parentChangeType).setParentChangeDocId(parentChangeDocId);
        PrdSystemBusinessChangeDO changeSave = this.dao.save(changeDO);
        if (changeSave == null) {
            return -1L;
        }
        return changeSave.getId();
    }

    @Transactional
    public void deleteCurrentVersionLog(String changeType, String docId) {
        Long currentVersionId = this.repo.findCurrentVersionId(changeType, docId);
        PrdSystemBusinessChangePayload payload = new PrdSystemBusinessChangePayload();
        payload.setId(currentVersionId);
        payload.setDeleteFlag(Integer.valueOf(1));
        this.dao.updateByKeyDynamic(payload);
        List<PrdSystemBusinessChangeVO> changeLogChildrenLogs = this.getChangeLogChildrenLogs(changeType, docId, payload.getVersionNo());
        if (changeLogChildrenLogs != null && changeLogChildrenLogs.isEmpty()) {
            for (PrdSystemBusinessChangeVO changeLogChildrenLog : changeLogChildrenLogs) {
                PrdSystemBusinessChangePayload childPayload = new PrdSystemBusinessChangePayload();
                childPayload.setId(changeLogChildrenLog.getId());
                childPayload.setDeleteFlag(Integer.valueOf(1));
                this.dao.updateByKeyDynamic(childPayload);
            }
        }
    }

    @Transactional
    public Map<String, Object> activeCurrentVersionLog(String changeType, String docId) {
        Long currentVersionId = this.repo.findCurrentVersionId(changeType, docId);
        PrdSystemBusinessChangePayload payload = new PrdSystemBusinessChangePayload();
        payload.setVersionStatus(Integer.valueOf(1));
        payload.setId(currentVersionId);
        PrdSystemBusinessChangeVO mainTicketVo = this.mergeVersionByCurrentDocId(payload.getId());
        payload.setVersionContent(mainTicketVo.getVersionContent());
        this.dao.updateByKeyDynamic(payload);
        Integer currentVersion = this.repo.findCurrentVersion(changeType, docId);
        List<PrdSystemBusinessChangeVO> changeLogChildrenLogs = this.getChangeLogChildrenLogs(changeType, docId, currentVersion);
        if (changeLogChildrenLogs != null && !changeLogChildrenLogs.isEmpty()) {
            for (PrdSystemBusinessChangeVO prdSystemBusinessChangeVO : changeLogChildrenLogs) {
                PrdSystemBusinessChangePayload childPayload = new PrdSystemBusinessChangePayload();
                childPayload.setId(prdSystemBusinessChangeVO.getId());
                childPayload.setVersionStatus(Integer.valueOf(1));
                PrdSystemBusinessChangeVO prdSystemBusinessChangeVO2 = this.mergeVersionByCurrentDocId(prdSystemBusinessChangeVO.getId());
                childPayload.setVersionContent(prdSystemBusinessChangeVO2.getVersionContent());
                this.dao.updateByKeyDynamic(childPayload);
            }
        }
        if (currentVersion > 0) {
            List<PrdSystemBusinessChangeVO> lastVersionChildrenLogs = this.getChangeLogChildrenLogs(changeType, docId, currentVersion - 1);
            for (PrdSystemBusinessChangeVO lastVersionChildrenLog : lastVersionChildrenLogs) {
                if (changeLogChildrenLogs.contains(lastVersionChildrenLog)) continue;
                PrdSystemBusinessChangeDO changeDO = new PrdSystemBusinessChangeDO().setChangeType(lastVersionChildrenLog.getChangeType()).setChangeDocId(lastVersionChildrenLog.getChangeDocId()).setVersionNo(currentVersion).setVersionContent(lastVersionChildrenLog.getVersionContent()).setVersionStatus(1).setParentChangeType(changeType).setParentChangeDocId(docId);
                this.dao.save(changeDO);
            }
        }
        PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = this.dao.queryByKey(currentVersionId);
        String string = prdSystemBusinessChangeVO.getVersionContent();
        JSONObject result = JSON.parseObject((String)string);
        Map<String, List<Map<String, Object>>> changeLogChildList = this.getChangeLogChildList(changeType, docId, mainTicketVo.getVersionNo());
        result.putAll(changeLogChildList);
        return result;
    }

    public List<PrdSystemBusinessChangeVO> getChangeLogChildrenLogs(String parentChangeType, String parentDocId, Integer currentVersion) {
        HashMap result = new HashMap();
        PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
        query.setParentChangeType(parentChangeType);
        query.setParentChangeDocId(parentDocId);
        query.setVersionNo(currentVersion);
        return this.dao.queryListDynamic(query);
    }

    public Integer getCurrentVersion(String changeType, String docId) {
        return this.repo.findCurrentVersion(changeType, docId);
    }

    public Long getCurrentVersionId(String changeType, String docId) {
        return this.repo.findCurrentVersionId(changeType, docId);
    }

    public Integer getCurrentActiveVersion(String changeType, String docId) {
        return this.repo.findCurrentActiveVersion(changeType, docId);
    }

    public Integer getInitVersion(String changeType, String docId) {
        return this.repo.findInitVersion(changeType, docId);
    }

    public List<PrdSystemBusinessChangeVO> getChangeLogList(String changeType, String docId) {
        PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
        query.setChangeDocId(docId);
        query.setChangeType(changeType);
        return this.dao.queryListDynamic(query);
    }

    public Map<String, Object> getChangeLogDetail(Long id, Long compareLogId) {
        PrdSystemBusinessChangeVO changeLogDetail = this.dao.queryByKey(id);
        if (compareLogId == null) {
            if (changeLogDetail.getVersionStatus() == 0) {
                PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
                query.setChangeDocId(changeLogDetail.getChangeDocId());
                query.setChangeType(changeLogDetail.getChangeType());
                query.setVersionNo(Integer.valueOf(changeLogDetail.getVersionNo() - 1));
                List<PrdSystemBusinessChangeVO> changeVOS = this.dao.queryListDynamic(query);
                compareLogId = changeVOS != null && !changeVOS.isEmpty() ? changeVOS.get(0).getId() : Long.valueOf(-1L);
            } else {
                JSONObject versionValue = JSON.parseObject((String)changeLogDetail.getVersionContent());
                Map<String, List<Map<String, Object>>> changeLogChildList = this.getChangeLogChildList(changeLogDetail.getChangeType(), changeLogDetail.getChangeDocId(), changeLogDetail.getVersionNo());
                versionValue.putAll(changeLogChildList);
                return versionValue;
            }
        }
        PrdSystemBusinessChangeVO compareLogDetail = this.dao.queryByKey(compareLogId);
        Integer versionNo = changeLogDetail.getVersionNo();
        if (versionNo < 1) {
            JSONObject versionValue = JSON.parseObject((String)changeLogDetail.getVersionContent());
            Map<String, List<Map<String, Object>>> changeLogChildList = this.getChangeLogChildList(changeLogDetail.getChangeType(), changeLogDetail.getChangeDocId(), changeLogDetail.getVersionNo());
            versionValue.putAll(changeLogChildList);
            return versionValue;
        }
        if (changeLogDetail.getVersionStatus() == 0) {
            if (compareLogDetail.getVersionNo() < versionNo - 1) {
                PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
                query.setChangeDocId(changeLogDetail.getChangeDocId());
                query.setChangeType(changeLogDetail.getChangeType());
                query.setVersionNo(Integer.valueOf(versionNo - 1));
                List<PrdSystemBusinessChangeVO> prdSystemBusinessChangeVOS = this.dao.queryListDynamic(query);
                if (prdSystemBusinessChangeVOS == null || prdSystemBusinessChangeVOS.isEmpty()) {
                    throw TwException.error("", "\u672a\u67e5\u8be2\u5230\u5386\u53f2\u7248\u672c\u7684\u6570\u636e");
                }
                JSONObject compareVersionContent = JSON.parseObject((String)compareLogDetail.getVersionContent());
                String versionContent = prdSystemBusinessChangeVOS.get(0).getVersionContent();
                JSONObject baseVersionContent = JSON.parseObject((String)versionContent);
                JSONObject currentChangeContent = JSON.parseObject((String)changeLogDetail.getChangeContent());
                baseVersionContent.putAll(currentChangeContent);
                Map<String, Object> versionValue = this.simpleCompare((Map<String, Object>)compareVersionContent, (Map<String, Object>)baseVersionContent);
                Map<String, List<Map<String, Object>>> childVersionValue = this.listCompare(changeLogDetail.getParentChangeType(), changeLogDetail.getParentChangeDocId(), changeLogDetail.getVersionNo(), compareLogDetail.getVersionNo());
                versionValue.putAll(childVersionValue);
                return versionValue;
            }
            String versionContent = compareLogDetail.getVersionContent();
            JSONObject lastVersionContent = JSON.parseObject((String)versionContent);
            JSONObject currentChangeContent = JSON.parseObject((String)changeLogDetail.getChangeContent());
            Map<String, Object> versionValue = this.simpleCompare((Map<String, Object>)lastVersionContent, (Map<String, Object>)currentChangeContent);
            Map<String, List<Map<String, Object>>> childVersionValue = this.listCompare(changeLogDetail.getChangeType(), changeLogDetail.getChangeDocId(), changeLogDetail.getVersionNo(), compareLogDetail.getVersionNo());
            versionValue.putAll(childVersionValue);
            return versionValue;
        }
        JSONObject compareVersionContent = JSON.parseObject((String)compareLogDetail.getVersionContent());
        JSONObject currentVersionContent = JSON.parseObject((String)changeLogDetail.getVersionContent());
        Map<String, Object> versionValue = this.simpleCompare((Map<String, Object>)compareVersionContent, (Map<String, Object>)currentVersionContent);
        Map<String, List<Map<String, Object>>> childVersionValue = this.listCompare(changeLogDetail.getChangeType(), changeLogDetail.getChangeDocId(), changeLogDetail.getVersionNo(), compareLogDetail.getVersionNo());
        versionValue.putAll(childVersionValue);
        return versionValue;
    }

    private Map<String, Object> simpleCompare(Map<String, Object> oldMap, Map<String, Object> newMap) {
        HashMap<String, Object> comparedMap = new HashMap<String, Object>();
        comparedMap.putAll(oldMap);
        for (String lastKey : oldMap.keySet()) {
            for (String currentKey : newMap.keySet()) {
                if (lastKey.equals(currentKey) && oldMap.get(lastKey) == null) {
                    if (newMap.get(currentKey) == null) continue;
                    comparedMap.put(lastKey + "_$$_new", newMap.get(currentKey));
                    continue;
                }
                if (lastKey.equals(currentKey) && newMap.get(currentKey) == null) {
                    if (oldMap.get(lastKey) == null) continue;
                    comparedMap.put(lastKey + "_$$_new", null);
                    continue;
                }
                if (!lastKey.equals(currentKey) || this.checkEquals(oldMap.get(lastKey).toString(), newMap.get(currentKey).toString())) continue;
                Object o = newMap.get(currentKey);
                comparedMap.put(lastKey + "_$$_new", newMap.get(currentKey));
            }
        }
        return comparedMap;
    }

    private boolean checkEquals(String value1, String value2) {
        if (PrdSystemBusinessChangeServiceImpl.isNumeric(value1) && PrdSystemBusinessChangeServiceImpl.isNumeric(value2)) {
            value1 = new BigDecimal(value1).stripTrailingZeros().toPlainString();
            value2 = new BigDecimal(value2).stripTrailingZeros().toPlainString();
        }
        return value1.equals(value2);
    }

    public static boolean isNumeric(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        String regx = "[+-]*\\d+\\.?\\d*[Ee]*[+-]*\\d+";
        Pattern pattern = Pattern.compile(regx);
        boolean isNumber = pattern.matcher(str).matches();
        if (isNumber) {
            return isNumber;
        }
        regx = "^[-\\+]?[.\\d]*$";
        pattern = Pattern.compile(regx);
        return pattern.matcher(str).matches();
    }

    private Map<String, List<Map<String, Object>>> listCompare(String parentChangeType, String parentDocId, Integer currentVersion, Integer compareVersion) {
        Map<Object, Object> comparedResult = new HashMap();
        Map<String, List<Map<String, Object>>> currentVersionChilden = this.getChangeLogChildList(parentChangeType, parentDocId, currentVersion);
        Map<String, List<Map<String, Object>>> compareVersionChilden = this.getChangeLogChildList(parentChangeType, parentDocId, compareVersion);
        if (currentVersionChilden != null && !currentVersionChilden.isEmpty()) {
            for (String currentVersionKey : currentVersionChilden.keySet()) {
                if (compareVersionChilden != null && !compareVersionChilden.isEmpty()) {
                    boolean compareFlag = false;
                    for (String string : compareVersionChilden.keySet()) {
                        if (!currentVersionKey.equals(string)) continue;
                        compareFlag = true;
                        List<Map<String, Object>> currentList = currentVersionChilden.get(currentVersionKey);
                        List<Map<String, Object>> compareList = compareVersionChilden.get(currentVersionKey);
                        if (currentList != null && !currentList.isEmpty()) {
                            if (compareList != null && !compareList.isEmpty()) {
                                for (Map<String, Object> currentData : currentList) {
                                    if (currentData.get("deleteFlag") != null && currentData.get("deleteFlag").equals(1)) {
                                        currentData.put("changeFlag", (Object)ChangeFlagEnum.DELETE);
                                        continue;
                                    }
                                    boolean compared = false;
                                    for (Map<String, Object> compareData : compareList) {
                                        if (currentData.get("id") == null || !currentData.get("id").equals(compareData.get("id"))) continue;
                                        compared = true;
                                        Map<String, Object> stringObjectMap = this.simpleCompare(compareData, currentData);
                                        currentData.putAll(stringObjectMap);
                                    }
                                    if (compared) continue;
                                    currentData.put("changeFlag", (Object)ChangeFlagEnum.ADD);
                                }
                                for (Map<String, Object> compareData : compareList) {
                                    boolean isExist = false;
                                    for (Map<String, Object> currentData : currentList) {
                                        if (currentData.get("id") == null || !currentData.get("id").equals(compareData.get("id"))) continue;
                                        isExist = true;
                                    }
                                    if (isExist) continue;
                                    currentList.add(compareData);
                                }
                            } else {
                                for (Map<String, Object> map : currentList) {
                                    map.put("changFlag", (Object)ChangeFlagEnum.DELETE);
                                }
                            }
                        } else if (compareList != null && !compareList.isEmpty()) {
                            for (Map<String, Object> map : compareList) {
                                map.put("changFlag", (Object)ChangeFlagEnum.DELETE);
                                currentList.add(map);
                            }
                        }
                        currentVersionChilden.put(currentVersionKey, currentList);
                        break;
                    }
                    if (compareFlag) continue;
                }
                List<Map<String, Object>> maps = currentVersionChilden.get(currentVersionKey);
                if (maps == null || maps.isEmpty()) continue;
                for (Map map : maps) {
                    map.put("changFlag", ChangeFlagEnum.ADD);
                }
            }
            comparedResult = currentVersionChilden;
        } else {
            if (compareVersionChilden != null && !compareVersionChilden.isEmpty()) {
                for (String compareVersionKey : compareVersionChilden.keySet()) {
                    List<Map<String, Object>> maps = compareVersionChilden.get(compareVersionKey);
                    if (maps == null || maps.isEmpty()) continue;
                    for (Map<String, Object> map : maps) {
                        map.put("changFlag", (Object)ChangeFlagEnum.DELETE);
                    }
                }
            }
            comparedResult = compareVersionChilden;
        }
        return comparedResult;
    }

    private Map<String, List<Map<String, Object>>> getChangeLogChildList(String parentChangeType, String parentDocId, Integer currentVersion) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
        query.setParentChangeType(parentChangeType);
        query.setParentChangeDocId(parentDocId);
        query.setVersionNo(currentVersion);
        List<PrdSystemBusinessChangeVO> prdSystemBusinessChangeVOS = this.dao.queryListDynamic(query);
        Map<String, List<PrdSystemBusinessChangeVO>> collect = prdSystemBusinessChangeVOS.stream().collect(Collectors.groupingBy(PrdSystemBusinessChangeVO::getChangeType));
        for (String changeType : collect.keySet()) {
            ArrayList<JSONObject> childContent = new ArrayList<JSONObject>();
            List<PrdSystemBusinessChangeVO> changeVOS = collect.get(changeType);
            for (PrdSystemBusinessChangeVO prdSystemBusinessChangeVO : changeVOS) {
                if (prdSystemBusinessChangeVO.getVersionNo() > 0) {
                    JSONObject currentChangeContent;
                    if (prdSystemBusinessChangeVO.getChangeDocId().equals("-1")) {
                        JSONObject addData = JSON.parseObject((String)prdSystemBusinessChangeVO.getVersionContent());
                        addData.put("changeLogId", prdSystemBusinessChangeVO.getId());
                        childContent.add(addData);
                        continue;
                    }
                    PrdSystemBusinessChangeQuery lastQuery = new PrdSystemBusinessChangeQuery();
                    lastQuery.setChangeDocId(prdSystemBusinessChangeVO.getChangeDocId());
                    lastQuery.setChangeType(prdSystemBusinessChangeVO.getChangeType());
                    lastQuery.setVersionNo(Integer.valueOf(prdSystemBusinessChangeVO.getVersionNo() - 1));
                    List<PrdSystemBusinessChangeVO> lastVersion = this.dao.queryListDynamic(lastQuery);
                    JSONObject baseVersionContent = new HashMap();
                    if (lastVersion != null && !lastVersion.isEmpty()) {
                        String versionContent = lastVersion.get(0).getVersionContent();
                        baseVersionContent = JSON.parseObject((String)versionContent);
                    }
                    if ((currentChangeContent = JSON.parseObject((String)prdSystemBusinessChangeVO.getChangeContent())) != null) {
                        currentChangeContent.put("changeLogId", prdSystemBusinessChangeVO.getId());
                        baseVersionContent.putAll(currentChangeContent);
                    } else {
                        JSONObject currentVersionContent = JSON.parseObject((String)prdSystemBusinessChangeVO.getVersionContent());
                        if (currentVersionContent != null) {
                            currentVersionContent.put("changeLogId", prdSystemBusinessChangeVO.getId());
                            baseVersionContent.putAll(currentVersionContent);
                        }
                    }
                    childContent.add(JSON.parseObject((String)JSON.toJSONString((Object)baseVersionContent, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat})));
                    continue;
                }
                childContent.add(JSON.parseObject((String)prdSystemBusinessChangeVO.getVersionContent()));
            }
            result.put(changeType, childContent);
        }
        return result;
    }

    public void deleteById(Long docId) {
        PrdSystemBusinessChangeDO changeDO = (PrdSystemBusinessChangeDO)((Object)this.repo.findById(docId).get());
        changeDO.setDeleteFlag(1);
        this.repo.save((Object)changeDO);
    }

    public PrdSystemBusinessChangeVO mergeVersionByCurrentDocId(Long changeLogId) {
        PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = this.dao.queryByKey(changeLogId);
        if (prdSystemBusinessChangeVO.getVersionStatus() == 1) {
            return prdSystemBusinessChangeVO;
        }
        if (prdSystemBusinessChangeVO.getVersionContent() == null) {
            PrdSystemBusinessChangeQuery lastQuery = new PrdSystemBusinessChangeQuery();
            lastQuery.setChangeDocId(prdSystemBusinessChangeVO.getChangeDocId());
            lastQuery.setChangeType(prdSystemBusinessChangeVO.getChangeType());
            lastQuery.setVersionNo(Integer.valueOf(prdSystemBusinessChangeVO.getVersionNo() - 1));
            List<PrdSystemBusinessChangeVO> lastVersion = this.dao.queryListDynamic(lastQuery);
            PrdSystemBusinessChangeVO baseVersion = lastVersion.get(0);
            String versionContent = baseVersion.getVersionContent();
            JSONObject baseVersionContent = JSON.parseObject((String)versionContent);
            JSONObject currentChangeContent = JSON.parseObject((String)prdSystemBusinessChangeVO.getChangeContent());
            currentChangeContent.put("changeLogId", prdSystemBusinessChangeVO.getId());
            baseVersionContent.putAll(currentChangeContent);
            prdSystemBusinessChangeVO.setVersionContent(JSON.toJSONString((Object)baseVersionContent, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
        }
        return prdSystemBusinessChangeVO;
    }

    public PrdSystemBusinessChangeServiceImpl(PrdSystemBusinessChangeDAO dao, PrdSystemBusinessChangeRepo repo) {
        this.dao = dao;
        this.repo = repo;
    }
}

