/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.controller;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgTenantEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u5458\u5de5\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/org"})
public class PrdOrgEmployeeController {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgEmployeeController.class);
    private final PrdOrgEmployeeService service;

    @ApiOperation(value="\u6613\u7a3b\u58f3\u6279\u91cf\u65b0\u589e")
    @PostMapping(value={"/employee/yeedocBatchInsert"})
    public TwOutputUtil yeedocBatchInsert(@RequestBody List<PrdOrgEmployeePayload> entitys) {
        return TwOutputUtil.ok(this.service.yeedocBatchInsert(entitys));
    }

    @ApiOperation(value="\u6613\u7a3b\u58f3\u65b0\u589e")
    @PostMapping(value={"/employee/yeedocInsert"})
    public TwOutputUtil yeedocInsert(@RequestBody PrdOrgEmployeePayload entity) {
        return TwOutputUtil.ok(this.service.yeedocInsert(entity));
    }

    @PostMapping(value={"/employee/saveTenantUser"})
    public TwOutputUtil saveTenantUser(PrdOrgTenantEmployeePayload entity) {
        return TwOutputUtil.ok(this.service.saveTenantUser(entity));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/employee/insert"})
    public TwOutputUtil insert(@RequestBody PrdOrgEmployeePayload entity) {
        return TwOutputUtil.ok(this.service.insert(entity));
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/employee/update"})
    public TwOutputUtil update(@RequestBody PrdOrgEmployeePayload entity) {
        this.service.update(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539\u5458\u5de5\u7ec4\u7ec7\u5173\u7cfb")
    @PutMapping(value={"/employee/updateEmployeeRef"})
    public TwOutputUtil updateEmployeeRef(String payloadStrs) {
        this.service.updateEmployeeRef(JSONObject.parseArray((String)payloadStrs, PrdOrgEmployeeRefPayload.class));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4eba\u5458\u9009\u62e9\u5668")
    @GetMapping(value={"/employee/list"})
    public TwOutputUtil queryList(PrdOrgEmployeeQuery query) {
        List list = this.service.queryList(query);
        return TwOutputUtil.ok(list);
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    @GetMapping(value={"/employee/pading"})
    public TwOutputUtil queryPading(PrdOrgEmployeeQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    @GetMapping(value={"/employee/{key}"})
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdOrgEmployeeVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u6240\u6709\u4e0a\u7ea7id")
    @GetMapping(value={"/employee/queryParentIds/{key}"})
    public TwOutputUtil queryParentIds(@PathVariable Long key) {
        return TwOutputUtil.ok(this.service.queryParentIdsByUserId(key));
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/employee/delete"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u79fb\u9664\u5458\u5de5\u7ec4\u7ec7")
    @PutMapping(value={"/employee/deleteOrg"})
    public TwOutputUtil deleteOrg(Long userId, Long[] orgIds) {
        this.service.deleteOrgRefSoft(userId, Arrays.asList(orgIds));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @GetMapping(value={"/employee/resetEmployeePawword/{userId}"})
    public TwOutputUtil resetEmployeePawword(@PathVariable Long userId) {
        this.service.resetEmployeePawword(userId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/employee/updateWecomId"})
    public TwOutputUtil updateWecomId(Long[] userId) {
        List<Long> userIdsData = null;
        if (userId != null && userId.length > 0) {
            userIdsData = Arrays.asList(userId);
        }
        this.service.updateWecomId(userIdsData);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u6240\u6709\u4e0b\u7ea7id")
    @GetMapping(value={"/employee/queryLowerUserIds/{key}"})
    public TwOutputUtil queryLowerUserIds(@PathVariable Long key) {
        return TwOutputUtil.ok(this.service.querySubordinatesIdsByUserId(key));
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/employee/batchExport"})
    public void batchExport(HttpServletResponse response, PrdOrgEmployeeQuery query) {
        this.service.downloadPlus(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/employee/batchImport"}, consumes={"multipart/form-data"})
    public TwOutputUtil batchImport(MultipartFile file) {
        this.service.importEmployees(file);
        return TwOutputUtil.ok();
    }

    public PrdOrgEmployeeController(PrdOrgEmployeeService service) {
        this.service = service;
    }
}

