/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdMessageConfigQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.crontask.XxlJobInfo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.MessageNoticeWayEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserMessageDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QPrdUserMessageDO;
import com.elitesland.tw.tw5.server.prd.my.repo.PrdUserMessageRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdMessageConfigDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdMessageConfigRepo repo;
    private final PrdUserMessageRepo repoUser;
    private final QPrdMessageConfigDO qdo = QPrdMessageConfigDO.prdMessageConfigDO;
    private final QPrdUserMessageDO qdoUser = QPrdUserMessageDO.prdUserMessageDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgEmployeeRefDO qdoEmployeeRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgPersonDO qdoPerson = QPrdOrgPersonDO.prdOrgPersonDO;
    private final QPrdSystemRoleDO qdoRole = QPrdSystemRoleDO.prdSystemRoleDO;
    private final QPrdSystemUserRoleDO qdoUserRole = QPrdSystemUserRoleDO.prdSystemUserRoleDO;
    private final EntityManager em;

    public PrdMessageConfigDO save(PrdMessageConfigDO ado) {
        return (PrdMessageConfigDO)this.repo.save(ado);
    }

    public List<PrdUserMessageDO> saveUserMessages(List<PrdUserMessageDO> ados) {
        return this.repoUser.saveAll(ados);
    }

    public String getOrgNames(Long id) {
        return this.repo.getOrgNames(id);
    }

    public String getRoleNames(Long id) {
        return this.repo.getRoleNames(id);
    }

    public List<String[]> getOrgMessageDatas(List<Long> ids) {
        return this.repo.getOrgMessageDatas(ids);
    }

    public List<String[]> getRoleMessageDatas(List<Long> ids) {
        return this.repo.getRoleMessageDatas(ids);
    }

    public void deleteXxlJobById(List<String> ids) {
        this.repo.deleteXxlJobById(ids);
    }

    public String getUserNames(Long id) {
        return this.repo.getUserNames(id);
    }

    public void updateXxlJobById(String id, int trigger_status) {
        this.repo.updateXxlJobById(id, trigger_status);
    }

    public List<Integer> getXxlJobByMessageId(String id) {
        return this.repo.getXxlJobByMessageId(id);
    }

    public int saveXxlJob(XxlJobInfo xxlJob) {
        String sql = "insert into xxl_job_info (job_group,job_cron,job_desc,add_time,update_time,author,alarm_email,executor_route_strategy,executor_handler,executor_param,executor_block_strategy,executor_timeout,executor_fail_retry_count,glue_type,glue_source,glue_remark,glue_updatetime,child_jobid,trigger_status,trigger_last_time,trigger_next_time) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Query query = this.em.createNativeQuery(sql);
        query.setParameter(1, (Object)xxlJob.getJobGroup());
        query.setParameter(2, (Object)xxlJob.getJobCron());
        query.setParameter(3, (Object)xxlJob.getJobDesc());
        query.setParameter(4, (Object)xxlJob.getAddTime());
        query.setParameter(5, (Object)xxlJob.getUpdateTime());
        query.setParameter(6, (Object)xxlJob.getAuthor());
        query.setParameter(7, (Object)xxlJob.getAlarmEmail());
        query.setParameter(8, (Object)xxlJob.getExecutorRouteStrategy());
        query.setParameter(9, (Object)xxlJob.getExecutorHandler());
        query.setParameter(10, (Object)xxlJob.getExecutorParam());
        query.setParameter(11, (Object)xxlJob.getExecutorBlockStrategy());
        query.setParameter(12, (Object)xxlJob.getExecutorTimeout());
        query.setParameter(13, (Object)xxlJob.getExecutorFailRetryCount());
        query.setParameter(14, (Object)xxlJob.getGlueType());
        query.setParameter(15, (Object)xxlJob.getGlueSource());
        query.setParameter(16, (Object)xxlJob.getGlueRemark());
        query.setParameter(17, (Object)xxlJob.getGlueUpdatetime());
        query.setParameter(18, (Object)xxlJob.getChildJobid());
        query.setParameter(19, (Object)xxlJob.getTriggerStatus());
        query.setParameter(20, (Object)xxlJob.getTriggerLastTime());
        query.setParameter(21, (Object)xxlJob.getTriggerNextTime());
        return query.executeUpdate();
    }

    private JPAQuery<String> getJpaQuerySelectOrg() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoOrg.orgName).from((EntityPath)this.qdoEmployeeRef)).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.eq(this.qdoEmployeeRef.orgId));
    }

    public List<Long> queryAllUser() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdoEmployee.userId).from((EntityPath)this.qdoEmployee)).where((Predicate)this.qdoEmployee.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoEmployee.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoEmployee.resourceStatus.eq((Object)SystemDefaultEnum.DefaultResourceStatus.getCode()));
        jpaQuery.where((Predicate)this.qdoEmployee.hrStatus.eq((Object)SystemDefaultEnum.DefaultHrStatus.getCode()));
        return jpaQuery.fetch();
    }

    private JPAQuery<String> getJpaQuerySelectUserEmail() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoPerson.email).from((EntityPath)this.qdoEmployee)).leftJoin((EntityPath)this.qdoPerson)).on((Predicate)this.qdoEmployee.personId.eq(this.qdoPerson.id));
    }

    public List<String> queryUserEmailByIds(List<Long> userIds) {
        JPAQuery<String> jpaQuery = this.getJpaQuerySelectUserEmail();
        ((JPAQuery)jpaQuery.where((Predicate)this.qdoEmployee.deleteFlag.eq((Object)0))).where((Predicate)this.qdoPerson.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoEmployee.resourceStatus.eq((Object)SystemDefaultEnum.DefaultResourceStatus.getCode()));
        jpaQuery.where((Predicate)this.qdoEmployee.hrStatus.eq((Object)SystemDefaultEnum.DefaultHrStatus.getCode()));
        jpaQuery.where((Predicate)this.qdoPerson.enabled.eq(Boolean.valueOf(true)));
        jpaQuery.where((Predicate)this.qdoEmployee.userId.in(userIds));
        return jpaQuery.fetch();
    }

    public List<String> queryAllUserEmail() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoPerson.email).from((EntityPath)this.qdoPerson)).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdoPerson.id.eq(this.qdoEmployee.personId))).where((Predicate)this.qdoPerson.enabled.eq(Boolean.valueOf(true)))).where((Predicate)this.qdoPerson.deleteFlag.eq((Object)0))).where((Predicate)this.qdoEmployee.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<String> queryUserWeComByIds(List<Long> userIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoEmployee.wecomId).from((EntityPath)this.qdoEmployee)).where((Predicate)this.qdoEmployee.deleteFlag.eq((Object)0))).where((Predicate)this.qdoEmployee.wecomId.isNotNull())).where((Predicate)this.qdoEmployee.wecomId.isNotEmpty());
        if (userIds.size() > 0) {
            jpaQuery.where((Predicate)this.qdoEmployee.userId.in(userIds));
        }
        return jpaQuery.fetch();
    }

    public String queryOrgByUserId(Long userId) {
        JPAQuery<String> jpaQuery = this.getJpaQuerySelectOrg();
        ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.where((Predicate)this.qdoEmployeeRef.userId.eq((Object)userId))).where((Predicate)this.qdoEmployeeRef.deleteFlag.eq((Object)0))).where((Predicate)this.qdoEmployeeRef.isCopy.eq((Object)0))).where((Predicate)this.qdoEmployeeRef.isDefault.eq((Object)0))).where((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        return (String)jpaQuery.fetchFirst();
    }

    private JPAQuery<PrdMessageConfigVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdMessageConfigVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.triggerTime, this.qdo.messageTitle, this.qdo.createSource, this.qdo.messageContent, this.qdo.contentType, this.qdo.contentBigType, this.qdo.releaseSource, this.qdo.noticeWay, this.qdo.noticeScope, this.qdo.noticeSource, this.qdo.triggerWay, this.qdo.triggerTimeExpression, this.qdo.expressionExplain, this.qdo.messageTag, this.qdo.releaseStatus, this.qdo.messageType, this.qdo.isEnable, this.qdo.remark, this.qdo.creator, this.qdo.deleteFlag, this.qdo.createUserId, this.qdo.createTime, this.qdo.ccEmails, this.qdo.ccSource, this.qdo.messageCode})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PrdMessageConfigVO> getJpaQueryWhere(PrdMessageConfigQuery query) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getMessageCode())) {
            jpaQuery.where((Predicate)this.qdo.messageCode.eq((Object)query.getMessageCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMessageTitle())) {
            jpaQuery.where((Predicate)this.qdo.messageTitle.like(SqlUtil.toSqlLikeString(query.getMessageTitle())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMessageContent())) {
            jpaQuery.where((Predicate)this.qdo.messageContent.like(SqlUtil.toSqlLikeString(query.getMessageContent())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateSource())) {
            jpaQuery.where((Predicate)this.qdo.createSource.like(SqlUtil.toSqlLikeString(query.getCreateSource())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContentType())) {
            jpaQuery.where((Predicate)this.qdo.contentType.eq((Object)query.getContentType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContentBigType())) {
            jpaQuery.where((Predicate)this.qdo.contentBigType.eq((Object)query.getContentBigType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReleaseSource())) {
            jpaQuery.where((Predicate)this.qdo.releaseSource.eq((Object)query.getReleaseSource()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNoticeWay())) {
            jpaQuery.where((Predicate)this.qdo.noticeWay.eq((Object)query.getNoticeWay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNoticeScope())) {
            jpaQuery.where((Predicate)this.qdo.noticeScope.eq((Object)query.getNoticeScope()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNoticeSource())) {
            jpaQuery.where((Predicate)this.qdo.noticeSource.eq((Object)query.getNoticeSource()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTriggerWay())) {
            jpaQuery.where((Predicate)this.qdo.triggerWay.eq((Object)query.getTriggerWay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTriggerTimeExpression())) {
            jpaQuery.where((Predicate)this.qdo.triggerTimeExpression.eq((Object)query.getTriggerTimeExpression()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExpressionExplain())) {
            jpaQuery.where((Predicate)this.qdo.expressionExplain.eq((Object)query.getExpressionExplain()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMessageTag())) {
            jpaQuery.where((Predicate)this.qdo.messageTag.eq((Object)query.getMessageTag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReleaseStatus())) {
            jpaQuery.where((Predicate)this.qdo.releaseStatus.eq((Object)query.getReleaseStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMessageType())) {
            jpaQuery.where((Predicate)this.qdo.messageType.eq((Object)query.getMessageType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIsEnable())) {
            jpaQuery.where((Predicate)this.qdo.isEnable.eq((Object)query.getIsEnable()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReleaseTimeStart())) {
            jpaQuery.where((Predicate)this.qdo.triggerTime.goe((Comparable)query.getReleaseTimeStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReleaseTimeEnd())) {
            jpaQuery.where((Predicate)this.qdo.triggerTime.loe((Comparable)query.getReleaseTimeEnd()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long updateByKeyDynamic(PrdMessageConfigPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getMessageCode() != null) {
            update.set((Path)this.qdo.messageCode, (Object)payload.getMessageCode());
        }
        if (payload.getMessageTitle() != null) {
            update.set((Path)this.qdo.messageTitle, (Object)payload.getMessageTitle());
        }
        if (payload.getMessageContent() != null) {
            update.set((Path)this.qdo.messageContent, (Object)payload.getMessageContent());
        }
        if (payload.getContentType() != null) {
            update.set((Path)this.qdo.contentType, (Object)payload.getContentType());
        }
        if (payload.getContentBigType() != null) {
            update.set((Path)this.qdo.contentBigType, (Object)payload.getContentBigType());
        }
        if (payload.getReleaseSource() != null) {
            update.set((Path)this.qdo.releaseSource, (Object)payload.getReleaseSource());
        }
        if (payload.getNoticeWay() != null) {
            update.set((Path)this.qdo.noticeWay, (Object)payload.getNoticeWay());
        }
        if (payload.getNoticeScope() != null) {
            update.set((Path)this.qdo.noticeScope, (Object)payload.getNoticeScope());
        }
        if (payload.getNoticeSource() != null) {
            update.set((Path)this.qdo.noticeSource, (Object)payload.getNoticeSource());
        }
        if (payload.getTriggerTime() != null) {
            update.set(this.qdo.triggerTime, (Object)payload.getTriggerTime());
        }
        if (payload.getTriggerWay() != null) {
            update.set((Path)this.qdo.triggerWay, (Object)payload.getTriggerWay());
        }
        if (payload.getTriggerTimeExpression() != null) {
            update.set((Path)this.qdo.triggerTimeExpression, (Object)payload.getTriggerTimeExpression());
        }
        if (payload.getExpressionExplain() != null) {
            update.set((Path)this.qdo.expressionExplain, (Object)payload.getExpressionExplain());
        }
        if (payload.getMessageTag() != null) {
            update.set((Path)this.qdo.messageTag, (Object)payload.getMessageTag());
        }
        if (payload.getIsEnable() != null) {
            update.set(this.qdo.isEnable, (Object)payload.getIsEnable());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        return update.execute();
    }

    public long delete(List<Long> keys) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(keys)});
        return delete.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.releaseStatus.eq((Object)0).or((Predicate)this.qdo.releaseStatus.eq((Object)2).or((Predicate)this.qdo.releaseStatus.eq((Object)1).and((Predicate)this.qdo.isEnable.eq((Object)1))))}).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long recall(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.releaseStatus, (Object)2).where(new Predicate[]{this.qdo.messageType.eq((Object)2)}).where(new Predicate[]{this.qdo.noticeWay.eq((Object)MessageNoticeWayEnum.INSTATION.getCode())}).where(new Predicate[]{this.qdo.releaseStatus.eq((Object)3)}).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long updateAdminStatus(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.releaseStatus, (Object)3).set(this.qdo.triggerTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long updateOperStatus(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.releaseStatus, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long deleteUserMessage(List<Long> keys) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdoUser).where(new Predicate[]{this.qdoUser.messageId.in(keys)});
        return delete.execute();
    }

    public PrdMessageConfigVO queryByKey(Long id) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        return (PrdMessageConfigVO)jpaQuery.fetchFirst();
    }

    public PrdMessageConfigVO queryByMessageCode(String messageCode) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.messageCode.eq((Object)messageCode));
        return (PrdMessageConfigVO)jpaQuery.fetchFirst();
    }

    public PrdMessageConfigVO queryByCode(String code) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.messageCode.eq((Object)code));
        return (PrdMessageConfigVO)jpaQuery.fetchFirst();
    }

    public List<PrdMessageConfigVO> queryByKeys(List<Long> keys, int messageType, String triggerWay) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = this.getJpaQuerySelect();
        ((JPAQuery)((JPAQuery)jpaQuery.where((Predicate)this.qdo.isEnable.eq((Object)0))).where((Predicate)this.qdo.releaseStatus.ne((Object)3))).where((Predicate)this.qdo.id.in(keys));
        if (triggerWay != null && !triggerWay.equals("")) {
            jpaQuery.where((Predicate)this.qdo.triggerWay.eq((Object)triggerWay));
        }
        if (messageType != 0) {
            jpaQuery.where((Predicate)this.qdo.messageType.eq((Object)messageType));
        }
        return jpaQuery.fetch();
    }

    public PagingVO<PrdMessageConfigVO> queryPaging(PrdMessageConfigQuery query) {
        JPAQuery<PrdMessageConfigVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<TwCommonVO> getJpaQueryOrgDataSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TwCommonVO.class, (Expression[])new Expression[]{this.qdoEmployeeRef.orgId.as("id"), this.qdoOrg.orgName.as("name")})).from((EntityPath)this.qdoEmployeeRef)).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoEmployeeRef.orgId.longValue().eq(this.qdoOrg.id));
    }

    public List<TwCommonVO> queryOrgListByUserId(Long userId) {
        JPAQuery<TwCommonVO> jpaQuery = this.getJpaQueryOrgDataSelect();
        jpaQuery.where((Predicate)this.qdoEmployeeRef.userId.eq((Object)userId));
        jpaQuery.where((Predicate)this.qdoEmployeeRef.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoEmployeeRef.isCopy.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<TwCommonVO> getJpaQueryRoleDataSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TwCommonVO.class, (Expression[])new Expression[]{this.qdoUserRole.roleId.as("id"), this.qdoRole.roleName.as("name")})).from((EntityPath)this.qdoUserRole)).leftJoin((EntityPath)this.qdoRole)).on((Predicate)this.qdoUserRole.roleId.longValue().eq(this.qdoRole.id));
    }

    public List<TwCommonVO> queryRoleListByUserId(Long userId) {
        JPAQuery<TwCommonVO> jpaQuery = this.getJpaQueryRoleDataSelect();
        jpaQuery.where((Predicate)this.qdoUserRole.userId.eq((Object)userId));
        jpaQuery.where((Predicate)this.qdoUserRole.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRole.enabled.eq(Boolean.valueOf(true)));
        jpaQuery.where((Predicate)this.qdoRole.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PrdMessageConfigDO> queryByObjectIdAndAction(Long objectId, String action) {
        return this.repo.findByObjectIdAndAction(objectId, action);
    }

    public PrdMessageConfigDAO(JPAQueryFactory jpaQueryFactory, PrdMessageConfigRepo repo, PrdUserMessageRepo repoUser, EntityManager em) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.repoUser = repoUser;
        this.em = em;
    }
}

