/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRoleMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemRoleMenuRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemRoleRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemUserRoleRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdSystemRoleDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemRoleRepo repo;
    private final PrdSystemUserRoleRepo repoUserRole;
    private final PrdSystemRoleMenuRepo repoMenu;
    private final QPrdSystemRoleDO qdo = QPrdSystemRoleDO.prdSystemRoleDO;
    private final QPrdSystemRoleMenuDO qdoRoleMenu = QPrdSystemRoleMenuDO.prdSystemRoleMenuDO;
    private final QPrdSystemMenuDO qdoMenu = QPrdSystemMenuDO.prdSystemMenuDO;
    private final QPrdSystemUserRoleDO qdoUserRole = QPrdSystemUserRoleDO.prdSystemUserRoleDO;
    private final QPrdOrgEmployeeDO qdoEmployee = new QPrdOrgEmployeeDO("prdOrgEmployeeDO");

    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQuerySelectUsers() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgEmployeeRefVO.class, (Expression[])new Expression[]{this.qdoEmployee.userId, this.qdoEmployee.employeeName, this.qdoEmployee.sortIndex})).from((EntityPath)this.qdoEmployee)).leftJoin((EntityPath)this.qdoUserRole)).on((Predicate)this.qdoEmployee.userId.longValue().eq((Expression)this.qdoUserRole.userId.longValue()));
    }

    public List<PrdOrgEmployeeRefVO> queryUsers(Long roleId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = this.getJpaQuerySelectUsers();
        jpaQuery.where((Predicate)this.qdoUserRole.roleId.eq((Object)roleId));
        jpaQuery.where((Predicate)this.qdoEmployee.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PrdSystemUserRoleDO> saveUserRoleAll(List<PrdSystemUserRoleDO> ados) {
        return this.repoUserRole.saveAll(ados);
    }

    public long deleteRolesByUserId(Long roleId) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdoUserRole).where(new Predicate[]{this.qdoUserRole.roleId.eq((Object)roleId)});
        return delete.execute();
    }

    public PrdSystemRoleDO save(PrdSystemRoleDO ado) {
        return (PrdSystemRoleDO)this.repo.save(ado);
    }

    public List<PrdSystemRoleMenuDO> saveRoleMenuAll(List<PrdSystemRoleMenuDO> ados) {
        return this.repoMenu.saveAll(ados);
    }

    private JPAQuery<PrdSystemRoleVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemRoleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.roleCode, this.qdo.roleName, this.qdo.sortIndex, this.qdo.enabled, this.qdo.sortIndex, this.qdo.remark, this.qdo.deleteFlag, this.qdo.createUserId, this.qdo.createTime})).from((EntityPath)this.qdo);
    }

    public long updateByKeyDynamic(PrdSystemRolePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getRoleCode() != null) {
            update.set((Path)this.qdo.roleCode, (Object)payload.getRoleCode());
        }
        if (payload.getRoleName() != null) {
            update.set((Path)this.qdo.roleName, (Object)payload.getRoleName());
        }
        if (payload.getEnabled() != null) {
            update.set((Path)this.qdo.enabled, (Object)payload.getEnabled());
        }
        if (payload.getSortIndex() != null) {
            update.set(this.qdo.sortIndex, (Object)payload.getSortIndex());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        return update.execute();
    }

    public long delete(List<Long> keys) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(keys)});
        return delete.execute();
    }

    public long deleteRoleMenusByRoleId(Long roleId) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdoRoleMenu).where(new Predicate[]{this.qdoRoleMenu.roleId.eq((Object)roleId)});
        return delete.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long updateStatus(Long id, Boolean enabled) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.enabled, (Object)enabled).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        return update.execute();
    }

    public PrdSystemRoleVO queryByKey(Long id) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemRoleVO)jpaQuery.fetchFirst();
    }

    public PrdSystemRoleVO queryByCode(String code) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.roleCode.eq((Object)code));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemRoleVO)jpaQuery.fetchFirst();
    }

    public List<PrdSystemRoleVO> queryByCodeIn(List<String> codes) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.roleCode.in(codes));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<Long> queryRoleMenuIds(Long roleId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdoRoleMenu.menuId).from((EntityPath)this.qdoRoleMenu)).leftJoin((EntityPath)this.qdoMenu)).on((Predicate)this.qdoRoleMenu.menuId.longValue().eq((Expression)this.qdoMenu.id.longValue()));
        jpaQuery.where((Predicate)this.qdoMenu.menuStatus.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoMenu.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRoleMenu.roleId.eq((Object)roleId));
        return jpaQuery.fetch();
    }

    public List<PrdSystemRoleVO> queryList() {
        JPAQuery<PrdSystemRoleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.enabled.eq(Boolean.valueOf(true)));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdSystemRoleVO> getJpaQueryWhere(PrdSystemRoleQuery query) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = this.getJpaQuerySelect0();
        if (!ObjectUtils.isEmpty((Object)query.getRoleCode())) {
            jpaQuery.where((Predicate)this.qdo.roleCode.eq((Object)query.getRoleCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRoleName())) {
            jpaQuery.where((Predicate)this.qdo.roleName.like(SqlUtil.toSqlLikeString(query.getRoleName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEnabled())) {
            jpaQuery.where((Predicate)this.qdo.enabled.eq(query.getEnabled()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, SqlUtil.getOrderse()));
        return jpaQuery;
    }

    public PagingVO<PrdSystemRoleVO> queryPaging(PrdSystemRoleQuery query) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.groupBy(this.qdo.id)).offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<PrdSystemRoleVO> getJpaQuerySelect0() {
        StringTemplate stringTemplate = Expressions.stringTemplate((String)"CONCAT(GROUP_CONCAT({0}),'')", (Object[])new Object[]{this.qdoEmployee.employeeName});
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemRoleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.roleCode, this.qdo.roleName, this.qdo.sortIndex, this.qdo.enabled, stringTemplate.as("userNames"), this.qdo.sortIndex, this.qdo.remark, this.qdo.deleteFlag, this.qdo.createUserId, this.qdo.createTime})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoUserRole)).on((Predicate)this.qdoUserRole.roleId.eq(this.qdo.id))).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdoEmployee.userId.eq(this.qdoUserRole.userId));
    }

    public List<Long> queryUserIdByRoleCode(String roleNo) {
        return this.repoUserRole.queryUserIdByRoleCode(roleNo);
    }

    public List<Long> queryUserIdByRoleCodes(List<String> roleNos) {
        return this.repoUserRole.queryUserIdByRoleCodes(roleNos);
    }

    public List<String> queryUserRoleCodes(Long userId) {
        return this.repoUserRole.queryUserRoleCodes(userId);
    }

    public PrdSystemRoleDAO(JPAQueryFactory jpaQueryFactory, PrdSystemRoleRepo repo, PrdSystemUserRoleRepo repoUserRole, PrdSystemRoleMenuRepo repoMenu) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.repoUserRole = repoUserRole;
        this.repoMenu = repoMenu;
    }
}

