/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.yeedoc.workflow;

import com.alibaba.fastjson.JSONArray;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/YEEDOC_{procDefKey}/callBack"})
@Transactional
public class YeedocCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(YeedocCallBackController.class);
    private final HttpUtil httpUtil;
    @Value(value="${yeedoc.processAdvanceUrl:testUrl}")
    private String processAdvanceUrl;
    @Value(value="${yeedoc.processStatusChangeUrl:testUrl}")
    private String processStatusChangeUrl;
    @Value(value="${yeedoc.taskAssigneeUrl:testUrl}")
    private String taskAssigneeUrl;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        String result = this.httpUtil.sendPost(this.taskAssigneeUrl, BeanUtil.beanToMap(payload));
        JSONArray yeedocResultData = (JSONArray)this.httpUtil.getYeedocResultData(result);
        ArrayList userIds = (ArrayList)JSONArray.parseArray((String)yeedocResultData.toJSONString(), String.class);
        log.info("\u52a8\u6001\u6307\u5b9a\u53c2\u6570: {}", (Object)payload);
        log.info("\u52a8\u6001\u6307\u5b9a\u8fd4\u56de\u7ed3\u679c: {}", (Object)result);
        return WorkflowResult.success((Object)userIds);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult taskCreated(@RequestBody TaskCreatedPayload payload) {
        String result = this.httpUtil.sendPost(this.processAdvanceUrl, BeanUtil.beanToMap(payload));
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u7ed3\u679c: {}", (Object)result);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String result = this.httpUtil.sendPost(this.processStatusChangeUrl, BeanUtil.beanToMap(payload));
        log.info("\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        log.info("\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u540e\u56de\u8c03\u7ed3\u679c: {}", (Object)result);
        return WorkflowResult.success(null);
    }

    public YeedocCallBackController(HttpUtil httpUtil) {
        this.httpUtil = httpUtil;
    }
}

