/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.poi.excel.BigExcelWriter;
import cn.hutool.poi.excel.ExcelUtil;
import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.server.common.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil
extends cn.hutool.core.io.FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    public static final String SYS_TEM_DIR = System.getProperty("java.io.tmpdir") + File.separator;
    private static final int GB = 0x40000000;
    private static final int MB = 0x100000;
    private static final int KB = 1024;
    private static final DecimalFormat DF = new DecimalFormat("0.00");
    public static final String IMAGE = "\u56fe\u7247";
    public static final String TXT = "\u6587\u6863";
    public static final String MUSIC = "\u97f3\u4e50";
    public static final String VIDEO = "\u89c6\u9891";
    public static final String OTHER = "\u5176\u4ed6";

    public static File toFile(MultipartFile multipartFile) {
        String fileName = multipartFile.getOriginalFilename();
        String prefix = "." + FileUtil.getExtensionName(fileName);
        File file = null;
        try {
            file = new File(SYS_TEM_DIR + IdUtil.simpleUUID() + prefix);
            multipartFile.transferTo(file);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return file;
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }

    public static String getFileNameNoEx(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    public static String getSize(long size) {
        String resultSize = size / 0x40000000L >= 1L ? DF.format((float)size / 1.0737418E9f) + "GB   " : (size / 0x100000L >= 1L ? DF.format((float)size / 1048576.0f) + "MB   " : (size / 1024L >= 1L ? DF.format((float)size / 1024.0f) + "KB   " : size + "B   "));
        return resultSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File inputStreamToFile(InputStream ins, String name) {
        File file = new File(SYS_TEM_DIR + name);
        if (file.exists()) {
            return file;
        }
        FileOutputStream os = null;
        try {
            int bytesRead;
            os = new FileOutputStream(file);
            int len = 8192;
            byte[] buffer = new byte[len];
            while ((bytesRead = ins.read(buffer, 0, len)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close(os);
                CloseUtil.close(ins);
                throw throwable;
            }
            CloseUtil.close(os);
            CloseUtil.close(ins);
        }
        CloseUtil.close(os);
        CloseUtil.close(ins);
        return file;
    }

    public static File upload(MultipartFile file, String filePath) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmssS");
        String name = FileUtil.getFileNameNoEx(file.getOriginalFilename());
        String suffix = FileUtil.getExtensionName(file.getOriginalFilename());
        String nowStr = "-" + format.format(date);
        try {
            String fileName = name + nowStr + "." + suffix;
            String path = filePath + fileName;
            File dest = new File(path).getCanonicalFile();
            if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                System.out.println("was not successful.");
            }
            file.transferTo(dest);
            return dest;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Path getFilePath(String fileNameParam, String filePath) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmssS");
        String name = FileUtil.getFileNameNoEx(fileNameParam);
        String suffix = FileUtil.getExtensionName(fileNameParam);
        String nowStr = "-" + format.format(date);
        try {
            String fileName = name + nowStr + "." + suffix;
            String path = filePath + fileName;
            File dest = new File(path).getCanonicalFile();
            if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                System.out.println("was not successful.");
            }
            return Paths.get(path, new String[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getFilePathStr(String fileNameParam, String filePath) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmssS");
        String name = FileUtil.getFileNameNoEx(fileNameParam);
        String suffix = FileUtil.getExtensionName(fileNameParam);
        String nowStr = "-" + format.format(date);
        try {
            String fileName = name + nowStr + "." + suffix;
            String path = filePath + fileName;
            File dest = new File(path).getCanonicalFile();
            if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                System.out.println("was not successful.");
            }
            return path;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String generateFileNameAndCheckPath(String fileNameParam, String filePath) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmssS");
        String name = FileUtil.getFileNameNoEx(fileNameParam);
        String suffix = FileUtil.getExtensionName(fileNameParam);
        String nowStr = "-" + format.format(date);
        try {
            String fileName = name + nowStr + "." + suffix;
            String path = filePath + fileName;
            File dest = new File(path).getCanonicalFile();
            if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                System.out.println("was not successful.");
            }
            return fileName;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void downloadExcel(List<Map<String, Object>> list, HttpServletResponse response) throws IOException {
        String tempPath = SYS_TEM_DIR + IdUtil.fastSimpleUUID() + ".xlsx";
        File file = new File(tempPath);
        BigExcelWriter writer = ExcelUtil.getBigWriter((File)file);
        writer.write(list, true);
        SXSSFSheet sheet = (SXSSFSheet)writer.getSheet();
        sheet.trackAllColumnsForAutoSizing();
        writer.autoSizeColumnAll();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=file.xlsx");
        ServletOutputStream out = response.getOutputStream();
        file.deleteOnExit();
        writer.flush((OutputStream)out, true);
        IoUtil.close((Closeable)out);
    }

    public static String getFileType(String type) {
        String documents = "txt doc pdf ppt pps xlsx xls docx pptx";
        String music = "mp3 wav wma mpa ram ra aac aif m4a";
        String video = "avi mpg mpe mpeg asf wmv mov qt rm mp4 flv m4v webm ogv ogg";
        String image = "bmp dib pcp dif wmf gif jpg tif eps psd cdr iff tga pcd mpt png jpeg";
        if (image.contains(type)) {
            return IMAGE;
        }
        if (documents.contains(type)) {
            return TXT;
        }
        if (music.contains(type)) {
            return MUSIC;
        }
        if (video.contains(type)) {
            return VIDEO;
        }
        return OTHER;
    }

    public static void checkSize(long maxSize, long size) {
        int len = 0x100000;
        if (size > maxSize * (long)len) {
            throw TwException.error((String)"0801", (String)"\u6587\u4ef6\u8d85\u51fa\u89c4\u5b9a\u5927\u5c0f");
        }
    }

    public static boolean check(File file1, File file2) {
        String img1Md5 = FileUtil.getMd5(file1);
        String img2Md5 = FileUtil.getMd5(file2);
        if (img1Md5 != null) {
            return img1Md5.equals(img2Md5);
        }
        return false;
    }

    public static boolean check(String file1Md5, String file2Md5) {
        return file1Md5.equals(file2Md5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getByte(File file) {
        byte[] b = new byte[(int)file.length()];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            try {
                System.out.println(((InputStream)in).read(b));
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            byte[] byArray;
            try {
                log.error(e.getMessage(), (Throwable)e);
                byArray = null;
            }
            catch (Throwable throwable) {
                CloseUtil.close(in);
                throw throwable;
            }
            CloseUtil.close(in);
            return byArray;
        }
        CloseUtil.close(in);
        return b;
    }

    private static String getMd5(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(bytes);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(HttpServletRequest request, HttpServletResponse response, File file, boolean deleteOnExit) {
        response.setCharacterEncoding(request.getCharacterEncoding());
        response.setContentType("application/octet-stream");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
            IOUtils.copy((InputStream)fis, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    if (deleteOnExit) {
                        file.deleteOnExit();
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String getMd5(File file) {
        return FileUtil.getMd5(FileUtil.getByte(file));
    }
}

