/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class FilterInteceptor
implements HandlerInterceptor {
    private final GlobalUtil globalUtil;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String url = request.getServletPath().toLowerCase();
        System.out.println("url:::" + url);
        if (!this.globalUtil.checkOperateUrl(url)) {
            this.responseJson(response, 201, url + " \uff08\u6682\u65e0\u64cd\u4f5c\u8be5\u5730\u5740\u6743\u9650\uff09");
            return false;
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView arg3) throws Exception {
    }

    private void responseJson(HttpServletResponse response, int code, String message) {
        try {
            String json = this.getJson(TwOutputUtil.error().addError("" + code, message, null));
            response.getWriter().write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getJson(Object obj) {
        String json = null;
        try {
            json = new ObjectMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }

    public FilterInteceptor(GlobalUtil globalUtil) {
        this.globalUtil = globalUtil;
    }
}

