/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitesland.tw.tw5.api.common.TwException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpUtil<k, v> {
    @Value(value="${tw4.isSync}")
    private Boolean tw4_isSync = false;
    @Value(value="${tw4.url}")
    private String tw4_url;
    private final RestTemplate restTemplate = RestTemplateFactory.instance();

    public HttpEntity<Map<String, Object>> generatePostJson(Map<String, Object> jsonMap) {
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json;charset=UTF-8");
        httpHeaders.setContentType(type);
        HttpEntity httpEntity = new HttpEntity(jsonMap, (MultiValueMap)httpHeaders);
        return httpEntity;
    }

    public String generateRequestParameters(String uri, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder(uri);
        if (ObjectUtil.isNotEmpty(params)) {
            sb.append("?");
            for (Map.Entry<String, Object> map : params.entrySet()) {
                sb.append((Object)map.getKey()).append("=").append(map.getValue()).append("&");
            }
            uri = sb.substring(0, sb.length() - 1);
            return uri;
        }
        return sb.toString();
    }

    public String sendGet(String uri, Map<String, Object> uriMap) {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.generateRequestParameters(uri, uriMap), String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    public String sendPost(String uri, Map<String, Object> jsonMap) {
        ResponseEntity apiResponse = this.restTemplate.postForEntity(uri, this.generatePostJson(jsonMap), String.class, new Object[0]);
        return (String)apiResponse.getBody();
    }

    public String sendSyncPost(String uri, Map<String, Object> jsonMap) {
        if (this.tw4_isSync.booleanValue()) {
            String result = cn.hutool.http.HttpUtil.post((String)(this.tw4_url + uri), jsonMap);
            return result;
        }
        return "{\"ok\":true}";
    }

    public String sendSyncGet(String uri, Map<String, Object> uriMap) {
        if (this.tw4_isSync.booleanValue()) {
            String result = cn.hutool.http.HttpUtil.get((String)(this.tw4_url + uri), uriMap);
            return result;
        }
        return "{\"ok\":true}";
    }

    public String geResultData(String result) {
        return "";
    }

    public String geStrItem(String result, String itemName, String errorMsg) {
        Map parse = (Map)JSON.parse((String)result);
        if (parse.get("errcode").equals(0)) {
            if (parse.get(itemName) != null) {
                return (String)parse.get(itemName);
            }
            return null;
        }
        String errmsg = (String)parse.get("errmsg");
        errmsg = errmsg.split(",")[0];
        throw TwException.error((String)parse.get("errcode").toString(), (String)(errorMsg + ",\u8be6\u60c5\uff1a" + errmsg));
    }

    public Map sendGetCallMap(String uri, Map<String, Object> uriMap) {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.generateRequestParameters(uri, uriMap), Map.class, new Object[0]);
        return (Map)responseEntity.getBody();
    }
}

