/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.QyWx.Controller;

import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.QyWx.service.WXPushService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03")
@RestController
@RequestMapping(value={"/api/qywx/"})
public class QyWxCallbackController {
    private static final Logger log = LoggerFactory.getLogger(QyWxCallbackController.class);
    private final QyWxCommunicationService service;
    private final WXPushService wxPushService;

    @GetMapping(value={"/telework"})
    public String twAutograph(@RequestParam(name="msg_signature") String msgSignature, @RequestParam(name="timestamp") String timestamp, @RequestParam(name="nonce") String nonce, @RequestParam(name="echostr") String echostr, HttpServletResponse response) throws Exception {
        return this.wxPushService.autograph(msgSignature, timestamp, nonce, echostr);
    }

    @ResponseBody
    @PostMapping(value={"/telework"})
    public String twAdecrypt(HttpServletRequest request, @RequestParam(name="msg_signature") String msgSignature, @RequestParam(name="timestamp") String timestamp, @RequestParam(name="nonce") String nonce) {
        Map<String, String> content = this.wxPushService.decrypt(msgSignature, timestamp, nonce, request);
        String returnContent = this.wxPushService.doCallBack(content, timestamp, nonce);
        return returnContent;
    }

    @GetMapping(value={"/schedule"})
    public String reveiceMsg(@RequestParam(name="msg_signature") String msgSignature, @RequestParam(name="timestamp") String timestamp, @RequestParam(name="nonce") String nonce, @RequestParam(name="echostr") String echostr, HttpServletResponse response) throws Exception {
        return this.wxPushService.autograph(msgSignature, timestamp, nonce, echostr);
    }

    @ResponseBody
    @PostMapping(value={"/schedule"})
    public String decrypt(HttpServletRequest request, @RequestParam(name="msg_signature") String msgSignature, @RequestParam(name="timestamp") String timestamp, @RequestParam(name="nonce") String nonce) {
        Map<String, String> content = this.wxPushService.decrypt(msgSignature, timestamp, nonce, request);
        return null;
    }

    @ApiOperation(value="\u8be6\u60c5\u67e5\u8be2")
    @GetMapping(value={"/queryId"})
    public TwOutputUtil getQyWxuserid() {
        this.service.getQyWxuserid("17717326306");
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u8be6\u60c5\u67e5\u8be2")
    @GetMapping(value={"/exportUsersRequest"})
    public TwOutputUtil exportUsersRequest() {
        this.service.exportUsersRequest();
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u8be6\u60c5\u67e5\u8be2")
    @GetMapping(value={"/exportUsersExport"})
    public TwOutputUtil exportUsersExport() {
        this.service.exportUsersExport();
        return TwOutputUtil.ok();
    }

    public QyWxCallbackController(QyWxCommunicationService service, WXPushService wxPushService) {
        this.service = service;
        this.wxPushService = wxPushService;
    }
}

