/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.change.dao;

import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.query.ComChangeQuery;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.server.common.change.entity.QComChangeDO;
import com.elitesland.tw.tw5.server.common.change.repo.ComChangeRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtilPlus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class ComChangeDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ComChangeRepo repo;
    private final QComChangeDO qdo = QComChangeDO.comChangeDO;

    private JPAQuery<ComChangeVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ComChangeVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createTime, this.qdo.changeContent, this.qdo.versionNo, this.qdo.createUserId, this.qdo.creator, this.qdo.changeDocId, this.qdo.apprStatus, this.qdo.changeStatus, this.qdo.changeType, this.qdo.extString1, this.qdo.extString2, this.qdo.extString3, this.qdo.extString4, this.qdo.extString5})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ComChangeVO> getJpaQueryWhere(ComChangeQuery query) {
        JPAQuery<ComChangeVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        jpaQuery.orderBy(SqlUtilPlus.getSortedColumn(query.getOrders(), this.qdo));
        return jpaQuery;
    }

    private Predicate where(ComChangeQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getChangeDocId())) {
            list.add(this.qdo.changeDocId.eq((Object)query.getChangeDocId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getChangeType())) {
            list.add(this.qdo.changeType.eq((Object)query.getChangeType()));
        }
        return ExpressionUtils.allOf(list);
    }

    public long updateWorkFlow(ComChangePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (!ObjectUtils.isEmpty((Object)payload.getApprProcInstId())) {
            update.set((Path)this.qdo.apprProcInstId, (Object)payload.getApprProcInstId());
        } else {
            update.setNull((Path)this.qdo.apprProcInstId);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getApprStatus())) {
            update.set((Path)this.qdo.apprStatus, (Object)payload.getApprStatus());
        } else {
            update.setNull((Path)this.qdo.apprStatus);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getChangeStatus())) {
            update.set((Path)this.qdo.changeStatus, (Object)payload.getChangeStatus());
        } else {
            update.setNull((Path)this.qdo.changeStatus);
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<ComChangeVO> queryListDynamic(ComChangeQuery query) {
        JPAQuery<ComChangeVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public ComChangeVO queryByKey(Long id) {
        JPAQuery<ComChangeVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ComChangeVO)jpaQuery.fetchFirst();
    }

    public ComChangeDAO(JPAQueryFactory jpaQueryFactory, ComChangeRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

