/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTablePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessTableConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessTableDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessTableDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessTableRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BusinessTableServiceImpl
extends BaseServiceImpl
implements BusinessTableService {
    private static final Logger log = LoggerFactory.getLogger(BusinessTableServiceImpl.class);
    private final BusinessTableRepo businessTableRepo;
    private final BusinessTableDAO businessTableDAO;

    public PagingVO<BusinessTableVO> queryPaging(BusinessTableQuery query) {
        return this.businessTableDAO.queryPaging(query);
    }

    public List<BusinessTableVO> queryListDynamic(BusinessTableQuery query) {
        return this.businessTableDAO.queryListDynamic(query);
    }

    public BusinessTableVO queryByKey(Long key) {
        BusinessTableDO entity = this.businessTableRepo.findById(key).orElseGet(BusinessTableDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessTableVO vo = BusinessTableConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessTableVO insert(BusinessTablePayload payload) {
        BusinessTableDO entityDo = BusinessTableConvert.INSTANCE.toDo(payload);
        return BusinessTableConvert.INSTANCE.toVo((BusinessTableDO)this.businessTableRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessTableVO update(BusinessTablePayload payload) {
        BusinessTableDO entity = this.businessTableRepo.findById(payload.getId()).orElseGet(BusinessTableDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessTableDO entityDo = BusinessTableConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessTableConvert.INSTANCE.toVo((BusinessTableDO)this.businessTableRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessTablePayload payload) {
        BusinessTableDO entity = this.businessTableRepo.findById(payload.getId()).orElseGet(BusinessTableDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessTableDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessTableRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessTableDO entity = (BusinessTableDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessTableRepo.save(entity);
                }
            });
        }
    }

    public BusinessTableServiceImpl(BusinessTableRepo businessTableRepo, BusinessTableDAO businessTableDAO) {
        this.businessTableRepo = businessTableRepo;
        this.businessTableDAO = businessTableDAO;
    }
}

