/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.AuthContextUtil;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ObjectUtils;

public class SqlUtilPlus {
    private static final Map<String, List<String>> fieldMap = new HashMap<String, List<String>>();

    public static String toSqlLikeString(String value) {
        return "%" + value + "%";
    }

    public static OrderSpecifier<?>[] getSortedColumn(List<OrderItem> orders, EntityPathBase ... pathBase) {
        if (orders == null || orders.size() == 0) {
            SimplePath fieldPath = Expressions.path(String.class, (Path)pathBase[0], (String)"createTime");
            return new OrderSpecifier[]{new OrderSpecifier(Order.DESC, (Expression)fieldPath)};
        }
        OrderSpecifier[] orderSpecifiers = new OrderSpecifier[orders.size()];
        for (int i = 0; i < orders.size(); ++i) {
            OrderItem orderItem = orders.get(i);
            Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
            EntityPathBase ownerEntity = SqlUtilPlus.getOwnerEntity(orderItem.getColumn(), pathBase);
            if (ownerEntity == null) {
                throw TwException.error((String)"", (String)"\u4e0d\u5b58\u5728\u8981\u6392\u5e8f\u7684\u5b57\u6bb5");
            }
            SimplePath fieldPath = Expressions.path(String.class, (Path)ownerEntity, (String)orderItem.getColumn());
            orderSpecifiers[i] = new OrderSpecifier(order, (Expression)fieldPath);
        }
        return orderSpecifiers;
    }

    private static EntityPathBase getOwnerEntity(String column, EntityPathBase ... pathBase) {
        EntityPathBase result = null;
        for (EntityPathBase path : pathBase) {
            String className = path.getClass().getName();
            List<String> stringFields = fieldMap.get(className);
            if (stringFields == null) {
                Field[] declaredFields = path.getClass().getDeclaredFields();
                ArrayList<String> stringList = new ArrayList<String>(declaredFields.length);
                for (Field declaredField : declaredFields) {
                    if (!Path.class.isAssignableFrom(declaredField.getType())) continue;
                    stringList.add(declaredField.getName());
                }
                stringFields = stringList;
                fieldMap.put(className, stringList);
            }
            if (!stringFields.contains(column)) continue;
            result = path;
            break;
        }
        return result;
    }

    public static <T> void handleCommonJpaQuery(JPAQuery<T> jpaQuery, QBaseModel qBaseModel, TwQueryParam query) {
        jpaQuery.where((Predicate)qBaseModel.deleteFlag.eq((Object)0));
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            jpaQuery.where((Predicate)qBaseModel.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((Predicate)qBaseModel.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
            jpaQuery.where((Predicate)qBaseModel.createTime.goe((Comparable)query.getCreateTimeStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            jpaQuery.where((Predicate)qBaseModel.createTime.loe((Comparable)query.getCreateTimeEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemark())) {
            jpaQuery.where((Predicate)qBaseModel.remark.like(SqlUtilPlus.toSqlLikeString(query.getRemark())));
        }
    }

    public static void updateCommonJpaQuery(JPAUpdateClause update, QBaseModel qBaseModel) {
        SysUserDTO userDTO = AuthContextUtil.getLoginUser();
        update.set((Path)qBaseModel.modifyUserId, (Object)userDTO.getId());
        update.set((Path)qBaseModel.updater, (Object)userDTO.getFirstName());
        update.set((Path)qBaseModel.modifyTime, (Object)LocalDateTime.now());
    }
}

