/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.demo.leave.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.demo.leave.payload.DemoLeavePayload;
import com.elitesland.tw.tw5.api.demo.leave.query.DemoLeaveQuery;
import com.elitesland.tw.tw5.api.demo.leave.service.DemoLeaveService;
import com.elitesland.tw.tw5.api.demo.leave.vo.DemoLeaveVO;
import com.elitesland.tw.tw5.server.demo.leave.convert.DemoLeaveConvert;
import com.elitesland.tw.tw5.server.demo.leave.dao.DemoLeaveDAO;
import com.elitesland.tw.tw5.server.demo.leave.entity.DemoLeaveDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DemoLeaveServiceImpl
implements DemoLeaveService {
    private static final Logger log = LoggerFactory.getLogger(DemoLeaveServiceImpl.class);
    private final DemoLeaveDAO dao;

    public TwOutputUtil<DemoLeaveVO> businessCheck(DemoLeavePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getLeaveNo())) {
            return TwOutputUtil.error((String)"", (String)"\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return TwOutputUtil.ok();
    }

    private void transformData(DemoLeaveVO vo) {
        vo.setCreator("\u5f20\u4e09");
    }

    @Transactional
    public TwOutputUtil<DemoLeaveVO> insert(DemoLeavePayload payload) {
        TwOutputUtil<DemoLeaveVO> checkResult = this.businessCheck(payload);
        if (!checkResult.isOk()) {
            return checkResult;
        }
        DemoLeaveDO ado = DemoLeaveConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        DemoLeaveVO demoLeaveVO = DemoLeaveConvert.INSTANCE.toVo(ado);
        return TwOutputUtil.ok((Object)demoLeaveVO);
    }

    public TwOutputUtil<DemoLeaveVO> update(DemoLeavePayload payload) {
        TwOutputUtil<DemoLeaveVO> checkResult = this.businessCheck(payload);
        if (!checkResult.isOk()) {
            return checkResult;
        }
        DemoLeaveDO ado = DemoLeaveConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        DemoLeaveVO vo = DemoLeaveConvert.INSTANCE.toVo(ado);
        return TwOutputUtil.ok((Object)vo);
    }

    public TwOutputUtil<DemoLeaveVO> updateDynamic(DemoLeavePayload payload) {
        TwOutputUtil<DemoLeaveVO> checkResult = this.businessCheck(payload);
        if (!checkResult.isOk()) {
            return checkResult;
        }
        this.dao.updateByKeyDynamic(payload);
        DemoLeaveVO vo = DemoLeaveConvert.INSTANCE.toVo(payload);
        return TwOutputUtil.ok((Object)vo);
    }

    public TwOutputUtil<DemoLeaveVO> queryByKey(Long key) {
        DemoLeaveVO vo = this.dao.queryByKey(key);
        return TwOutputUtil.ok((Object)vo);
    }

    public TwOutputUtil<PagingVO<DemoLeaveVO>> paging(DemoLeaveQuery query) {
        PagingVO<DemoLeaveVO> demoLeaveVOPagingVO = this.dao.queryPaging(query);
        List records = demoLeaveVOPagingVO.getRecords();
        records.forEach(this::transformData);
        return TwOutputUtil.ok(demoLeaveVOPagingVO);
    }

    public TwOutputUtil<List<DemoLeaveVO>> queryList(DemoLeaveQuery query) {
        List<DemoLeaveVO> vos = this.dao.queryListDynamic(query);
        return TwOutputUtil.ok(vos);
    }

    @Transactional
    public TwOutputUtil<List<Long>> deleteSoft(List<Long> keys) {
        List<DemoLeaveVO> demoLeaveVOS = this.dao.queryByKeys(keys);
        if (CollectionUtils.isEmpty(demoLeaveVOS)) {
            return TwOutputUtil.error((String)"", (String)"\u4e0d\u5b58\u5728\u8981\u5220\u9664\u7684\u6570\u636e");
        }
        this.dao.deleteSoft(keys);
        return TwOutputUtil.ok(keys);
    }

    public DemoLeaveServiceImpl(DemoLeaveDAO dao) {
        this.dao = dao;
    }
}

