/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ab.controller;

import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbContactsPayload;
import com.elitesland.tw.tw5.api.prd.ab.query.PrdAbContactsQuery;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbContactsService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbContactsVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u8054\u7cfb\u4eba\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/ab"})
public class PrdAbContactsController {
    private static final Logger log = LoggerFactory.getLogger(PrdAbContactsController.class);
    private final PrdAbContactsService service;

    @PostMapping(value={"/contacts/insert"})
    public TwOutputUtil insert(PrdAbContactsPayload payload) {
        PrdAbContactsVO vo = this.service.insert(payload);
        return TwOutputUtil.ok((Object)vo);
    }

    @PutMapping(value={"/contacts/update"})
    public TwOutputUtil update(PrdAbContactsPayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/contacts/paging"})
    public TwOutputUtil paging(PrdAbContactsQuery query) {
        return TwOutputUtil.ok((Object)this.service.paging(query));
    }

    @GetMapping(value={"/contacts/queryByKey/{id}"})
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        PrdAbContactsVO vo = this.service.queryByKey(id);
        return TwOutputUtil.ok((Object)vo);
    }

    @DeleteMapping(value={"/contacts/delete"})
    public TwOutputUtil delete(Long bookId, String objectType, Long[] keys) {
        this.service.delete(bookId, objectType, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/act/updateStatus"})
    public TwOutputUtil updateStatus(Long key, String contactsStatus) {
        this.service.updateStatus(key, contactsStatus);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/contacts/queryList"})
    public TwOutputUtil queryList(Long bookId) {
        return TwOutputUtil.ok((Object)this.service.queryList(bookId));
    }

    @GetMapping(value={"/contacts/queryLogList"})
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok((Object)this.service.queryLogList(query));
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/contacts/batchExport"})
    public void batchExport(HttpServletResponse response, PrdAbContactsQuery query) {
        this.service.downloadBatch(response, query);
    }

    public PrdAbContactsController(PrdAbContactsService service) {
        this.service = service;
    }
}

