/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.qixin.controller;

import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.qixin.service.QiXinService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/qixin"})
public class QiXinController {
    private static final Logger log = LoggerFactory.getLogger(QiXinController.class);
    private final QiXinService qiXinService;
    private final RedisUtils redisUtils;
    private static final String QXB_NEW_KEY = "QXB_NEW_KEY";

    @GetMapping(value={"/search"})
    public TwOutputUtil search(String matchType, String region, String keyword, String skip) {
        if (!StringUtils.hasText((String)keyword)) {
            log.error("\u542f\u4fe1\u5b9d 1.31 \u6a21\u7cca\u641c\u7d22 \u7f3a\u5c11\u53c2\u6570 keyword");
            return TwOutputUtil.error((String)"", (String)"\u53c2\u6570\u7f3a\u5931", null);
        }
        String result = this.qiXinService.search(matchType, region, keyword, skip);
        return TwOutputUtil.ok((Object)result);
    }

    @GetMapping(value={"/advanceSearchNew"})
    public TwOutputUtil advanceSearchNew(String keyword, String skip, String method, String org_type, String area_code, String industry_code, String econ_type, String capi_from, String capi_to, String date_from, String date_to, String status, String canbao_from, String canbao_to) {
        if (!StringUtils.hasText((String)keyword)) {
            log.error("\u542f\u4fe1\u5b9d 1.2 \u9ad8\u7ea7\u641c\u7d22 \u7f3a\u5c11\u53c2\u6570 keyword");
            return TwOutputUtil.error((String)"", (String)"\u53c2\u6570\u7f3a\u5931", null);
        }
        String result = this.qiXinService.advanceSearchNew(keyword, skip, method, org_type, area_code, industry_code, econ_type, capi_from, capi_to, date_from, date_to, status, canbao_from, canbao_to);
        return TwOutputUtil.ok((Object)result);
    }

    @GetMapping(value={"/getContactInfo"})
    public TwOutputUtil getContactInfo(String keyword) {
        if (!StringUtils.hasText((String)keyword)) {
            log.error("\u542f\u4fe1\u5b9d \u83b7\u53d6\u4f01\u4e1a\u8054\u7cfb\u65b9\u5f0f \u7f3a\u5c11\u53c2\u6570 keyword");
            return TwOutputUtil.error((String)"", (String)"\u53c2\u6570\u7f3a\u5931", null);
        }
        String result = this.qiXinService.getContactInfo(keyword);
        return TwOutputUtil.ok((Object)result);
    }

    @GetMapping(value={"/getNewsListByName"})
    public TwOutputUtil getNewsListByName(String name, String skip, String tag_list, String sentiment, String company_sentiment, String class_types, String new_tag_list, String company_new_tag, String create_time_range) {
        if (!StringUtils.hasText((String)skip)) {
            skip = "0";
        }
        if (!StringUtils.hasText((String)name)) {
            log.error("\u542f\u4fe1\u5b9d 10.1 \u65b0\u95fb\u5217\u8868 \u7f3a\u5c11\u53c2\u6570 name");
            return TwOutputUtil.error((String)"", (String)"\u53c2\u6570\u7f3a\u5931", null);
        }
        if (!StringUtils.hasText((String)create_time_range)) {
            create_time_range = "";
        }
        String result = this.qiXinService.getNewsListByName(name, skip, tag_list, sentiment, company_sentiment, class_types, new_tag_list, company_new_tag, create_time_range);
        return TwOutputUtil.ok((Object)result);
    }

    @GetMapping(value={"/getBasicInfo"})
    public TwOutputUtil getBasicInfo(String keyword) {
        if (!StringUtils.hasText((String)keyword)) {
            log.error("\u542f\u4fe1\u5b9d \u5de5\u5546\u7167\u9762 \u7f3a\u5c11\u53c2\u6570 keyword");
            return TwOutputUtil.error((String)"", (String)"\u53c2\u6570\u7f3a\u5931", null);
        }
        String result = this.qiXinService.getBasicInfo(keyword);
        return TwOutputUtil.ok((Object)result);
    }

    @GetMapping(value={"/getEntLogoByName"})
    public TwOutputUtil getEntLogoByName(String name) {
        if (!StringUtils.hasText((String)name)) {
            log.error("\u542f\u4fe1\u5b9d \u4f01\u4e1aLOGO \u7f3a\u5c11\u53c2\u6570 name");
            return TwOutputUtil.error((String)"", (String)"\u53c2\u6570\u7f3a\u5931", null);
        }
        String result = this.qiXinService.getEntLogoByName(name);
        return TwOutputUtil.ok((Object)result);
    }

    @GetMapping(value={"/getEntBriefByName"})
    public TwOutputUtil getEntBriefByName(String name) {
        if (!StringUtils.hasText((String)name)) {
            log.error("\u542f\u4fe1\u5b9d \u4f01\u4e1a\u7b80\u4ecb \u7f3a\u5c11\u53c2\u6570 name");
            return TwOutputUtil.error((String)"", (String)"\u53c2\u6570\u7f3a\u5931", null);
        }
        String result = this.qiXinService.getEntBriefByName(name);
        return TwOutputUtil.ok((Object)result);
    }

    @GetMapping(value={"/getGetWebsitesUri"})
    public TwOutputUtil getGetWebsitesUri(String keyword, String skip) {
        if (!StringUtils.hasText((String)keyword)) {
            log.error("\u542f\u4fe1\u5b9d \u4f01\u4e1a\u5e74\u62a5\u7f51\u5740 \u7f3a\u5c11\u53c2\u6570 keyword");
            return TwOutputUtil.error((String)"", (String)"\u53c2\u6570\u7f3a\u5931", null);
        }
        String result = this.qiXinService.getGetWebsites(keyword, skip);
        return TwOutputUtil.ok((Object)result);
    }

    @GetMapping(value={"/getPartners"})
    public TwOutputUtil getPartners(String keyword, String skip) {
        if (!StringUtils.hasText((String)keyword)) {
            log.error("\u542f\u4fe1\u5b9d \u5de5\u5546\u80a1\u4e1c \u7f3a\u5c11\u53c2\u6570 keyword");
            return TwOutputUtil.error((String)"", (String)"\u53c2\u6570\u7f3a\u5931", null);
        }
        String result = this.qiXinService.getPartners(keyword, skip);
        return TwOutputUtil.ok((Object)result);
    }

    @GetMapping(value={"/getGetEmployees"})
    public TwOutputUtil getGetEmployees(String keyword, String skip) {
        if (!StringUtils.hasText((String)keyword)) {
            log.error("\u542f\u4fe1\u5b9d \u4e3b\u8981\u4eba\u5458 \u7f3a\u5c11\u53c2\u6570 keyword");
            return TwOutputUtil.error((String)"", (String)"\u53c2\u6570\u7f3a\u5931", null);
        }
        String result = this.qiXinService.getGetEmployees(keyword, skip);
        return TwOutputUtil.ok((Object)result);
    }

    public QiXinController(QiXinService qiXinService, RedisUtils redisUtils) {
        this.qiXinService = qiXinService;
        this.redisUtils = redisUtils;
    }
}

