/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.sale.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractVO;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sale"})
public class SaleContractController {
    private static final Logger log = LoggerFactory.getLogger(SaleContractController.class);
    private final SaleContractService service;

    @PostMapping(value={"/contract"})
    public TwOutputUtil insert(SaleContractPayload payload) {
        return TwOutputUtil.ok((Object)this.service.insert(payload));
    }

    @PutMapping(value={"/contract"})
    public TwOutputUtil update(SaleContractPayload payload) {
        return TwOutputUtil.ok((Object)this.service.update(payload));
    }

    @GetMapping(value={"/contract/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        SaleContractVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok((Object)vo);
    }

    @GetMapping(value={"/contract/paging"})
    public TwOutputUtil paging(SaleContractQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok((Object)paging);
    }

    @GetMapping(value={"/contract/list"})
    public TwOutputUtil queryList(SaleContractQuery query) {
        List vos = this.service.queryList(query);
        return TwOutputUtil.ok((Object)vos);
    }

    @DeleteMapping(value={"/contract/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public SaleContractController(SaleContractService service) {
        this.service = service;
    }
}

