/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.sale.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileRefService;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileService;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVO;
import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractTempPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractTempQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractTempService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractTempVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdFileBusinessTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdFileDocTypeEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sale"})
public class SaleContractTempController {
    private static final Logger log = LoggerFactory.getLogger(SaleContractTempController.class);
    private final SaleContractTempService service;
    private final PrdFileService prdFileService;
    private final PrdFileRefService prdFileRefService;

    @PostMapping(value={"/contractTemp"})
    public TwOutputUtil insert(SaleContractTempPayload payload) throws IOException {
        if (StringUtils.isEmpty((CharSequence)payload.getName())) {
            throw TwException.error((String)"", (String)"name is empty");
        }
        SaleContractTempVO insert = this.service.insert(payload);
        PrdFileVO fileVo = this.prdFileService.createByContractTemp(payload.getName(), null);
        ArrayList<PrdFileVO> listFile = new ArrayList<PrdFileVO>();
        if (fileVo != null) {
            listFile.add(fileVo);
            this.prdFileRefService.insert(fileVo.getId(), insert.getId(), PrdFileBusinessTypeEnum.CONTRACT.getCode(), PrdFileDocTypeEnum.CONTRACT_TEMP.getCode());
        }
        insert.setListFile(listFile);
        return TwOutputUtil.ok((Object)insert);
    }

    @PutMapping(value={"/contractTemp"})
    public TwOutputUtil update(SaleContractTempPayload payload) {
        return TwOutputUtil.ok((Object)this.service.update(payload));
    }

    @GetMapping(value={"/contractTemp/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        SaleContractTempVO vo = this.service.queryByKey(key);
        List listFile = this.prdFileRefService.listFile(key, PrdFileBusinessTypeEnum.CONTRACT.getCode(), PrdFileDocTypeEnum.CONTRACT_TEMP.getCode());
        vo.setListFile(listFile);
        return TwOutputUtil.ok((Object)vo);
    }

    @GetMapping(value={"/contractTemp/paging"})
    public TwOutputUtil paging(SaleContractTempQuery query) {
        PagingVO paging = this.service.paging(query);
        paging.getRecords().forEach(saleContractTempVO -> {
            List listFile = this.prdFileRefService.listFile(saleContractTempVO.getId(), PrdFileBusinessTypeEnum.CONTRACT.getCode(), PrdFileDocTypeEnum.CONTRACT_TEMP.getCode());
            saleContractTempVO.setListFile(listFile);
        });
        return TwOutputUtil.ok((Object)paging);
    }

    @GetMapping(value={"/contractTemp/list"})
    public TwOutputUtil queryList(SaleContractTempQuery query) {
        List vos = this.service.queryList(query);
        vos.forEach(saleContractTempVO -> {
            List listFile = this.prdFileRefService.listFile(saleContractTempVO.getId(), PrdFileBusinessTypeEnum.CONTRACT.getCode(), PrdFileDocTypeEnum.CONTRACT_TEMP.getCode());
            saleContractTempVO.setListFile(listFile);
        });
        return TwOutputUtil.ok((Object)vos);
    }

    @DeleteMapping(value={"/contractTemp/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public SaleContractTempController(SaleContractTempService service, PrdFileService prdFileService, PrdFileRefService prdFileRefService) {
        this.service = service;
        this.prdFileService = prdFileService;
        this.prdFileRefService = prdFileRefService;
    }
}

