/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.schedule.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdCalendarQuery;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdCalendarDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.QPrdCalendarDO;
import com.elitesland.tw.tw5.server.prd.schedule.repo.PrdCalendarRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdCalendarDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdCalendarRepo repo;
    private final QPrdCalendarDO qdo = QPrdCalendarDO.prdCalendarDO;

    public PrdCalendarDO save(PrdCalendarDO ado) {
        return (PrdCalendarDO)this.repo.save(ado);
    }

    public List<PrdCalendarDO> saveAll(List<PrdCalendarDO> dos) {
        return this.repo.saveAll(dos);
    }

    public PrdCalendarVO queryByKey(Long id) {
        JPAQuery<PrdCalendarVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        return (PrdCalendarVO)jpaQuery.fetchFirst();
    }

    public List<PrdCalendarVO> queryByCreateUserId(Long userId) {
        JPAQuery<PrdCalendarVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.createUserId.eq((Object)userId));
        return jpaQuery.fetch();
    }

    public PrdCalendarVO queryByQyWxCalId(String id) {
        JPAQuery<PrdCalendarVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.qyWxCalId.eq((Object)id));
        return (PrdCalendarVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<PrdCalendarVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdCalendarVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.title, this.qdo.color, this.qdo.description, this.qdo.readonly, this.qdo.defaultFlag, this.qdo.createUserId, this.qdo.qyWxCalId})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    private JPAQuery<PrdCalendarVO> getJpaQueryWhere(PrdCalendarQuery query) {
        JPAQuery<PrdCalendarVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getTitle())) {
            jpaQuery.where((Predicate)this.qdo.title.like(SqlUtil.toSqlLikeString(query.getTitle())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDescription())) {
            jpaQuery.where((Predicate)this.qdo.description.like(SqlUtil.toSqlLikeString(query.getDescription())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDefaultFlag())) {
            jpaQuery.where((Predicate)this.qdo.defaultFlag.eq((Object)query.getDefaultFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((Predicate)this.qdo.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCalIds())) {
            jpaQuery.where((Predicate)this.qdo.id.in((Collection)query.getCalIds()));
        } else {
            jpaQuery.where((Predicate)this.qdo.id.in(Collections.singletonList(-1L)));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public List<PrdCalendarVO> queryListDynamic(PrdCalendarQuery query) {
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.setOrders(Arrays.asList(orderItem));
        JPAQuery<PrdCalendarVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PrdCalendarVO> queryPaging(PrdCalendarQuery query) {
        JPAQuery<PrdCalendarVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public long updateByKeyDynamic(PrdCalendarPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getTitle() != null) {
            update.set((Path)this.qdo.title, (Object)payload.getTitle());
        }
        if (payload.getDescription() != null) {
            update.set((Path)this.qdo.description, (Object)payload.getDescription());
        }
        if (payload.getColor() != null) {
            update.set((Path)this.qdo.color, (Object)payload.getColor());
        }
        if (payload.getReadonly() != null) {
            update.set(this.qdo.readonly, (Object)payload.getReadonly());
        }
        if ((nullFields = payload.getNullFields()) == null || nullFields.size() > 0) {
            // empty if block
        }
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public PrdCalendarDAO(JPAQueryFactory jpaQueryFactory, PrdCalendarRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

