/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdCommentPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdCommentQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdCommentVO;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/system"})
public class PrdCommentController {
    private static final Logger log = LoggerFactory.getLogger(PrdCommentController.class);
    private final PrdCommentService service;

    @PostMapping(value={"/comment"})
    public TwOutputUtil insert(PrdCommentPayload payload) {
        return TwOutputUtil.ok((Object)this.service.insert(payload));
    }

    @PutMapping(value={"/comment"})
    public TwOutputUtil update(PrdCommentPayload payload) {
        return TwOutputUtil.ok((Object)this.service.update(payload));
    }

    @GetMapping(value={"/comment/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        PrdCommentVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok((Object)vo);
    }

    @GetMapping(value={"/comment/paging"})
    public TwOutputUtil paging(PrdCommentQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok((Object)paging);
    }

    @GetMapping(value={"/comment/pagingPro"})
    public TwOutputUtil pagingPro(PrdCommentQuery query) {
        PagingVO paging = this.service.pagingPro(query);
        return TwOutputUtil.ok((Object)paging);
    }

    @GetMapping(value={"/comment/listPro"})
    public TwOutputUtil queryListPro(PrdCommentQuery query) {
        List vos = this.service.queryListPro(query);
        return TwOutputUtil.ok((Object)vos);
    }

    @GetMapping(value={"/comment/list"})
    public TwOutputUtil queryList(PrdCommentQuery query) {
        List vos = this.service.queryList(query);
        return TwOutputUtil.ok((Object)vos);
    }

    @DeleteMapping(value={"/comment/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public PrdCommentController(PrdCommentService service) {
        this.service = service;
    }
}

