/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFunctionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7cfb\u7edf\u529f\u80fd\u5904\u7406")
@RestController
@RequestMapping(value={"/api/system"})
public class PrdSystemFunctionController {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemFunctionController.class);
    private final PrdSystemFunctionService service;
    private final CacheUtil cacheUtil;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/function/insert"})
    public TwOutputUtil insert(PrdSystemFunctionPayload entity) {
        PrdSystemFunctionVO vo = this.service.insert(entity);
        return TwOutputUtil.ok((Object)vo);
    }

    @ApiOperation(value="\u6e05\u7a7a\u529f\u80fd\u7f13\u5b58")
    @GetMapping(value={"/function/clearCache"})
    public TwOutputUtil clearCache() {
        this.cacheUtil.loadSystemFunctionCache();
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/function/update"})
    public TwOutputUtil update(PrdSystemFunctionPayload entity) {
        this.service.update(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/function/delete"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    @GetMapping(value={"/function/{key}"})
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemFunctionVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok((Object)vo);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/function/paging"})
    public TwOutputUtil findByConditionPaging(PrdSystemFunctionQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok((Object)paging);
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/function/list"})
    public TwOutputUtil queryList(PrdSystemFunctionQuery query) {
        List paging = this.service.queryList(query);
        return TwOutputUtil.ok((Object)paging);
    }

    public PrdSystemFunctionController(PrdSystemFunctionService service, CacheUtil cacheUtil) {
        this.service = service;
        this.cacheUtil = cacheUtil;
    }
}

