/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSelectionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSelectionQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7cfb\u7edf\u9009\u62e9\u9879")
@RestController
@RequestMapping(value={"/api/system"})
public class PrdSystemSelectionController {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemSelectionController.class);
    private final PrdSystemSelectionService service;
    private final CacheUtil cacheUtil;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/systemSelection"})
    public TwOutputUtil insert(PrdSystemSelectionPayload entity) {
        PrdSystemSelectionVO vo = this.service.insert(entity);
        return TwOutputUtil.ok((Object)vo);
    }

    @ApiOperation(value="\u6e05\u7a7a\u6d88\u606f\u63d0\u9192\u7f13\u5b58")
    @GetMapping(value={"/systemSelection/clearCache"})
    public TwOutputUtil clearCache() {
        this.cacheUtil.loadSystemSelectionCache();
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/systemSelection"})
    public TwOutputUtil update(PrdSystemSelectionPayload entity) {
        this.service.update(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/systemSelection"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @PatchMapping(value={"/systemSelection"})
    public TwOutputUtil logicalDelete(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    @GetMapping(value={"/systemSelection/{key}"})
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemSelectionVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok((Object)vo);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/systemSelection/paging"})
    public TwOutputUtil findByConditionPaging(PrdSystemSelectionQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok((Object)paging);
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/systemSelection/list"})
    public TwOutputUtil queryList(PrdSystemSelectionQuery query) {
        List paging = this.service.queryList(query);
        return TwOutputUtil.ok((Object)paging);
    }

    @ApiOperation(value="\u901a\u8fc7KEY\u67e5\u8be2\u76f4\u5c5e\u5b50\u96c6")
    @GetMapping(value={"/systemSelection/byKey/{key}"})
    public TwOutputUtil getSystemSelectionByKey(@PathVariable String key) {
        List collect = this.service.selectByCondition(key);
        return TwOutputUtil.ok((Object)collect);
    }

    @ApiOperation(value="\u901a\u8fc7KEY\u67e5\u8be2\u6811\u72b6\u5b50\u96c6")
    @GetMapping(value={"/systemSelection/byKeyAll/{key}"})
    public TwOutputUtil getSystemSelectionAllByKey(@PathVariable String key) {
        PrdSystemSelectionVO view = this.cacheUtil.getSystemSelection(key);
        if (view == null || view.getChildren() == null || view.getChildren().isEmpty()) {
            return TwOutputUtil.ok(Collections.emptyList());
        }
        return TwOutputUtil.ok((Object)view.getChildren());
    }

    @GetMapping(value={"/systemSelection/childrenList"})
    public TwOutputUtil getSystemSelectionChildrenList(PrdSystemSelectionQuery query) {
        long t = System.currentTimeMillis();
        List data = this.service.getSystemSelectionChildrenList(query);
        log.info("getSystemSelectionChildrenList\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - t));
        return TwOutputUtil.ok((Object)data);
    }

    @ApiOperation(value="\u67e5\u8be2\u7ea7\u8054\u7cfb\u7edf\u9009\u62e9\u9879")
    @GetMapping(value={"/systemSelection/cascader"})
    public TwOutputUtil getSystemSelectionByKey(String key, String[] cascaderValues) {
        PrdSystemSelectionVO view = this.cacheUtil.getSystemSelection(key);
        if (view == null || view.getChildren() == null || view.getChildren().isEmpty()) {
            return TwOutputUtil.ok(Collections.emptyList());
        }
        List<PrdSystemSelectionVO> children = view.getChildren();
        if (cascaderValues != null) {
            for (int i = 0; i < cascaderValues.length; ++i) {
                int valueIndex = i;
                if ((children = children.stream().filter(selectionView -> selectionView.getSelectionValue().equals(cascaderValues[valueIndex])).findFirst().orElse(new PrdSystemSelectionVO()).getChildren()) != null) continue;
                children = Collections.emptyList();
            }
        }
        ArrayList list = new ArrayList(children.size());
        children.forEach(selectionView -> list.add(selectionView.clone()));
        list.forEach(selectionView -> selectionView.setChildren(null));
        List collect = list.stream().sorted(Comparator.comparing(selectionView -> selectionView.getSortNo() == null ? Integer.MAX_VALUE : selectionView.getSortNo())).collect(Collectors.toList());
        return TwOutputUtil.ok(collect);
    }

    public PrdSystemSelectionController(PrdSystemSelectionService service, CacheUtil cacheUtil) {
        this.service = service;
        this.cacheUtil = cacheUtil;
    }
}

