/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdTemporaryStoragePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdTemporaryStorageQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdTemporaryStorageService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdTemporaryStorageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6682\u5b58\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/system"})
public class PrdSystemStorageController {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemStorageController.class);
    private final PrdTemporaryStorageService service;

    @ApiOperation(value="\u65b0\u589e\u548c\u4fee\u6539")
    @PostMapping(value={"/storage/saveOne"})
    public TwOutputUtil insert(@RequestBody PrdTemporaryStoragePayload payload) {
        PrdTemporaryStorageVO vo = this.service.saveOne(payload);
        return TwOutputUtil.ok((Object)vo);
    }

    @PostMapping(value={"/storage/dynamicUpdate"})
    public TwOutputUtil dynamicUpdate(@RequestBody PrdTemporaryStoragePayload payload) {
        this.service.dynamicUpdate(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/storage/list"})
    public TwOutputUtil queryList(PrdTemporaryStorageQuery query) {
        List list = this.service.queryList(query);
        return TwOutputUtil.ok((Object)list);
    }

    @GetMapping(value={"/storage/paging"})
    public TwOutputUtil paging(PrdTemporaryStorageQuery query) {
        return TwOutputUtil.ok((Object)this.service.paging(query));
    }

    @ApiOperation(value="\u8be6\u60c5\u67e5\u8be2")
    @GetMapping(value={"/storage/detail/{id}"})
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        PrdTemporaryStorageVO vo = this.service.queryDetail(id);
        return TwOutputUtil.ok((Object)vo);
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/storage/delete"})
    public TwOutputUtil delete(@RequestParam List<Long> storageIds) {
        this.service.deleteTemporaryStorageSoft(storageIds);
        return TwOutputUtil.ok();
    }

    public PrdSystemStorageController(PrdTemporaryStorageService service) {
        this.service = service;
    }
}

