/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemWorkTypeQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemWorkTypeService;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/system"})
public class PrdSystemWorkTypeController {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemWorkTypeController.class);
    private final PrdSystemWorkTypeService service;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/workType/paging"})
    public TwOutputUtil findByConditionPaging(PrdSystemWorkTypeQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok((Object)paging);
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/workType/list"})
    public TwOutputUtil queryList() {
        return TwOutputUtil.ok((Object)this.service.queryList());
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/workType"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/workType"})
    public TwOutputUtil update(Long key, String sysType, String sysWork, String sysLevel, BigDecimal unitPrice) {
        this.service.update(key, sysType, sysWork, sysLevel, unitPrice);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/workType/batchExport"})
    public void batchExport(HttpServletResponse response, PrdSystemWorkTypeQuery query) {
        this.service.downloadPlus(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/workType/batchImport"}, consumes={"multipart/form-data"})
    @Transactional
    public TwOutputUtil batchImport(MultipartFile file) {
        this.service.importWorkType(file);
        return TwOutputUtil.ok();
    }

    public PrdSystemWorkTypeController(PrdSystemWorkTypeService service) {
        this.service = service;
    }
}

