/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemMenuPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemMenuQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemMenuService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemMenuConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemMenuDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemMenuDO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PrdSystemMenuServiceImpl
implements PrdSystemMenuService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemMenuServiceImpl.class);
    private final PrdSystemMenuDAO dao;

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @Transactional
    public PrdSystemMenuVO insert(PrdSystemMenuPayload payload) {
        PrdSystemMenuQuery query = new PrdSystemMenuQuery();
        query.setMenuCode(payload.getMenuCode());
        int count = this.dao.queryList(query).size();
        if (count > 0) {
            throw TwException.error((String)"", (String)"\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        PrdSystemMenuDO ado = PrdSystemMenuConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        return PrdSystemMenuConvert.INSTANCE.toVo(ado);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @Transactional
    public Long update(PrdSystemMenuPayload payload) {
        PrdSystemMenuQuery query = new PrdSystemMenuQuery();
        query.setMenuCode(payload.getMenuCode());
        List<PrdSystemMenuVO> list = this.dao.queryList(query);
        if (list.size() == 0 || list.size() == 1 && list.get(0).getId().longValue() == payload.getId().longValue()) {
            if (payload.getMenuStatus() == 1) {
                ArrayList<Long> menuIds = new ArrayList<Long>();
                this.getUpdateMenu(payload.getId(), menuIds, list);
                this.dao.updateStatus(menuIds, 1);
            }
            this.dao.updateByKeyDynamic(payload);
            return 0L;
        }
        throw TwException.error((String)"", (String)"\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @Transactional
    public Long updateStatus(Long id, Integer status) {
        if (!ObjectUtils.isEmpty((Object)id) && !ObjectUtils.isEmpty((Object)status)) {
            ArrayList<Long> menuIds = new ArrayList<Long>();
            menuIds.add(id);
            if (status == 1) {
                List<PrdSystemMenuVO> menuVOS = this.dao.usableList();
                this.getUpdateMenu(id, menuIds, menuVOS);
            }
            this.dao.updateStatus(menuIds, status);
            return 0L;
        }
        throw TwException.error((String)"", (String)"\u53c2\u6570\u9519\u8bef");
    }

    void getUpdateMenu(Long munuId, List<Long> menuIds, List<PrdSystemMenuVO> menuVOS) {
        for (PrdSystemMenuVO menuVO : menuVOS) {
            if (menuVO.getMenuStatus() != 0 || menuVO.getParentId() == null || menuVO.getParentId().longValue() != munuId.longValue()) continue;
            menuIds.add(menuVO.getId());
            this.getUpdateMenu(menuVO.getId(), menuIds, menuVOS);
        }
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @Transactional
    public boolean delete(Long key) {
        PrdSystemMenuQuery query = new PrdSystemMenuQuery();
        query.setParentId(key);
        List<PrdSystemMenuVO> pvos = this.dao.queryList(query);
        if (pvos != null && pvos.size() > 0) {
            throw TwException.error((String)"", (String)"\u5b58\u5728\u5b50\u9879\u6570\u636e");
        }
        this.dao.delete(key);
        return true;
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @Transactional
    public boolean deleteSoft(Long key) {
        PrdSystemMenuQuery query = new PrdSystemMenuQuery();
        List<PrdSystemMenuVO> pvos = this.dao.queryList(query);
        ArrayList<Long> menuIds = new ArrayList<Long>();
        menuIds.add(key);
        this.getUpdateMenu(key, menuIds, pvos);
        this.dao.deleteSoft(menuIds);
        return true;
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public PrdSystemMenuVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<PrdSystemMenuVO> queryList() {
        PrdSystemMenuQuery query = new PrdSystemMenuQuery();
        List<PrdSystemMenuVO> pvos = this.dao.queryList(query);
        GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();
        if (loginGeneralUser.isTenantAdmin()) {
            return pvos.stream().filter(menuVO_ -> !menuVO_.getPortalRoute().contains("/tenancy")).collect(Collectors.toList());
        }
        return pvos;
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<PrdSystemMenuVO> usableList() {
        List<PrdSystemMenuVO> prdSystemMenuVOS = this.dao.usableList();
        GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();
        if (loginGeneralUser.isSystemAdmin() || loginGeneralUser.isTenantAdmin()) {
            return prdSystemMenuVOS.stream().filter(menuVO_ -> !menuVO_.getPortalRoute().contains("/tenancy")).collect(Collectors.toList());
        }
        return prdSystemMenuVOS;
    }

    public List<PrdSystemMenuVO> selectByCondition(String key) {
        return null;
    }

    public PrdSystemMenuServiceImpl(PrdSystemMenuDAO dao) {
        this.dao = dao;
    }
}

