/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemProblemFeedbackPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackProcessQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackProcessService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackProcessVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemProblemFeedbackConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemProblemFeedbackDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemProblemFeedbackProcessDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemProblemFeedbackDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemProblemFeedbackProcessDO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdSystemProblemFeedbackServiceImpl
implements PrdSystemProblemFeedbackService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemProblemFeedbackServiceImpl.class);
    private final PrdSystemProblemFeedbackDAO dao;
    private final PrdSystemProblemFeedbackProcessService processService;
    private final PrdSystemProblemFeedbackProcessDAO processDAO;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleDAO roleDAO;
    @Autowired
    private SysUserRpcService sysUserService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdMessageConfigService messageConfigService;

    @Transactional
    public PrdSystemProblemFeedbackVO insert(PrdSystemProblemFeedbackPayload payload) {
        String userName;
        PrdSystemProblemFeedbackDO ado = PrdSystemProblemFeedbackConvert.INSTANCE.toDo(payload);
        ado.setFeedbackStatus("handing");
        ado.setReplyStatus("2");
        ado.setReadAmount(0L);
        ado.setCommonFlag(0);
        ado.setUrgentFlag(0);
        List<Long> operationAdmins = this.roleDAO.queryUserIdByRoleCode(RoleEnum.OPS.getCode());
        if (operationAdmins != null && !operationAdmins.isEmpty()) {
            ado.setDirectorUserId(operationAdmins.get(0));
        }
        ado = this.dao.save(ado);
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        PrdSystemProblemFeedbackProcessDO processDO = new PrdSystemProblemFeedbackProcessDO();
        processDO.setFeedbackId(ado.getId());
        String content = current.getLastName() + "\u63d0\u51fa\u4e86\u95ee\u9898\u53cd\u9988";
        processDO.setContent(content);
        this.processDAO.save(processDO);
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        String string = userName = userDetails == null ? "" : userDetails.getUser().getUsername();
        if (operationAdmins != null && !operationAdmins.isEmpty()) {
            String noticeSource = org.apache.commons.lang3.StringUtils.join(operationAdmins, (String)",");
            PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20220711001504");
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("fromUser", userName);
            result.put("action", "\u56de\u590d\u4e86");
            result.put("url", String.format("/basic/feedback/operationFeedback/operaFeedbackView?id=%s", ado.getId()));
            this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
        }
        return PrdSystemProblemFeedbackConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public PrdSystemProblemFeedbackVO update(PrdSystemProblemFeedbackPayload payload) {
        PrdSystemProblemFeedbackDO ado = PrdSystemProblemFeedbackConvert.INSTANCE.toDo(payload);
        ado = this.dao.save(ado);
        return PrdSystemProblemFeedbackConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long updateByKeyDynamic(PrdSystemProblemFeedbackPayload payload) {
        return this.dao.updateByKeyDynamic(payload);
    }

    public PagingVO<PrdSystemProblemFeedbackVO> paging(PrdSystemProblemFeedbackQuery query) {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        Long userId = user.getUser().getId();
        List<Long> messageToUserIds = this.roleDAO.queryUserIdByRoleCode(RoleEnum.OPS.getCode());
        ArrayList orders = Lists.newArrayList();
        if (!ObjectUtils.isEmpty((Object)query.getPageFlag()) && query.getPageFlag().compareTo(1) == 0) {
            OrderItem orderItem1 = new OrderItem();
            orderItem1.setColumn("urgentFlag");
            orderItem1.setAsc(false);
            orders.add(orderItem1);
        }
        OrderItem orderItem2 = new OrderItem();
        orderItem2.setColumn("createTime");
        orderItem2.setAsc(false);
        query.setOrders((List)orders);
        orders.add(orderItem2);
        PagingVO<PrdSystemProblemFeedbackVO> pagingVO = this.dao.queryPaging(query);
        List feedbackVOList = pagingVO.getRecords();
        if (CollectionUtils.isEmpty((Collection)feedbackVOList)) {
            return pagingVO;
        }
        List feedbackIdList = feedbackVOList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        PrdSystemProblemFeedbackProcessQuery processQuery = new PrdSystemProblemFeedbackProcessQuery();
        processQuery.setFeedbackIdList(feedbackIdList);
        List<PrdSystemProblemFeedbackProcessVO> processVOList = this.processDAO.queryListDynamic(processQuery);
        LocalDateTime now = LocalDateTime.now();
        for (PrdSystemProblemFeedbackVO feedbackVO : feedbackVOList) {
            PrdSystemProblemFeedbackProcessVO processVO = processVOList.stream().filter(e -> e.getFeedbackId().compareTo(feedbackVO.getId()) == 0).max((a1, a2) -> a1.getCreateTime().compareTo(a2.getCreateTime())).get();
            if (ObjectUtils.isEmpty((Object)processVO)) continue;
            feedbackVO.setLastProcessTime(processVO.getCreateTime());
            feedbackVO.setReplyTime(processVO.getCreateTime());
            long noReplyTimeInterval = ChronoUnit.HOURS.between(processVO.getCreateTime(), now);
            feedbackVO.setNoReplyTimeInterval(Long.valueOf(noReplyTimeInterval));
        }
        this.transaction(feedbackVOList);
        return pagingVO;
    }

    @Transactional
    public PrdSystemProblemFeedbackVO queryByKey(Long key) {
        PrdSystemProblemFeedbackVO problemFeedbackVO = this.dao.queryByKey(key);
        if (ObjectUtils.isEmpty((Object)problemFeedbackVO)) {
            return problemFeedbackVO;
        }
        PrdSystemProblemFeedbackProcessQuery query = new PrdSystemProblemFeedbackProcessQuery();
        query.setFeedbackIdList(Collections.singletonList(problemFeedbackVO.getId()));
        OrderItem orderItem = new OrderItem();
        orderItem.setColumn("createTime");
        orderItem.setAsc(true);
        query.setOrders(Collections.singletonList(orderItem));
        List processVOList = this.processService.queryList(query);
        problemFeedbackVO.setProcessList(processVOList);
        PrdSystemProblemFeedbackPayload payload = new PrdSystemProblemFeedbackPayload();
        payload.setId(problemFeedbackVO.getId());
        payload.setReadAmount(Long.valueOf(problemFeedbackVO.getReadAmount() + 1L));
        this.dao.updateByKeyDynamic(payload);
        this.transaction(Collections.singletonList(problemFeedbackVO));
        return problemFeedbackVO;
    }

    @Transactional
    public void closeProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        List handleIds = payload.getHandleIds();
        if (CollectionUtils.isEmpty((Collection)handleIds)) {
            throw TwException.error((String)"", (String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6216\u591a\u4e2a\u64cd\u4f5c\u6570\u636e");
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        ArrayList<PrdSystemProblemFeedbackDO> feedbackDOList = new ArrayList<PrdSystemProblemFeedbackDO>();
        ArrayList<PrdSystemProblemFeedbackProcessDO> processDOList = new ArrayList<PrdSystemProblemFeedbackProcessDO>();
        List<PrdSystemProblemFeedbackDO> prdSystemProblemFeedbackDOS = this.dao.queryDyIdIn(handleIds);
        if (CollectionUtils.isEmpty(prdSystemProblemFeedbackDOS)) {
            throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        for (Long id : handleIds) {
            PrdSystemProblemFeedbackDO feedbackDO = prdSystemProblemFeedbackDOS.stream().filter(e -> id.compareTo(e.getId()) == 0).findFirst().get();
            if (ObjectUtils.isEmpty((Object)feedbackDO)) {
                throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
            }
            feedbackDO.setId(id);
            if (StringUtils.hasText((String)payload.getCloseReason())) {
                feedbackDO.setCloseReason(payload.getCloseReason());
            }
            feedbackDO.setFeedbackStatus("close");
            feedbackDO.setUrgentFlag(0);
            feedbackDOList.add(feedbackDO);
            PrdSystemProblemFeedbackProcessDO processDO = new PrdSystemProblemFeedbackProcessDO();
            processDO.setFeedbackId(id);
            Object content = "";
            content = StringUtils.hasText((String)payload.getCloseReasonDesc()) ? current.getLastName() + "\u5173\u95ed\u4e86\u95ee\u9898\u53cd\u9988, \u5173\u95ed\u7406\u7531\u4e3a:" + payload.getCloseReasonDesc() : current.getLastName() + "\u5173\u95ed\u4e86\u95ee\u9898\u53cd\u9988";
            processDO.setContent((String)content);
            processDOList.add(processDO);
        }
        this.dao.saveAll(feedbackDOList);
        this.processDAO.saveAll(processDOList);
    }

    public void openProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        List handleIds = payload.getHandleIds();
        if (CollectionUtils.isEmpty((Collection)handleIds)) {
            throw TwException.error((String)"", (String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6216\u591a\u4e2a\u64cd\u4f5c\u6570\u636e");
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        ArrayList<PrdSystemProblemFeedbackDO> feedbackDOList = new ArrayList<PrdSystemProblemFeedbackDO>();
        ArrayList<PrdSystemProblemFeedbackProcessDO> processDOList = new ArrayList<PrdSystemProblemFeedbackProcessDO>();
        List<PrdSystemProblemFeedbackDO> prdSystemProblemFeedbackDOS = this.dao.queryDyIdIn(handleIds);
        for (Long id : handleIds) {
            PrdSystemProblemFeedbackDO feedbackDO = prdSystemProblemFeedbackDOS.stream().filter(e -> id.compareTo(e.getId()) == 0).findFirst().get();
            if (ObjectUtils.isEmpty((Object)feedbackDO)) {
                throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
            }
            feedbackDO.setId(id);
            feedbackDO.setFeedbackStatus("handing");
            feedbackDOList.add(feedbackDO);
            PrdSystemProblemFeedbackProcessDO processDO = new PrdSystemProblemFeedbackProcessDO();
            processDO.setFeedbackId(id);
            String content = current.getLastName() + "\u6253\u5f00\u4e86\u95ee\u9898\u53cd\u9988";
            processDO.setContent(content);
            processDOList.add(processDO);
        }
        this.dao.saveAll(feedbackDOList);
        this.processDAO.saveAll(processDOList);
    }

    public void urgentProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        List handleIds = payload.getHandleIds();
        if (CollectionUtils.isEmpty((Collection)handleIds)) {
            throw TwException.error((String)"", (String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6216\u591a\u4e2a\u64cd\u4f5c\u6570\u636e");
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        ArrayList<PrdSystemProblemFeedbackDO> feedbackDOList = new ArrayList<PrdSystemProblemFeedbackDO>();
        ArrayList<PrdSystemProblemFeedbackProcessDO> processDOList = new ArrayList<PrdSystemProblemFeedbackProcessDO>();
        List<PrdSystemProblemFeedbackDO> prdSystemProblemFeedbackDOS = this.dao.queryDyIdIn(handleIds);
        for (Long id : handleIds) {
            PrdSystemProblemFeedbackDO feedbackDO = prdSystemProblemFeedbackDOS.stream().filter(e -> id.compareTo(e.getId()) == 0).findFirst().get();
            if (ObjectUtils.isEmpty((Object)feedbackDO)) {
                throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
            }
            feedbackDO.setId(id);
            feedbackDO.setUrgentFlag(1);
            feedbackDOList.add(feedbackDO);
            PrdSystemProblemFeedbackProcessDO processDO = new PrdSystemProblemFeedbackProcessDO();
            processDO.setFeedbackId(id);
            String content = current.getLastName() + "\u8bf7\u6c42\u52a0\u6025\u5904\u7406\u95ee\u9898\u53cd\u9988";
            processDO.setContent(content);
            processDOList.add(processDO);
        }
        this.dao.saveAll(feedbackDOList);
        this.processDAO.saveAll(processDOList);
    }

    public void commonProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        List handleIds = payload.getHandleIds();
        if (CollectionUtils.isEmpty((Collection)handleIds)) {
            throw TwException.error((String)"", (String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6216\u591a\u4e2a\u64cd\u4f5c\u6570\u636e");
        }
        ArrayList<PrdSystemProblemFeedbackDO> feedbackDOList = new ArrayList<PrdSystemProblemFeedbackDO>();
        List<PrdSystemProblemFeedbackDO> prdSystemProblemFeedbackDOS = this.dao.queryDyIdIn(handleIds);
        for (Long id : handleIds) {
            PrdSystemProblemFeedbackDO feedbackDO = prdSystemProblemFeedbackDOS.stream().filter(e -> id.compareTo(e.getId()) == 0).findFirst().get();
            if (ObjectUtils.isEmpty((Object)feedbackDO)) {
                throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
            }
            feedbackDO.setId(id);
            feedbackDO.setCommonFlag(payload.getCommonFlag());
            feedbackDOList.add(feedbackDO);
        }
        this.dao.saveAll(feedbackDOList);
    }

    public Map<String, List<Map<String, Object>>> statisticalNumber(LocalDateTime startDate, LocalDateTime endDate) {
        List<Map<String, Object>> numberStatisticalByAll = this.dao.findNumberStatisticalByAll(startDate, endDate);
        List<Map<String, Object>> numberStatisticalByClose = this.dao.findNumberStatisticalByClose(startDate, endDate);
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("all", numberStatisticalByAll);
        resultMap.put("close", numberStatisticalByClose);
        return resultMap;
    }

    public List<Map<String, Object>> findNumberStatisticalGroupByProblemType(LocalDateTime startDate, LocalDateTime endDate) {
        List<Map<String, Object>> jpaResult = this.dao.findNumberStatisticalGroupByProblemType(startDate, endDate);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> result : jpaResult) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(result);
            resultList.add(resultMap);
            if (ObjectUtils.isEmpty((Object)result.get("problemType"))) continue;
            String problemType = this.cacheUtil.transferSystemSelection("sys:problem_feedback:problem_type", (String)result.get("problemType"));
            resultMap.put("problemType", problemType);
        }
        return resultList;
    }

    public List<Map<String, Object>> findNumberStatisticalGroupByFunctionId(LocalDateTime startDate, LocalDateTime endDate) {
        List<Map<String, Object>> jpaResult = this.dao.findNumberStatisticalGroupByFunctionId(startDate, endDate);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> result : jpaResult) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(result);
            resultList.add(resultMap);
            if (ObjectUtils.isEmpty((Object)result.get("functionId"))) continue;
            String functionName = this.cacheUtil.getFunctionById(Long.valueOf(String.valueOf(result.get("functionId")))).getFunctionName();
            resultMap.put("functionName", functionName);
        }
        return resultList;
    }

    public Long findWorkProblemFeedbackByUserId(Long userId) {
        List<Long> messageToUserIds = this.roleDAO.queryUserIdByRoleCode(RoleEnum.OPS.getCode());
        PrdSystemProblemFeedbackQuery query = new PrdSystemProblemFeedbackQuery();
        query.setReplyStatus("1");
        query.setFeedbackStatus("handing");
        query.setDirectorUserId(userId);
        return this.dao.queryPaging(query).getTotal();
    }

    private void transaction(List<PrdSystemProblemFeedbackVO> list) {
        ArrayList userIdList = new ArrayList();
        list.stream().forEach(e -> {
            if (!ObjectUtils.isEmpty((Object)e.getDirectorUserId())) {
                userIdList.add(e.getDirectorUserId());
            }
            if (!ObjectUtils.isEmpty((Object)e.getCreateUserId())) {
                userIdList.add(e.getCreateUserId());
            }
        });
        List sysUserVOS = this.sysUserService.getByIds(userIdList);
        Map sysUserVOMap = sysUserVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
        for (PrdSystemProblemFeedbackVO vo : list) {
            SysUserVO createUser;
            PrdSystemFunctionVO systemFunctionVO;
            SysUserVO sysUser;
            vo.setFeedbackStatusDesc(this.cacheUtil.transferSystemSelection("sys:problem_feedback:feedback_status", vo.getFeedbackStatus()));
            vo.setReplyStatusDesc(this.cacheUtil.transferSystemSelection("sys:problem_feedback:reply_status", vo.getReplyStatus()));
            vo.setProblemTypeDesc(this.cacheUtil.transferSystemSelection("sys:problem_feedback:problem_type", vo.getProblemType()));
            if (!ObjectUtils.isEmpty((Object)vo.getDirectorUserId()) && !ObjectUtils.isEmpty((Object)(sysUser = (SysUserVO)sysUserVOMap.get(vo.getDirectorUserId())))) {
                vo.setDirectorUserIdDesc(sysUser.getFirstName());
            }
            vo.setLevelDesc(this.cacheUtil.transferSystemSelection("sys:problem_feedback:feedback_level", vo.getLevel()));
            if (!ObjectUtils.isEmpty((Object)vo.getFunctionId()) && !ObjectUtils.isEmpty((Object)(systemFunctionVO = this.cacheUtil.getFunctionById(vo.getFunctionId())))) {
                String functionName = systemFunctionVO.getFunctionName();
                vo.setFunctionIdDesc(functionName);
            }
            if (!ObjectUtils.isEmpty((Object)(createUser = (SysUserVO)sysUserVOMap.get(vo.getCreateUserId())))) {
                vo.setCreateUserName(createUser.getFirstName());
            }
            vo.setCloseReasonDesc(this.cacheUtil.transferSystemSelection("sys:problem_feedback:close_reason", vo.getCloseReason()));
        }
    }

    public PrdSystemProblemFeedbackServiceImpl(PrdSystemProblemFeedbackDAO dao, PrdSystemProblemFeedbackProcessService processService, PrdSystemProblemFeedbackProcessDAO processDAO, CacheUtil cacheUtil, PrdSystemRoleDAO roleDAO, PrdOrgEmployeeDAO employeeDAO, PrdMessageConfigService messageConfigService) {
        this.dao = dao;
        this.processService = processService;
        this.processDAO = processDAO;
        this.cacheUtil = cacheUtil;
        this.roleDAO = roleDAO;
        this.employeeDAO = employeeDAO;
        this.messageConfigService = messageConfigService;
    }
}

