/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemRoleConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PrdSystemRoleServiceImpl
implements PrdSystemRoleService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemRoleServiceImpl.class);
    private final PrdSystemRoleDAO dao;

    @Transactional
    public PrdSystemRoleVO insert(PrdSystemRolePayload payload) {
        if (this.dao.queryByCode(payload.getRoleCode()) != null) {
            throw TwException.error((String)"", (String)"\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        PrdSystemRoleDO ado = PrdSystemRoleConvert.INSTANCE.toDo(payload);
        ado = this.dao.save(ado);
        if (payload.getMenuIds() != null && payload.getMenuIds().size() > 0) {
            ArrayList<PrdSystemRoleMenuDO> roleMenuDOS = new ArrayList<PrdSystemRoleMenuDO>();
            for (Long menuId : payload.getMenuIds()) {
                PrdSystemRoleMenuDO roleMenuDO = new PrdSystemRoleMenuDO();
                roleMenuDO.setMenuId(menuId);
                roleMenuDO.setRoleId(ado.getId());
                roleMenuDOS.add(roleMenuDO);
            }
            this.dao.saveRoleMenuAll(roleMenuDOS);
        }
        if (payload.getUserIds() != null && payload.getUserIds().size() > 0) {
            ArrayList<PrdSystemUserRoleDO> userDOS = new ArrayList<PrdSystemUserRoleDO>();
            for (Long userId : payload.getUserIds()) {
                PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                userDO.setUserId(userId);
                userDO.setRoleId(ado.getId());
                userDOS.add(userDO);
            }
            this.dao.saveUserRoleAll(userDOS);
        }
        return PrdSystemRoleConvert.INSTANCE.toVo(ado);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemRoleVO insertByTenant(PrdSystemRolePayload payload) {
        if (this.dao.queryByCode(payload.getRoleCode()) != null) {
            throw TwException.error((String)"", (String)"\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        PrdSystemRoleDO ado = PrdSystemRoleConvert.INSTANCE.toDo(payload);
        if (null != payload.getInitTenantId()) {
            ado.setTenantId(payload.getInitTenantId());
        }
        ado = this.dao.save(ado);
        if (payload.getMenuIds() != null && payload.getMenuIds().size() > 0) {
            ArrayList<PrdSystemRoleMenuDO> roleMenuDOS = new ArrayList<PrdSystemRoleMenuDO>();
            for (Long menuId : payload.getMenuIds()) {
                PrdSystemRoleMenuDO roleMenuDO = new PrdSystemRoleMenuDO();
                roleMenuDO.setMenuId(menuId);
                roleMenuDO.setRoleId(ado.getId());
                if (null != payload.getInitTenantId()) {
                    roleMenuDO.setTenantId(payload.getInitTenantId());
                }
                roleMenuDOS.add(roleMenuDO);
            }
            this.dao.saveRoleMenuAll(roleMenuDOS);
        }
        if (payload.getUserIds() != null && payload.getUserIds().size() > 0) {
            ArrayList<PrdSystemUserRoleDO> userDOS = new ArrayList<PrdSystemUserRoleDO>();
            for (Long userId : payload.getUserIds()) {
                PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                userDO.setUserId(userId);
                userDO.setRoleId(ado.getId());
                if (null != payload.getInitTenantId()) {
                    userDO.setTenantId(payload.getInitTenantId());
                }
                userDOS.add(userDO);
            }
            this.dao.saveUserRoleAll(userDOS);
        }
        return PrdSystemRoleConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(PrdSystemRolePayload payload) {
        PrdSystemRoleVO roleVO = this.dao.queryByCode(payload.getRoleCode());
        if (roleVO != null && roleVO.getId().longValue() != payload.getId().longValue()) {
            throw TwException.error((String)"", (String)"\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        this.dao.updateByKeyDynamic(payload);
        if (payload.getMenuIds() != null) {
            if (payload.getMenuIds().size() > 0) {
                ArrayList<PrdSystemRoleMenuDO> roleMenuDOS = new ArrayList<PrdSystemRoleMenuDO>();
                for (Long menuId : payload.getMenuIds()) {
                    PrdSystemRoleMenuDO roleMenuDO = new PrdSystemRoleMenuDO();
                    roleMenuDO.setMenuId(menuId);
                    roleMenuDO.setRoleId(payload.getId());
                    roleMenuDOS.add(roleMenuDO);
                }
                this.dao.deleteRoleMenusByRoleId(payload.getId());
                this.dao.saveRoleMenuAll(roleMenuDOS);
            } else {
                this.dao.deleteRoleMenusByRoleId(payload.getId());
            }
        }
        if (payload.getUserIds() != null) {
            if (payload.getUserIds().size() > 0) {
                ArrayList<PrdSystemUserRoleDO> userDOS = new ArrayList<PrdSystemUserRoleDO>();
                for (Long userId : payload.getUserIds()) {
                    PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                    userDO.setUserId(userId);
                    userDO.setRoleId(payload.getId());
                    userDOS.add(userDO);
                }
                this.dao.deleteRolesByUserId(payload.getId());
                this.dao.saveUserRoleAll(userDOS);
            } else {
                this.dao.deleteRolesByUserId(payload.getId());
            }
        }
        return 0L;
    }

    @Transactional
    public Long updateStatus(Long id, Boolean enabled) {
        if (!ObjectUtils.isEmpty((Object)id) && !ObjectUtils.isEmpty((Object)enabled)) {
            this.dao.updateStatus(id, enabled);
            return 0L;
        }
        throw TwException.error((String)"", (String)"\u53c2\u6570\u9519\u8bef");
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        this.dao.deleteSoft(keys);
        return true;
    }

    public PrdSystemRoleVO queryByKey(Long key) {
        PrdSystemRoleVO roleVO = this.dao.queryByKey(key);
        roleVO.setMenuIds(this.dao.queryRoleMenuIds(key));
        roleVO.setUserDatas(this.dao.queryUsers(key));
        return roleVO;
    }

    public PagingVO<PrdSystemRoleVO> paging(PrdSystemRoleQuery query) {
        return this.dao.queryPaging(query);
    }

    public List<PrdSystemRoleVO> queryList() {
        return this.dao.queryList();
    }

    public PrdSystemRoleServiceImpl(PrdSystemRoleDAO dao) {
        this.dao = dao;
    }
}

