package com.elitesland.tw.tw5.server.common.QyWx.Controller;

import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.QyWx.service.WXPushService;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * @author zoey
 * @Description:
 * @date 2022/4/22 - 15:28
 */
@Api("企业微信回调")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/qywx/")
@Slf4j
public class QyWxCallbackController {
    private final QyWxCommunicationService service;

    private final WXPushService wxPushService;


    @GetMapping(value = "/telework")
    public String twAutograph(@RequestParam(name = "msg_signature") final String msgSignature,
                             @RequestParam(name = "timestamp") final String timestamp,
                             @RequestParam(name = "nonce") final String nonce,
                             @RequestParam(name = "echostr") final String echostr,
                             final HttpServletResponse response) throws Exception {
        return wxPushService.autograph(msgSignature,timestamp,nonce,echostr);

    }

    //TODO:以后有其他回调需要发送到这里的话，需要优化该方法
    @ResponseBody
    @PostMapping(value = "/telework")
    public String twAdecrypt(final HttpServletRequest request,
                          @RequestParam(name = "msg_signature") final String msgSignature,
                          @RequestParam(name = "timestamp") final String timestamp,
                          @RequestParam(name = "nonce") final String nonce
    ) {
        Map<String,String> content = wxPushService.decrypt(msgSignature,timestamp,nonce,request);
        //执行操作并封装返回
        String returnContent=wxPushService.doCallBack(content,timestamp,nonce);
        return returnContent;
    }



    /**
     * 验证签名
     * @param msgSignature
     * @param timestamp
     * @param nonce
     * @param echostr
     * @param response
     * @return
     * @throws Exception
     */
    @GetMapping(value = "/schedule")
    public String reveiceMsg(@RequestParam(name = "msg_signature") final String msgSignature,
                           @RequestParam(name = "timestamp") final String timestamp,
                           @RequestParam(name = "nonce") final String nonce,
                           @RequestParam(name = "echostr") final String echostr,
                           final HttpServletResponse response) throws Exception {
        return wxPushService.autograph(msgSignature,timestamp,nonce,echostr);

    }

    /**
     * 接收用户消息并解密
     * @param request
     * @param msgSignature
     * @param timestamp
     * @param nonce
     * @return
     */
    @ResponseBody
    @PostMapping(value = "/schedule")
    public String decrypt(final HttpServletRequest request,
                             @RequestParam(name = "msg_signature") final String msgSignature,
                             @RequestParam(name = "timestamp") final String timestamp,
                             @RequestParam(name = "nonce") final String nonce
                             ) {
        Map<String,String> content = wxPushService.decrypt(msgSignature,timestamp,nonce,request);
        return null;
        //将content返回
//        String encryptStr = wxPushService.encrypt(timestamp, nonce);
//        return encryptStr;
    }




    /**
     * 手机号查询用户id
     */
    @ApiOperation("详情查询")
    @GetMapping("/queryId")
    public TwOutputUtil getQyWxuserid() {
        service.getQyWxuserid("17717326306");
        return TwOutputUtil.ok();
    }


    /**
     * 发送下载用户请求
     */
    @ApiOperation("详情查询")
    @GetMapping("/exportUsersRequest")
    public TwOutputUtil exportUsersRequest() {
        service.exportUsersRequest();
        return TwOutputUtil.ok();
    }

    /**
     * 执行下载
     */
    @ApiOperation("详情查询")
    @GetMapping("/exportUsersExport")
    public TwOutputUtil exportUsersExport() {
        service.exportUsersExport();
        return TwOutputUtil.ok();
    }
}
