package com.elitesland.tw.tw5.server.common;

import com.elitesland.tw.tw5.api.common.TwException;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

/**
 * tw断言
 *
 * 待补充方法
 *
 * desc: 使用此断言，异常日志不会记录；
 * 使用org.springframework.util.Assert 断言，异常日志可记录；
 * 根据情况使用；
 *
 * @author duwh
 * @date 2023/02/16
 */
public class TwAssert {

    /**
     * Assert that an object is not {@code null}.
     * <pre class="code">Assert.notNull(clazz, "The class must not be null");</pre>
     * @param object the object to check
     * @param message the exception message to use if the assertion fails
     * @throws TwException if the object is {@code null}
     */
    public static void notNull(@Nullable Object object, String message) {
        if (object == null) {
            throw TwException.error("", message);
        }
    }


    /**
     * Assert that the given String contains valid text content; that is, it must not
     * be {@code null} and must contain at least one non-whitespace character.
     * <pre class="code">Assert.hasText(name, "'name' must not be empty");</pre>
     * @param text the String to check
     * @param message the exception message to use if the assertion fails
     * @throws TwException if the text does not contain valid text content
     * @see StringUtils#hasText
     */
    public static void hasText(@Nullable String text, String message) {
        if (!StringUtils.hasText(text)) {
            throw TwException.error("",message);
        }
    }
}
