package com.elitesland.tw.tw5.server.common.change.contorller;

import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author liwenpeng
 * @date 2021/9/26 14:05
 */
@Api("线索管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/businessChange")
@Slf4j
public class PrdSystemBusinessChangeController {

    private final PrdSystemBusinessChangeService service;

//    /**
//     * 变更历史
//     * @param query 查询条件
//     * @return ApiResult
//     */
//    @PostMapping("/changeHistory")
//    @ApiOperation("变更历史")
//    public ApiResult<PagingVO<PrdSystemBusinessChangeVO>> changeHistory(@RequestBody PrdSystemBusinessChangeQuery query){
//        return ApiResult.ok(service.changeSearch(query));
//    }


    /**
     * 查看对应新旧版本的变更
     * @param logId
     * @param compareLogId
     * @return
     */
    @GetMapping("/changeLogDetail/{logId}")
    public TwOutputUtil changeLogDetail(@PathVariable Long logId, Long compareLogId) {
        return TwOutputUtil.ok(service.getChangeLogDetail(logId,compareLogId));
    }



}
