package com.elitesland.tw.tw5.server.common.change.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.api.common.change.payload.PrdSystemBusinessChangePayload;
import com.elitesland.tw.tw5.api.common.change.query.PrdSystemBusinessChangeQuery;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeFlagEnum;
import com.elitesland.tw.tw5.server.common.change.dao.PrdSystemBusinessChangeDAO;
import com.elitesland.tw.tw5.server.common.change.entity.PrdSystemBusinessChangeDO;
import com.elitesland.tw.tw5.server.common.change.repo.PrdSystemBusinessChangeRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @author liwenpeng
 * @date 2021/9/27 15:17
 */
@Service("comBusinessChangeService")
@RequiredArgsConstructor
@Slf4j
public class PrdSystemBusinessChangeServiceImpl implements PrdSystemBusinessChangeService {

    private final PrdSystemBusinessChangeDAO dao;
    private final PrdSystemBusinessChangeRepo repo;

    @Override
    @Transactional(rollbackOn = Exception.class)
    public Long saveNewLog(String changeType, BaseViewModel versionContent,String parentChangeType,String parentChangeDocId,Integer activeFlag) {
        int initVersionNo=0;
        //当存在父表的情况下，初始version与父表保持一致
        if(parentChangeType!=null && parentChangeDocId!=null){
            Integer currentActiveVersion = getCurrentActiveVersion(parentChangeType, parentChangeDocId);
            if(currentActiveVersion!=null){
                initVersionNo=activeFlag==1?0:currentActiveVersion+1;
//                initVersionNo=currentActiveVersion+1;
            }
        }
        //对时间进行处理，将时间格式化成String

        //查询当前类型的原始log版本
//        PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
//        query.setChangeDocId(versionContent.getId()==null?"-1":versionContent.getId().toString());
//        query.setChangeType(changeType);
//        query.setVersionStatus(0);
//        query.setVersionNo(initVersionNo);
//        List<PrdSystemBusinessChangeVO> changeVOS = dao.queryListDynamic(query);
//        if(versionContent.getId()!=null && changeVOS!=null && !changeVOS.isEmpty()){
//            //动态更新内容字段(适合全量更新的场景)
//            PrdSystemBusinessChangePayload payload = new PrdSystemBusinessChangePayload();
//            payload.setVersionContent(JSONObject.toJSONString(versionContent));
//            payload.setId(changeVOS.get(0).getId());
//            dao.updateByKeyDynamic(payload);
//            return changeVOS.get(0).getId();
//        }else{
            PrdSystemBusinessChangeDO changeDO = new PrdSystemBusinessChangeDO()
                    .setChangeType(changeType)
                    .setChangeDocId(versionContent.getId()==null?"-1":versionContent.getId().toString())
                    .setVersionNo(initVersionNo)
                    .setVersionContent(JSONObject.toJSONString(versionContent, SerializerFeature.WriteMapNullValue,SerializerFeature.WriteDateUseDateFormat))
                    .setVersionStatus(activeFlag)
                    .setParentChangeType(parentChangeType)
                    .setParentChangeDocId(parentChangeDocId);
            changeDO.setCreateUserId(versionContent.getCreateUserId());
            PrdSystemBusinessChangeDO changeSave = dao.save(changeDO);
            if (changeSave == null) {
                return -1L;
            }
            return changeSave.getId();
//        }
    }

    @Override
    public void updateVersionContent(Long logId, BaseViewModel baseViewModel) {
        PrdSystemBusinessChangeDO changeDO = repo.findById(logId).orElse(null);
        if (changeDO!=null){
            changeDO.setChangeDocId(baseViewModel.getId().toString());
            changeDO.setVersionContent(JSONObject.toJSONString(baseViewModel, SerializerFeature.WriteMapNullValue,SerializerFeature.WriteDateUseDateFormat));
            repo.save(changeDO);
        }
    }

//    @Override
//    public Long updateNewLog(String changeType, TwCommonPayload changePayload) {
//        Integer currentVersion = getCurrentVersion(changeType, changePayload.getId().toString());
//        //查询当前类型的原始log版本
//        PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
//        query.setChangeDocId(changePayload.getId().toString());
//        query.setChangeType(changeType);
//        query.setVersionStatus(0);
//        query.setVersionNo(currentVersion);
//        List<PrdSystemBusinessChangeVO> changeVOS = dao.queryListDynamic(query);
//        if(changeVOS!=null && !changeVOS.isEmpty()){
//            String versionContent = changeVOS.get(0).getVersionContent();
//            Map<String,Object> versionContentMap = JSON.parseObject(versionContent);
//            Map<String,Object> changeValue = versionContentMap==null?new HashMap<>():JSON.parseObject(JSON.toJSONString(changePayload));
//            versionContentMap.putAll(changeValue);
//            //动态更新内容字段
//            PrdSystemBusinessChangePayload payload = new PrdSystemBusinessChangePayload();
//            payload.setVersionContent(JSONObject.toJSONString(versionContentMap));
//            payload.setId(changeVOS.get(0).getId());
//            dao.updateByKeyDynamic(payload);
//            return changeVOS.get(0).getId();
//        }else{
//            throw TwException.error("","变更日志更新失败,未找到变更记录！");
//        }
//    }

    @Override
    public Long saveVersionLog(String changeType, TwCommonPayload changePayload,String parentChangeType,String parentChangeDocId) {
        Integer newVersion=0;
        //当存在父表的情况下，当前version与父表保持一致
        if(parentChangeType!=null && parentChangeDocId!=null){
            Integer currentActiveVersion = getCurrentActiveVersion(parentChangeType, parentChangeDocId);
            if(currentActiveVersion!=null){
                newVersion=currentActiveVersion+1;
            }
        }else{
            //查询当前最高已激活log版本的版本号
            Integer currentVersion = repo.findCurrentActiveVersion(changeType, changePayload.getId().toString());
            newVersion = currentVersion+1;
            if(currentVersion == null){
                throw TwException.error("","未找到上一版本的变更日志，请联系管理员！");
            }
        }
        //查询当前版本的数据
        PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
        if(changePayload.getId()==null){
            query.setId(changePayload.getChangeLogId());
        }else{
            query.setChangeDocId(changePayload.getId().toString());
        }
        query.setChangeType(changeType);
        query.setVersionNo(newVersion);
        List<PrdSystemBusinessChangeVO> changeVOS = dao.queryListDynamic(query);
        if(changeVOS!=null && !changeVOS.isEmpty()){
            if(changePayload.getDeleteFlag()!=null && changePayload.getDeleteFlag()==1){
                PrdSystemBusinessChangePayload payload = new PrdSystemBusinessChangePayload();
                payload.setChangeContent(null);
                payload.setId(changeVOS.get(0).getId());
                dao.updateByKeyDynamic(payload);
            }else{
                //动态更新内容字段
                String changeContent = changeVOS.get(0).getChangeContent();
                Map<String,Object> changeContentMap = changeContent==null?new HashMap<>():JSON.parseObject(changeContent);
                Map<String,Object> changeValue = JSON.parseObject(JSON.toJSONString(changePayload,SerializerFeature.WriteMapNullValue,SerializerFeature.WriteDateUseDateFormat));
                changeContentMap.putAll(changeValue);
                PrdSystemBusinessChangePayload payload = new PrdSystemBusinessChangePayload();
                payload.setChangeContent(JSONObject.toJSONString(changeContentMap,SerializerFeature.WriteMapNullValue,SerializerFeature.WriteDateUseDateFormat));
                payload.setId(changeVOS.get(0).getId());
                dao.updateByKeyDynamic(payload);
            }
            return changeVOS.get(0).getId();
        }else{
            PrdSystemBusinessChangeDO changeDO = new PrdSystemBusinessChangeDO()
                    .setChangeType(changeType)
                    .setChangeDocId(changePayload.getId().toString())
                    .setVersionNo(newVersion)
                    .setChangeContent(JSONObject.toJSONString(changePayload,SerializerFeature.WriteMapNullValue,SerializerFeature.WriteDateUseDateFormat))
                    .setVersionStatus(0)
                    .setParentChangeType(parentChangeType)
                    .setParentChangeDocId(parentChangeDocId);
            PrdSystemBusinessChangeDO changeSave = dao.save(changeDO);
            if (changeSave == null) {
                return -1L;
            }
            return changeSave.getId();
        }
    }

//    @Override
//    public void updateByVersionCondition(String changeType, String changeDocId,TwCommonPayload changePayload, String parentChangeType, String parentChangeDocId) {
//        int initVersion =0;
//        if(parentChangeType!=null && parentChangeDocId!=null){
//            //查询当前这条数据的初始版本
//            initVersion = getInitVersion(changeType, changeDocId);
//        }
//        Integer currentVersion = getCurrentVersion(changeType, changeDocId);
//        if(currentVersion==null){
//            Integer currentActiveVersion = getCurrentActiveVersion(changeType, changeDocId);
//            if(currentActiveVersion==null){
//                //没查到任何版本数据
//                throw TwException.error("","未查询到任何版本数据！");
//            }
//            //保存新的version版本
//            saveVersionLog(changeType,changePayload,parentChangeType,parentChangeDocId);
//        }else if(currentVersion==initVersion){
//            if(changePayload.getDeleteFlag()==1){
//                //直接删除版本
//                deleteCurrentVersionLog(changeType,changeDocId);
//            }
//            //更新初始版本数据
//            updateNewLog(changeType,changePayload);
//        }else{
//            //更新新的version版本
//            saveVersionLog(changeType,changePayload,parentChangeType,parentChangeDocId);
//        }
//    }

    @Override
    @Transactional
    public void deleteCurrentVersionLog(String changeType, String docId) {
        //查询当前最高草稿状态log版本的版本号
        Long currentVersionId = repo.findCurrentVersionId(changeType, docId);
        PrdSystemBusinessChangePayload payload = new PrdSystemBusinessChangePayload();
        payload.setId(currentVersionId);
        payload.setDeleteFlag(1);
        dao.updateByKeyDynamic(payload);
        //关联删除子单据版本
        List<PrdSystemBusinessChangeVO> changeLogChildrenLogs = getChangeLogChildrenLogs(changeType, docId, payload.getVersionNo());
        if(changeLogChildrenLogs!=null && changeLogChildrenLogs.isEmpty()){
            for (PrdSystemBusinessChangeVO changeLogChildrenLog : changeLogChildrenLogs) {
                PrdSystemBusinessChangePayload childPayload = new PrdSystemBusinessChangePayload();
                childPayload.setId(changeLogChildrenLog.getId());
                childPayload.setDeleteFlag(1);
                dao.updateByKeyDynamic(childPayload);
            }
        }
    }

    @Override
    @Transactional
    public Map<String,Object> activeCurrentVersionLog(String changeType, String docId) {
        //查询当前最高待激活log版本的版本号
        Long currentVersionId = repo.findCurrentVersionId(changeType, docId);
        PrdSystemBusinessChangePayload payload = new PrdSystemBusinessChangePayload();
        payload.setVersionStatus(1);
        payload.setId(currentVersionId);
        //版本合并
        PrdSystemBusinessChangeVO mainTicketVo = mergeVersionByCurrentDocId(payload.getId());
        payload.setVersionContent(mainTicketVo.getVersionContent());
        dao.updateByKeyDynamic(payload);
        Integer currentVersion = repo.findCurrentVersion(changeType, docId);
        //关联更新子单据
        List<PrdSystemBusinessChangeVO> changeLogChildrenLogs = getChangeLogChildrenLogs(changeType, docId, currentVersion);
        if(changeLogChildrenLogs!=null && !changeLogChildrenLogs.isEmpty()){
            for (PrdSystemBusinessChangeVO changeLogChildrenLog : changeLogChildrenLogs) {
                PrdSystemBusinessChangePayload childPayload = new PrdSystemBusinessChangePayload();
                childPayload.setId(changeLogChildrenLog.getId());
                childPayload.setVersionStatus(1);
                //版本合并
                PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = mergeVersionByCurrentDocId(changeLogChildrenLog.getId());
                childPayload.setVersionContent(prdSystemBusinessChangeVO.getVersionContent());
                dao.updateByKeyDynamic(childPayload);
            }
        }
        //保存上一版本未更新的子单据到当前版本
        if(currentVersion >0){
            List<PrdSystemBusinessChangeVO> lastVersionChildrenLogs = getChangeLogChildrenLogs(changeType, docId, currentVersion-1);
            for (PrdSystemBusinessChangeVO lastVersionChildrenLog : lastVersionChildrenLogs) {
                if(!changeLogChildrenLogs.contains(lastVersionChildrenLog)){
//                    //如果上一个版本的这条明细是新增的，那么其id为-1，在真实保存数据后并未更新，我们在这里更新其id
//                    if(lastVersionChildrenLog.getVersionContent()==null){
//
//                    }
//                    saveNewLog(lastVersionChildrenLog.getChangeType(),)
                    PrdSystemBusinessChangeDO changeDO = new PrdSystemBusinessChangeDO()
                            .setChangeType(lastVersionChildrenLog.getChangeType())
                            .setChangeDocId(lastVersionChildrenLog.getChangeDocId())
                            .setVersionNo(currentVersion)
                            .setVersionContent(lastVersionChildrenLog.getVersionContent())
                            .setVersionStatus(1)
                            .setParentChangeType(changeType)
                            .setParentChangeDocId(docId);
                    dao.save(changeDO);
                }
            }
        }
        PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = dao.queryByKey(currentVersionId);
        String versionContent = prdSystemBusinessChangeVO.getVersionContent();
        Map<String,Object> result = JSON.parseObject(versionContent);
        Map<String, List<Map<String, Object>>> changeLogChildList = getChangeLogChildList(changeType, docId, mainTicketVo.getVersionNo());
        result.putAll(changeLogChildList);
        return result;
    }


    /**
     * 查询变更的子列表,并分组
     * @param parentChangeType
     * @param parentDocId
     * @param currentVersion
     * @return
     */
    @Override
    public List<PrdSystemBusinessChangeVO> getChangeLogChildrenLogs(String parentChangeType, String parentDocId, Integer currentVersion) {
        Map<String,List<Map<String,Object>>> result = new HashMap<>();
        PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
        query.setParentChangeType(parentChangeType);
        query.setParentChangeDocId(parentDocId);
        query.setVersionNo(currentVersion);
        return dao.queryListDynamic(query);
    }








    @Override
    public Integer getCurrentVersion(String changeType, String docId) {
        return repo.findCurrentVersion(changeType, docId);
    }

    @Override
    public Long getCurrentVersionId(String changeType, String docId) {
        return repo.findCurrentVersionId(changeType, docId);
    }

    @Override
    public Integer getCurrentActiveVersion(String changeType, String docId) {
        return repo.findCurrentActiveVersion(changeType, docId);
    }

    /**
     * 针对子表数据查询其初始版本版本号
     * @param changeType
     * @param docId
     * @return
     */
    @Override
    public Integer getInitVersion(String changeType, String docId) {
        return repo.findInitVersion(changeType, docId);
    }



    @Override
    public List<PrdSystemBusinessChangeVO> getChangeLogList(String changeType, String docId) {
        PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
        query.setChangeDocId(docId);
        query.setChangeType(changeType);
        return dao.queryListDynamic(query);
    }






    @Override
    public Map<String,Object> getChangeLogDetail(Long id,Long compareLogId) {
        PrdSystemBusinessChangeVO changeLogDetail = dao.queryByKey(id);
        //如果待比较版本不存在,待比较版本的id就默认为当前版本的上一个版本
        if(compareLogId==null ){
            //并且当前版本为激活状态时,比较版本为上一个版本
            if(changeLogDetail.getVersionStatus()==0){
                PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
                query.setChangeDocId(changeLogDetail.getChangeDocId());
                query.setChangeType(changeLogDetail.getChangeType());
                query.setVersionNo(changeLogDetail.getVersionNo()-1);
                List<PrdSystemBusinessChangeVO> changeVOS = dao.queryListDynamic(query);
                if(changeVOS!=null && !changeVOS.isEmpty()){
                    compareLogId=changeVOS.get(0).getId();
                }else{
                    compareLogId =-1L;
                }
            }else{
                //当前版本为激活状态，并且没有传对比版本，直接返回本版本结果
                Map<String,Object> versionValue = JSON.parseObject(changeLogDetail.getVersionContent());
                //查询子列表
                Map<String, List<Map<String, Object>>> changeLogChildList = getChangeLogChildList(changeLogDetail.getChangeType(), changeLogDetail.getChangeDocId(), changeLogDetail.getVersionNo());
                versionValue.putAll(changeLogChildList);
                return versionValue;
            }
        }
        PrdSystemBusinessChangeVO compareLogDetail = dao.queryByKey(compareLogId);
//        Long docId = changeLogDetail.getId();
        Integer versionNo = changeLogDetail.getVersionNo();
        if(versionNo<1){
            Map<String,Object> versionValue = JSON.parseObject(changeLogDetail.getVersionContent());
            //查询子列表
            Map<String, List<Map<String, Object>>> changeLogChildList = getChangeLogChildList(changeLogDetail.getChangeType(), changeLogDetail.getChangeDocId(), changeLogDetail.getVersionNo());
            versionValue.putAll(changeLogChildList);
            return versionValue;
        }else{
            //草稿状态的变更要借助上一个版本
            if(changeLogDetail.getVersionStatus()==0){
                if(compareLogDetail.getVersionNo()<versionNo-1){
                    //和历史版本比较
                    PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
                    query.setChangeDocId(changeLogDetail.getChangeDocId());
                    query.setChangeType(changeLogDetail.getChangeType());
                    query.setVersionNo(versionNo-1);
                    List<PrdSystemBusinessChangeVO> prdSystemBusinessChangeVOS = dao.queryListDynamic(query);
                    if(prdSystemBusinessChangeVOS==null || prdSystemBusinessChangeVOS.isEmpty()){
                        //主表不可能没有上一版本的数据
                        throw TwException.error("","未查询到历史版本的数据");
                    }else{
                        Map<String,Object> compareVersionContent = JSON.parseObject(compareLogDetail.getVersionContent());
                        String versionContent = prdSystemBusinessChangeVOS.get(0).getVersionContent();
                        Map<String,Object> baseVersionContent = JSON.parseObject(versionContent);
                        Map<String,Object> currentChangeContent = JSON.parseObject(changeLogDetail.getChangeContent());
                        baseVersionContent.putAll(currentChangeContent);
                        Map<String, Object> versionValue = simpleCompare(compareVersionContent, baseVersionContent);
                        Map<String,List<Map<String,Object>>> childVersionValue = listCompare(changeLogDetail.getParentChangeType(), changeLogDetail.getParentChangeDocId(), changeLogDetail.getVersionNo(),compareLogDetail.getVersionNo());
                        versionValue.putAll(childVersionValue);
                        return versionValue;
                    }
                }else{
                    //和上一个版本比较
                    String versionContent = compareLogDetail.getVersionContent();
                    Map<String,Object> lastVersionContent = JSON.parseObject(versionContent);
                    Map<String,Object> currentChangeContent = JSON.parseObject(changeLogDetail.getChangeContent());
                    Map<String, Object> versionValue = simpleCompare(lastVersionContent, currentChangeContent);
                    Map<String,List<Map<String,Object>>> childVersionValue = listCompare(changeLogDetail.getChangeType(), changeLogDetail.getChangeDocId(), changeLogDetail.getVersionNo(),compareLogDetail.getVersionNo());
                    versionValue.putAll(childVersionValue);
                    return versionValue;
                }
            }else{
                //两个版本的changeVersion直接比较
                Map<String,Object> compareVersionContent = JSON.parseObject(compareLogDetail.getVersionContent());
                Map<String,Object> currentVersionContent = JSON.parseObject(changeLogDetail.getVersionContent());
                Map<String, Object> versionValue = simpleCompare(compareVersionContent, currentVersionContent);
                Map<String,List<Map<String,Object>>> childVersionValue = listCompare(changeLogDetail.getChangeType(), changeLogDetail.getChangeDocId(), changeLogDetail.getVersionNo(),compareLogDetail.getVersionNo());
                versionValue.putAll(childVersionValue);
                return versionValue;
            }
        }
    }


    private Map<String,Object> simpleCompare(Map<String,Object> oldMap,Map<String,Object> newMap){
        Map<String,Object> comparedMap = new HashMap<>();
        comparedMap.putAll(oldMap);
        for (String lastKey : oldMap.keySet()) {
            for (String currentKey : newMap.keySet()) {
                if(lastKey.equals(currentKey) && oldMap.get(lastKey)==null){
                    if(newMap.get(currentKey)!=null){
                        comparedMap.put(lastKey+"_$$_new",newMap.get(currentKey));
                    }
                }else if(lastKey.equals(currentKey) && newMap.get(currentKey)==null){
                    if(oldMap.get(lastKey)!=null){
                        comparedMap.put(lastKey+"_$$_new",null);
                    }
                }else if(lastKey.equals(currentKey) && !checkEquals(oldMap.get(lastKey).toString(),newMap.get(currentKey).toString())){
                    Object o = newMap.get(currentKey);
                    comparedMap.put(lastKey+"_$$_new",newMap.get(currentKey));
                }
            }
        }
        return comparedMap;
    }


    private boolean checkEquals(String value1,String value2){
        if(isNumeric(value1) && isNumeric(value2)){
            value1=new BigDecimal(value1).stripTrailingZeros().toPlainString();
            value2=new BigDecimal(value2).stripTrailingZeros().toPlainString();
        }
        return value1.equals(value2);
    }

    public static boolean isNumeric(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        String regx = "[+-]*\\d+\\.?\\d*[Ee]*[+-]*\\d+";
        Pattern pattern = Pattern.compile(regx);
        boolean isNumber = pattern.matcher(str).matches();
        if (isNumber) {
            return isNumber;
        }
        regx = "^[-\\+]?[.\\d]*$";
        pattern = Pattern.compile(regx);
        return pattern.matcher(str).matches();
    }









    private Map<String,List<Map<String,Object>>> listCompare(String parentChangeType,String parentDocId,Integer currentVersion,Integer compareVersion){
         Map<String, List<Map<String, Object>>> comparedResult = new HashMap<>();
        //查询子列表
        Map<String, List<Map<String, Object>>> currentVersionChilden = getChangeLogChildList(parentChangeType, parentDocId, currentVersion);
        Map<String, List<Map<String, Object>>> compareVersionChilden = getChangeLogChildList(parentChangeType, parentDocId, compareVersion);
        if(currentVersionChilden!=null && !currentVersionChilden.isEmpty()){
            for (String currentVersionKey : currentVersionChilden.keySet()) {
                if(compareVersionChilden!=null && !compareVersionChilden.isEmpty()){
                    boolean compareFlag = false;
                    for (String compareVersionKey : compareVersionChilden.keySet()) {
                        if(currentVersionKey.equals(compareVersionKey)){
                            compareFlag = true;
                            //进一步比较list
                            List<Map<String, Object>> currentList = currentVersionChilden.get(currentVersionKey);
                            List<Map<String, Object>> compareList = compareVersionChilden.get(currentVersionKey);
                            if(currentList!=null && !currentList.isEmpty()){
                                if(compareList!=null && !compareList.isEmpty()){
                                    for (Map<String, Object> currentData : currentList) {
                                        if(currentData.get("deleteFlag")!=null && currentData.get("deleteFlag").equals(1)){
                                            currentData.put("changeFlag",ChangeFlagEnum.DELETE);
                                        }else{
                                            boolean compared = false;
                                            for (Map<String, Object> compareData : compareList) {
                                                if(currentData.get("id")!=null && currentData.get("id").equals(compareData.get("id"))){
                                                    compared = true;
                                                    Map<String, Object> stringObjectMap = simpleCompare(compareData, currentData);
                                                    currentData.putAll(stringObjectMap);
                                                }
                                            }
                                            if(!compared){
                                                //currentData再compareList中不存在
                                                currentData.put("changeFlag",ChangeFlagEnum.ADD);
                                            }
                                        }
                                    }

                                    for (Map<String, Object> compareData : compareList) {
                                        boolean isExist = false;
                                        for (Map<String, Object> currentData : currentList) {
                                            if(currentData.get("id")!=null && currentData.get("id").equals(compareData.get("id"))){
                                                isExist = true;
                                            }
                                        }
                                        if(!isExist){
                                            //compareData再currentList中不存在
//                                            compareData.put("changeFlag",ChangeFlagEnum.DELETE);
                                            currentList.add(compareData);
                                        }
                                    }


                                }else{
                                    for (Map<String, Object> map : currentList) {
                                        map.put("changFlag",ChangeFlagEnum.DELETE);
                                    }
                                }
                            }else{
                                if(compareList!=null && !compareList.isEmpty()){
                                    for (Map<String, Object> map : compareList) {
                                        map.put("changFlag",ChangeFlagEnum.DELETE);
                                        currentList.add(map);
                                    }
                                }
                            }
                            //将最新值赋值回去
                            currentVersionChilden.put(currentVersionKey,currentList);
                            break;
                        }
                    }
                    if(!compareFlag){
                        //TODO:列表不匹配的情况
                    }
                }else{
                    List<Map<String, Object>> maps = currentVersionChilden.get(currentVersionKey);
                    if(maps!=null && !maps.isEmpty()){
                        for (Map<String, Object> map : maps) {
                            map.put("changFlag",ChangeFlagEnum.ADD);
                        }
                    }
                }
            }
            comparedResult = currentVersionChilden;
        }else{
            if(compareVersionChilden!=null && !compareVersionChilden.isEmpty()){
                for (String compareVersionKey : compareVersionChilden.keySet()) {
                    List<Map<String, Object>> maps = compareVersionChilden.get(compareVersionKey);
                    if(maps!=null && !maps.isEmpty()){
                        for (Map<String, Object> map : maps) {
                            map.put("changFlag",ChangeFlagEnum.DELETE);
                        }
                    }
                }
            }
            comparedResult = compareVersionChilden;
        }


        return comparedResult;
    }


    /**
     * 查询变更的子列表,并分组
     * @param parentChangeType
     * @param parentDocId
     * @param currentVersion
     * @return
     */
    private Map<String,List<Map<String,Object>>> getChangeLogChildList(String parentChangeType,String parentDocId,Integer currentVersion) {
        Map<String,List<Map<String,Object>>> result = new HashMap<>();
        PrdSystemBusinessChangeQuery query = new PrdSystemBusinessChangeQuery();
        query.setParentChangeType(parentChangeType);
        query.setParentChangeDocId(parentDocId);
        query.setVersionNo(currentVersion);
        List<PrdSystemBusinessChangeVO> prdSystemBusinessChangeVOS = dao.queryListDynamic(query);
        //对list按changeType分组
        Map<String, List<PrdSystemBusinessChangeVO>> collect = prdSystemBusinessChangeVOS.stream().collect(Collectors.groupingBy(PrdSystemBusinessChangeVO::getChangeType));
        for (String changeType : collect.keySet()) {
            List<Map<String,Object>> childContent = new ArrayList<>();
            List<PrdSystemBusinessChangeVO> changeVOS = collect.get(changeType);
            for (PrdSystemBusinessChangeVO prdSystemBusinessChangeVO : changeVOS) {
                if(prdSystemBusinessChangeVO.getVersionNo()>0){
                    //当子表从未保存，其id默认为-1时，不用与上一个版本对比
                    if(prdSystemBusinessChangeVO.getChangeDocId().equals("-1")){
                        Map<String,Object> addData= JSON.parseObject(prdSystemBusinessChangeVO.getVersionContent());
                        addData.put("changeLogId",prdSystemBusinessChangeVO.getId());
                        childContent.add(addData);
                    }else{
                        //获取上一个版本的数据并合并
                        PrdSystemBusinessChangeQuery lastQuery = new PrdSystemBusinessChangeQuery();
                        lastQuery.setChangeDocId(prdSystemBusinessChangeVO.getChangeDocId());
                        lastQuery.setChangeType(prdSystemBusinessChangeVO.getChangeType());
                        lastQuery.setVersionNo(prdSystemBusinessChangeVO.getVersionNo()-1);
                        List<PrdSystemBusinessChangeVO> lastVersion = dao.queryListDynamic(lastQuery);
                        Map<String,Object> baseVersionContent = new HashMap<>();
                        if(lastVersion!=null && !lastVersion.isEmpty()){
                            String versionContent = lastVersion.get(0).getVersionContent();
                            baseVersionContent = JSON.parseObject(versionContent);
                        }
                        Map<String,Object> currentChangeContent = JSON.parseObject(prdSystemBusinessChangeVO.getChangeContent());
                        if(currentChangeContent!=null){
                            currentChangeContent.put("changeLogId",prdSystemBusinessChangeVO.getId());
                            baseVersionContent.putAll(currentChangeContent);
                        }else{
                            Map<String,Object> currentVersionContent = JSON.parseObject(prdSystemBusinessChangeVO.getVersionContent());
                            if(currentVersionContent!=null){
                                currentVersionContent.put("changeLogId",prdSystemBusinessChangeVO.getId());
                                baseVersionContent.putAll(currentVersionContent);
                            }
                        }
                        childContent.add(JSON.parseObject(JSON.toJSONString(baseVersionContent,SerializerFeature.WriteMapNullValue,SerializerFeature.WriteDateUseDateFormat)));
                    }
                }else{
                    childContent.add(JSON.parseObject(prdSystemBusinessChangeVO.getVersionContent()));
                }
            }
            result.put(changeType,childContent);
        }
        return result;
    }



    @Override
    public void deleteById(Long docId) {
        PrdSystemBusinessChangeDO changeDO = repo.findById(docId).get();
        changeDO.setDeleteFlag(1);
        repo.save(changeDO);
    }

    /**
     * 获取当前版本的实际情况
     * @param changeLogId
     * @return
     */
    @Override
    public PrdSystemBusinessChangeVO mergeVersionByCurrentDocId(Long changeLogId) {
        PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = dao.queryByKey(changeLogId);
        if(prdSystemBusinessChangeVO.getVersionStatus()==1){
            return prdSystemBusinessChangeVO;
        }else{
            if(prdSystemBusinessChangeVO.getVersionContent()==null){
                //获取上一个版本的数据并合并
                PrdSystemBusinessChangeQuery lastQuery = new PrdSystemBusinessChangeQuery();
                lastQuery.setChangeDocId(prdSystemBusinessChangeVO.getChangeDocId());
                lastQuery.setChangeType(prdSystemBusinessChangeVO.getChangeType());
                lastQuery.setVersionNo(prdSystemBusinessChangeVO.getVersionNo()-1);
                List<PrdSystemBusinessChangeVO> lastVersion = dao.queryListDynamic(lastQuery);
                PrdSystemBusinessChangeVO baseVersion = lastVersion.get(0);
                String versionContent = baseVersion.getVersionContent();
                Map<String,Object> baseVersionContent = JSON.parseObject(versionContent);
                Map<String,Object> currentChangeContent = JSON.parseObject(prdSystemBusinessChangeVO.getChangeContent());
                currentChangeContent.put("changeLogId",prdSystemBusinessChangeVO.getId());
                baseVersionContent.putAll(currentChangeContent);
                prdSystemBusinessChangeVO.setVersionContent(JSON.toJSONString(baseVersionContent,SerializerFeature.WriteMapNullValue,SerializerFeature.WriteDateUseDateFormat));
            }
            return prdSystemBusinessChangeVO;
        }
    }


//    /**
//     * 通用变更数据保存（vo为原始数据，v1为新数据）
//     * @param changeType 变更类型
//     * @param originalModel 原始数据
//     * @param changeModel  变更好数据
//     * @return
//     */
//    @Override
//    @Transactional(rollbackOn = Exception.class)
//    public Long save(String changeType, TwCommonPayload originalModel, TwCommonPayload changeModel) {
//
//        if(originalModel==null){
////            //原始数据null-->新数据
////            //新增时如果从无到有，那么时不可能有单据id的，将关联父单据的id设置为docId
////            String versionNo = "v0";
////            PrdSystemBusinessChangeDO originalDO = new PrdSystemBusinessChangeDO()
////                    .setChangeType(changeType)
////                    .setVersionNo(versionNo)
////                    .setChangeContent(null)
////                    .setChangeDocId(changeModel.getId().toString());
////            PrdSystemBusinessChangeDO save = repo.save(originalDO);
//
//            String changeVersionNo = "v1";
//            String changeContent = JSONObject.toJSONString(changeModel);
//            log.info("changeContent = {}", changeContent);
//
//            PrdSystemBusinessChangeDO changeDO = new PrdSystemBusinessChangeDO()
//                    .setChangeType(changeType)
//                    .setVersionNo(changeVersionNo)
//                    .setChangeContent(changeContent)
//                    .setChangeDocId(changeModel.getId().toString());
//            PrdSystemBusinessChangeDO changeSave = repo.save(changeDO);
//            if (changeSave == null) {
//                return -1L;
//            }
//            return changeSave.getId();
//        }else {
//            Long docId = originalModel.getId();
//            String originalContent = JSONObject.toJSONString(originalModel);
//            log.info("originalContent = {}", originalContent);
//            //查询原表数据并保存
//            PrdSystemBusinessChangeDO v0 = repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, changeType, docId.toString(), "v0");
//            if (v0 == null) {
//                String versionNo = "v0";
//                PrdSystemBusinessChangeDO originalDO = new PrdSystemBusinessChangeDO()
//                        .setChangeType(changeType)
//                        .setVersionNo(versionNo)
//                        .setChangeContent(originalContent)
//                        .setChangeDocId(docId.toString());
//                PrdSystemBusinessChangeDO save = repo.save(originalDO);
//                if (save == null) {
//                    return -1L;
//                }
//            }
//
//            //保存变更数据
//            Long count = repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0, changeType, docId.toString());
//            String changeVersionNo = "v" + count;
//            String changeContent = null;
//            if(changeModel!=null){
//                changeContent = JSONObject.toJSONString(changeModel);
//            }
//            log.info("changeContent = {}", changeContent);
//            PrdSystemBusinessChangeDO changeDO = new PrdSystemBusinessChangeDO()
//                    .setChangeType(changeType)
//                    .setVersionNo(changeVersionNo)
//                    .setChangeContent(changeContent)
//                    .setChangeDocId(docId.toString());
//            PrdSystemBusinessChangeDO changeSave = repo.save(changeDO);
//            if (changeSave == null) {
//                return -1L;
//            }
//            return changeSave.getId();
//        }
//    }

//    /**
//     * 通用变更数据更新（更新v1的content值）
//     * @param changeType 变更类型
//     * @param changeModel 变更数据
//     */
//    @Override
//    @Transactional(rollbackOn = Exception.class)
//    public Long update(String changeType,TwCommonPayload changeModel){
//        Long docId = changeModel.getId();
//        Long count = repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0,changeType,docId.toString());
//        String changeVersionNo = "v" + (count-1);
//        PrdSystemBusinessChangeDO changeDO = repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, changeType, docId.toString(), changeVersionNo);
//
//        String changeContent = JSONObject.toJSONString(changeModel);
//        log.info("changeContent = {}",changeContent);
//
//        changeDO.setChangeContent(changeContent);
//        PrdSystemBusinessChangeDO save = repo.save(changeDO);
//        if (save == null){
//            return -1L;
//        }
//        return 1L;
//    }

//    /**
//     * 通用变更数据删除
//     * @param changeType 变更类型
//     * @param changeModel 变更数据
//     */
//    @Override
//    @Transactional(rollbackOn = Exception.class)
//    public Long deleteFromList(String changeType,TwCommonPayload changeModel){
//        Long docId = changeModel.getId();
//        Long count = repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0,changeType,docId.toString());
//        if(count<1){
//            Long save = save(changeType, changeModel, new TwCommonPayload());
//            if (save == null){
//                return -1L;
//            }
//        }
//        return 1L;
//    }

//    @Override
//    public Long updateBusinessChange(PrdSystemBusinessChangePayload payload) {
//        Long id = payload.getId();
//        Optional<PrdSystemBusinessChangeDO> optional = repo.findById(id);
//        if (optional.isPresent()){
//            PrdSystemBusinessChangeDO changeDO = optional.get();
////            if (!StringUtils.hasText(payload.getProcInstId())){
////                changeDO.setProcInstId(payload.getProcInstId());
////            }
////            if (!StringUtils.hasText(payload.getProcInstStatus())){
////                changeDO.setProcInstStatus(payload.getProcInstStatus());
////            }
////            if (!StringUtils.hasText(payload.getChangeStatus())){
////                changeDO.setChangeStatus(payload.getChangeStatus());
////            }
//            PrdSystemBusinessChangeDO save = repo.save(changeDO);
//            return save.getId();
//        }
//        return -1L;
//    }

//    @Override
//    public <T extends TwCommonPayload> Map<String, Object> compareDetail(Long id, Class<T> cla, T t) {
//        Map<String,Object> result = new HashMap<>();
//        //查询变更数据
//        PrdSystemBusinessChangeDO changeDO = repo.findById(id).get();
//
//        String jsonString = changeDO.getChangeContent();
////        String changeStatus = changeDO.getChangeStatus();
//
////        String changeStatusDesc = "CHANGEING".equalsIgnoreCase(changeStatus)?"变更中":"已完成";
//        T afterDo = null;
//        if(jsonString==null){
//            result = BeanUtil.beanToMap(t);
//            //即新值为空的情况
//            result.put("changeFlag","del");
//        }else{
//            afterDo = JSON.parseObject(jsonString, cla);
//            log.info("JSON转javaBean  afterDo = {}",afterDo);
//            result = compare(t, afterDo);
//        }
////        result.put("changeStatus",changeStatus);
////        result.put("changeStatusDesc",changeStatusDesc);
////
////        result.put("procInstId",changeDO.getProcInstId());
////        result.put("procInstStatus",changeDO.getProcInstStatus());
//
//        return result;
//    }
//
//    private ArrayList<Field> getAllField(Object beforeDo){
//        ArrayList<Field> beforeFields = new ArrayList<>() ;
//        if(beforeDo == null){
//            return beforeFields;
//        }
//        Class beforeClass = beforeDo.getClass();
//        while (beforeClass !=null && !beforeClass.getName().toLowerCase().equals("java.lang.object")){
//            Field[] declaredFields = beforeClass.getDeclaredFields();
//            Field.setAccessible(declaredFields,true);
//            beforeFields.addAll(Arrays.asList(declaredFields));
//            beforeClass = beforeClass.getSuperclass();
//        }
//        return beforeFields;
//    }
//
//    private Map<String,Object> compare(Object beforeDo,Object afterDo){
//        Map<String,Object> result = new HashMap<>();
//        try {
//            ArrayList<Field> beforeFields = getAllField(beforeDo);
//            ArrayList<Field>  afterFields= getAllField(afterDo);
//
//
////            Field[] beforeFields = beforeDo.getClass().getDeclaredFields();
////            Field[] afterFields = afterDo.getClass().getDeclaredFields();
////            Field.setAccessible(beforeFields,true);
////            Field.setAccessible(afterFields,true);
//
//            for (int i=0;i<beforeFields.size();i++){
//                if ("serialVersionUID".equals(beforeFields.get(i).getName())){
//                    continue;
//                }
//                log.info("字段名称 = {},字段类型 = {}",beforeFields.get(i).getName(),beforeFields.get(i).getGenericType() );
//
//                if(beforeFields.get(i).get(beforeDo) == null && afterFields.get(i).get(afterDo) ==null){
//                    result.put(beforeFields.get(i).getName(),null);
//                    continue;
//                }
//
//
//                Type genericType = beforeFields.get(i).getGenericType();
//
//                //BigDecimal 类型
//                if(genericType.getTypeName().contains("java.math.BigDecimal")){
//                    BigDecimal beforeValue = (BigDecimal)beforeFields.get(i).get(beforeDo);
//                    BigDecimal afterValue = (BigDecimal)afterFields.get(i).get(afterDo);
//
//                    if (beforeValue == null ){
//                        beforeValue = BigDecimal.ZERO;
//                    }
//
//                    if (afterValue == null ){
//                        afterValue = BigDecimal.ZERO;
//                    }
//
//                    if (beforeValue.compareTo(afterValue) == 0){
//                        result.put(beforeFields.get(i).getName(),beforeValue);
//                    }else {
//                        result.put(beforeFields.get(i).getName() + "_$$_before",beforeValue);
//                        result.put(beforeFields.get(i).getName(),afterValue);
//                    }
//                    continue;
//                }
//
//
//
//                //java.util.List 类型
//                if(genericType.getTypeName().contains("java.util.List")){
//                    //自定义类型
//                    if (genericType.getTypeName().contains("com.elitesland.tw.tw5")){
//
//                        isChildExtendsBaseModel((ArrayList)beforeFields.get(i).get(beforeDo));
//                        isChildExtendsBaseModel((ArrayList)afterFields.get(i).get(afterDo));
//
//                        ArrayList<BaseModel> beforeValue = (ArrayList)beforeFields.get(i).get(beforeDo);
//                        ArrayList<BaseModel> afterValue = (ArrayList)afterFields.get(i).get(afterDo);
//                        if(beforeValue == null){
//                            beforeValue = new ArrayList();
//                        }
//                        if(afterValue == null){
//                            afterValue = new ArrayList();
//                        }
//
//                        if ((beforeValue == null || beforeValue.size() == 0) && (afterValue==null || afterValue.size() == 0)){
//                            result.put(beforeFields.get(i).getName(),beforeValue);
//                        }else{
//                            List<Long> originalIds = beforeValue.stream().map(e -> e.getId()).collect(Collectors.toList());
//                            List<Long> changeIds = afterValue.stream().map(e -> e.getId()).collect(Collectors.toList());
//
//
//                            //定义容器 接受最终对比后的结果
//                            ArrayList<Map<String,Object>> changeValue = new ArrayList<>();
//                            //新增数据添加
//                            if(afterValue.size() > beforeValue.size()){
//                                for(BaseModel afterModel:afterValue){
//                                    //只处理新增数据
//                                     if (!originalIds.contains(afterModel.getId())){
//                                        Map<String,Object> jsonObject = JSON.parseObject(JSON.toJSONString(afterModel));
//                                        jsonObject.put("changeType","ADD");
//                                        changeValue.add(jsonObject);
//
//                                    }
//                                }
//                                result.put(beforeFields.get(i).getName(),changeValue);
//
//                            }
//                            //修改数据对比
//                            for (int j=0 ; j<beforeValue.size() ; j++) {
//                                BaseModel baseModel = beforeValue.get(j);
////                                BaseModel afterModel = afterValue.get(j);
//                                BaseModel afterModel;
//                                List<BaseModel> afterList = afterValue.stream()
//                                        .filter(e->e.getId()!=null)
//                                        .filter(e -> e.getId().equals(baseModel.getId()))
//                                        .collect(Collectors.toList());
//                                if (afterList.size()>0){
//                                    afterModel = afterList.get(0);
//                                }else {
//                                    afterModel = null;
//                                }
//                                Long id = baseModel.getId();
//                                // 判断该数据是否被删除
//                                if (!changeIds.contains(id)){
//                                    Map<String,Object> jsonObject = JSON.parseObject(JSON.toJSONString(baseModel));
//                                    jsonObject.put("changeType","DELETE");
//                                    changeValue.add(jsonObject);
//
//                                }else{
//                                    Map<String, Object> compare = compare(baseModel, afterModel);
//                                    changeValue.add(compare);
//                                }
//                            }
//                            result.put(beforeFields.get(i).getName(),changeValue);
//                        }
//                    }else{  //基础数据类型
//                        ArrayList beforeValue = (ArrayList)beforeFields.get(i).get(beforeDo);
//                        ArrayList afterValue = (ArrayList)afterFields.get(i).get(afterDo);
//                        if(beforeValue == null){
//                            beforeValue = new ArrayList();
//                        }
//                        if(afterValue == null){
//                            afterValue = new ArrayList();
//                        }
//
//                        if ((beforeValue == null || beforeValue.size() == 0) && (afterValue==null || afterValue.size() == 0)){
//                            result.put(beforeFields.get(i).getName(),beforeValue);
//                        }else if (beforeValue.size() == afterValue.size() && beforeValue.containsAll(afterValue)){
//                            result.put(beforeFields.get(i).getName(),beforeValue);
//                        }else {
//                            result.put(beforeFields.get(i).getName() + "_$$_before",beforeValue);
//                            result.put(beforeFields.get(i).getName(),afterValue);
//                        }
//                    }
//                    continue;
//                }
//
//                //自定义类型
//                if (genericType.getTypeName().contains("com.elitesland.tw.tw5")){
//
//                    isExtendsBaseModel(beforeFields.get(i).get(beforeDo));
//                    isExtendsBaseModel(beforeFields.get(i).get(afterDo));
//
//                    BaseModel beforeValue = (BaseModel)beforeFields.get(i).get(beforeDo);
//                    BaseModel afterValue = (BaseModel)afterFields.get(i).get(afterDo);
//
//
//                    Map<String, Object> compare = compare(beforeValue, afterValue);
//                    result.put(beforeFields.get(i).getName(),compare);
//                    continue;
//                }
//
//                Object beforeValue = beforeFields.get(i).get(beforeDo);
//                Object afterValue = afterFields.get(i).get(afterDo);
//
//                //流程相关字段不做处理  apprProcInstId
//                if("procInstId".equals(beforeFields.get(i).getName())  || "procInstStatus".equals(beforeFields.get(i).getName())){
//                    result.put(beforeFields.get(i).getName(),beforeValue);
//                    continue;
//                }
//                //Long 类型 防止失真
//                if(genericType.getTypeName().contains("java.lang.Long")){
//                    beforeValue = String.valueOf(beforeValue);
//                    afterValue = String.valueOf(afterValue);
//                }
//
//                if((beforeValue != null && !"".equals(beforeValue) && !beforeValue.equals(afterValue))
//                        || ((beforeValue == null || "".equals(beforeValue)) && afterValue != null)){
//                    result.put(beforeFields.get(i).getName() + "_$$_before",beforeValue);
//                    result.put(beforeFields.get(i).getName(),afterValue);
//                }else{
//                    result.put(beforeFields.get(i).getName(),beforeValue);
//                }
//
//
//
//            }
//            return result;
//        }catch (Exception e){
//            log.error(" exception is ={}",e.getMessage());
//            return null;
//        }
//
//    }
//
//    private void isChildExtendsBaseModel(ArrayList arr){
//        if (arr == null){
//            return;
//        }
//        for (Object o : arr){
//            isExtendsBaseModel(o);
//        }
//    }
//
//
//    private boolean isExtendsBaseModel(Object o){
//        if (o == null){
//            return false;
//        }
//        Class beforeClass = o.getClass();
//        while (beforeClass !=null && !beforeClass.getName().toLowerCase().equals("java.lang.object")){
//            beforeClass = beforeClass.getSuperclass();
//            if(beforeClass.getName().contains("BaseModel")){
//                return true;
//            }
//        }
//        throw  new RuntimeException(o.getClass().getName() + " 没有继承BaseModel");
//    }
//
//    @Override
//    public String reverseSave(String changeType,Long docId){
//        Long count = repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0,changeType,docId.toString());
//        String changeVersionNo = "v" + (count-1);
//        PrdSystemBusinessChangeDO changeDO = repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, changeType, docId.toString(), changeVersionNo);
//        String jsonString = changeDO.getChangeContent();
//
//        return jsonString;
//    }
//
//    @Override
//    @Transactional(rollbackOn = Exception.class)
//    public Long delete(String changeType,Long docId){
//        Long count = repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0,changeType,docId.toString());
//        String changeVersionNo = "v" + (count-1);
//        PrdSystemBusinessChangeDO changeDO = repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, changeType, docId.toString(), changeVersionNo);
//        if (changeDO == null){
//            return -1L;
//        }
//        changeDO.setDeleteFlag(1);
//        PrdSystemBusinessChangeDO save = repo.save(changeDO);
//        if (save == null){
//            return -1L;
//        }
//
//        return 1L;
//    }
//
//    @Override
//    public void deleteById(Long docId) {
//        PrdSystemBusinessChangeDO changeDO = repo.findById(docId).get();
//        changeDO.setDeleteFlag(1);
//        repo.save(changeDO);
//    }
//
//    @Override
//    public PrdSystemBusinessChangeVO findChangeDoByChangeTypeAndDocId(String changeType, Long docId){
//        Long count = repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0,changeType,docId.toString());
//        String changeVersionNo = "v" + (count-1);
//        PrdSystemBusinessChangeDO changeDO = repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0,changeType, docId.toString(), changeVersionNo);
//        PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = PrdSystemBusinessChangeConvert.INSTANCE.toVo(changeDO);
//        return prdSystemBusinessChangeVO;
//    }
//
//
//    @Override
//    public List<PrdSystemBusinessChangeVO> findChangeDosByChangeTypeAndSuperDocId(String changeType, Long docId){
//        List<PrdSystemBusinessChangeDO> listDo = repo.findByDeleteFlagAndChangeTypeAndAndChangeDocId(0, changeType, docId.toString());
//        return listDo.stream().map(e-> PrdSystemBusinessChangeConvert.INSTANCE.toVo(e)).collect(Collectors.toList());
//    }
//
//
//    @Override
//    public PagingVO<PrdSystemBusinessChangeVO> changeSearch(PrdSystemBusinessChangeQuery query) {
//        return null;
//    }
//
////    @Override
////    @SysCodeProc
////    public PagingVO<PrdSystemBusinessChangeVO> changeSearch(PrdSystemBusinessChangeQuery query) {
////        QComBusinessChangeDO comBusinessChangeDO = QComBusinessChangeDO.comBusinessChangeDO;
////        JPAQuery<PrdSystemBusinessChangeDO> select = jpaQueryFactory.select(comBusinessChangeDO).from(comBusinessChangeDO)
////                .where(comBusinessChangeDO.deleteFlag.eq(0));
////        if (query.getChangeType() != null){
////            select.where(comBusinessChangeDO.changeType.eq(query.getChangeType()));
////        }
////        if (query.getChangeDocId() != null){
////            select.where(comBusinessChangeDO.changeDocId.eq(query.getChangeDocId()));
////        }
////        select.where(comBusinessChangeDO.versionNo.notIn("v0"));
//
////        分页查询
////        Long count = select.fetchCount();
////        List<PrdSystemBusinessChangeDO> domainList = select.offset(query.getPageRequest().getOffset())
////                .limit(query.getPageRequest().getPageSize()).fetch();
////        if(!CollectionUtils.isEmpty(domainList)){
////            List<PrdSystemBusinessChangeVO> prjExpenseList = domainList.stream().map(PrdSystemBusinessChangeConvert.INSTANCE::toVo).collect(Collectors.toList());
////            return PagingVO.<PrdSystemBusinessChangeVO>builder().total(count).records(prjExpenseList).build();
////        }
////        return PagingVO.<PrdSystemBusinessChangeVO>builder().total(count).records(new ArrayList<>()).build();
////    }
//
//    @Override
//    public PrdSystemBusinessChangePayload findOneById(Long id){
//        Optional<PrdSystemBusinessChangeDO> optional = repo.findById(id);
//        if (optional.isPresent()){
//            PrdSystemBusinessChangeDO changeDO = optional.get();
//            PrdSystemBusinessChangePayload changePayload = PrdSystemBusinessChangeConvert.INSTANCE.toDto(changeDO);
//            return changePayload;
//        }
//        return null;
//    }

//    private BaseViewModel formatLoacalDateTime(BaseViewModel baseViewModel){
//        // voucher是目标对象
//        try{
//            //通过getDeclaredFields()方法获取对象类中的所有属性（含私有）
//            Field[] fields = BeanUtil.getAllFields(baseViewModel.getClass());
//            for (Field field : fields) {
//                //设置允许通过反射访问私有变量
//                field.setAccessible(true);
//                //获取字段的值
//                Object o = field.get(baseViewModel);
//                if (o instanceof LocalDateTime){
//
//                }else if(o instanceof LocalDate){
//
//                }
//            }
//        }
//        catch (Exception ex){
//            //处理异常
//        }
//        return baseViewModel;
//    }
}


