package com.elitesland.tw.tw5.server.common.constants;

import lombok.Getter;

public enum BusinessTeamRoleEnum {
    BASE("BASE","普通成员"),
    SALE_MANAGER("SALE_MANAGER","销售负责人"),
    SERVICE_MANAGER("SERVICE_MANAGER","服务负责人"),
    PURCHASE_MANAGER("PURCHASE_MANAGER","采购负责人"),
    CHANNEL_MANAGER("CHANNEL_MANAGER","渠道负责人"),
    PRESALE_MANAGER("PRESALE_MANAGER", "售前负责人"),
    PAY_MANAGER("PAY_MANAGER", "交付负责人");
    @Getter
    private final String code;
    @Getter
    private final String desc;

    BusinessTeamRoleEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String queryDescByCode(String code){
        BusinessTeamRoleEnum[] values = BusinessTeamRoleEnum.values();
        for(BusinessTeamRoleEnum temp:values){
            if(temp.getCode().equals(code)){
                return temp.getDesc();
            }
        }
        return null;
    }
}
