package com.elitesland.tw.tw5.server.common.crontask;


//import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
//import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgCompanyNoticeService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 定时任务
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class CmadCronTask {
    /**
     * TW5.0版本更新通知
     */
    public final static String messageXxlJobValue = "xxl-job-executor-message";
    /**
     * 组织定时任务
     */
    public final static String orgXxlJobValue = "xxl-job-executor-org";
    /**
     * 员工定时任务
     */
    public final static String userXxlJobValue = "xxl-job-executor-user";
    /**
     * 员工关系定时任务 （组织员工关系）
     */
    public final static String orgRefUserXxlJobValue = "xxl-job-executor-org-ref-user";
    /**
     * 项目定时任务
     */
    public final static String projectXxlJobValue = "xxl-job-executor-project";

    /**
     * 任务定时任务
     */
    public final static String taskXxlJobValue = "xxl-job-executor-task";

    /**
     * 任务包授权定时任务
     */
    public final static String taskAuthorizedXxlJobValue = "xxl-job-executor-task-authorized";

    /**
     * 任务包授权详情定时任务
     */
    public final static String taskAuthorizedDetailXxlJobValue = "xxl-job-executor-task-authorized-detail";

    /**
     * 项目成员定时任务
     */
    public final static String projShXxlJobValue = "xxl-job-executor-proj-sh";


     /**
     * 活动定时任务
     */
    public final static String activityXxlJobValue = "xxl-job-executor-activity";

    /**
     * 工时定时任务  5.0单项到4.0
     */
    public final static String timesheetXxlJobValue = "xxl-job-executor-timesheet";


    /**
     * 假期工时定时任务  4.0单项到5.0
     */
    public final static String vacationTimesheetTo5XxlJobValue = "xxl-job-executor-timesheet-vacation-to5";

    /**
     * 活动超时未发布
     */
    public final static String activityUnRelease = "xxl-job-activity-unrelease";
    /**
     * 公告定时任务
     */
    public final static String companyNoticeXxlJobValue = "xxl-job-company-notice";

    /**
     * 线索分配七日提醒定时任务
     */
    public final static String leadsRecieveNotice1XxlJobValue = "xxl-job-leads-receive-notice1";

    /**
     * 线索分配十日提醒定时任务
     */
    public final static String leadsRecieveNotice2XxlJobValue = "xxl-job-leads-receive-notice2";

    private final PrdMessageConfigService prdMessageConfigService;
//    private final CrmLeadsService leadsService;
//    private final CrmActActivityService activityService;
    private final PrdOrgCompanyNoticeService noticeService;

    /**
     * 消息定时任务
     *
     * @param param 定时任务服务给的参数
     * @return 定时任务执行结果
     */
    @XxlJob(value = messageXxlJobValue)
    public ReturnT<String> messageJobHandler(String param) {
        log.info("wwwwwwwwwwwwwwwwwwwwwwwwwww:", param);
        XxlJobLogger.log("xxl-job-executor-message 开始执行。。。");
        prdMessageConfigService.onJobHandlerRelease(param);
        // 执行一次消息发送服务
        XxlJobLogger.log("执行结果:");
        System.out.println("wwwwwwwwwwwwwwwwwwwwwwwwwww:" + param);
        return ReturnT.SUCCESS;
    }


//    /**
//     * 超时未分配校验定时任务
//     *
//     * @return 定时任务执行结果
//     */
//    @XxlJob(value = "leadsUndistributedRemind")
//    public ReturnT<String> leadsUndistributedRemind(String param) {
//        XxlJobLogger.log("[任务开始]-开始扫描超时未分配的线索...");
//        boolean result = leadsService.leadsToDistributeRemind();
//        if (result) {
//            return ReturnT.SUCCESS;
//        } else {
//            return ReturnT.FAIL;
//        }
//
//    }


//    /**
//     * 超时未跟进校验定时任务
//     *
//     * @return 定时任务执行结果
//     */
//    @XxlJob(value = "leadsNotFollowRemind")
//    public ReturnT<String> leadsUnReceivedRemind(String param) {
//        XxlJobLogger.log("[任务开始]-开始扫描超时未跟进配的线索...");
//        boolean result = leadsService.leadsNotFollowRemind();
//        if (result) {
//            return ReturnT.SUCCESS;
//        } else {
//            return ReturnT.FAIL;
//        }
//    }
//    /**
//     * 线索分配七日提醒定时任务
//     *
//     * @return 定时任务执行结果
//     */
//    @XxlJob(value = leadsRecieveNotice1XxlJobValue)
//    public ReturnT<String> leadsRecieveNotice1(String param) {
//        XxlJobLogger.log("[任务开始]-开始扫描超过7天未接收的线索...");
//        boolean result = leadsService.leadsNotReceiveRemind(7);
//        if (result) {
//            return ReturnT.SUCCESS;
//        } else {
//            return ReturnT.FAIL;
//        }
//    }
//    /**
//     * 线索分配十日提醒定时任务
//     *
//     * @return 定时任务执行结果
//     */
//    @XxlJob(value = leadsRecieveNotice2XxlJobValue)
//    public ReturnT<String> leadsRecieveNotice2(String param) {
//        XxlJobLogger.log("[任务开始]-开始扫描超过10天未接收的线索...");
//        boolean result = leadsService.leadsNotReceiveRemind(10);
//        if (result) {
//            return ReturnT.SUCCESS;
//        } else {
//            return ReturnT.FAIL;
//        }
//    }


//    /**
//     * 活动超时未发布
//     *
//     * @return 定时任务执行结果
//     */
//    @XxlJob(value = activityUnRelease)
//    public ReturnT<String> activityUnReleaseJobHandler(String param) {
//        XxlJobLogger.log("[任务开始]-开始扫描活动超时未发布...");
//        log.info("[任务开始]-开始扫描活动超时未发布...:", param);
//        activityService.activityUnReleaseJobHandler();
//        return ReturnT.SUCCESS;
//    }

    /**
     * 公告定时任务
     *
     * @return 公告定时任务
     */
    @XxlJob(value = companyNoticeXxlJobValue)
    public ReturnT<String> companyNoticeXxlJobValue(String param) {
        noticeService.companyNoticeJobHandler(param);
        return ReturnT.SUCCESS;
    }
}
