package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTablePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务对象表
 *
 * @folder 页面配置
 * @author duwh
 * @date 2023-06-14
 */
@Api(tags = "业务对象表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/businessTable")
@Slf4j
public class BusinessTableController {

    private final BusinessTableService businessTableService;

    /**
     * 业务对象表-新增
     *
     * @folder 页面配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务对象表-新增")
    public TwOutputUtil<BusinessTableVO> insert(@RequestBody BusinessTablePayload payload){
         return TwOutputUtil.ok(businessTableService.insert(payload));
    }

    /**
     * 业务对象表-更新
     *
         * @folder 页面配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务对象表-更新")
    public TwOutputUtil<BusinessTableVO> update(@RequestBody BusinessTablePayload payload){
        return TwOutputUtil.ok(businessTableService.update(payload));
    }

    /**
     * 业务对象表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 页面配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("业务对象表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessTablePayload payload){
        return TwOutputUtil.ok(businessTableService.updateByKeyDynamic(payload));
    }

    /**
     * 业务对象表-主键查询
     *
     * @folder 页面配置
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("业务对象表-主键查询")
    public TwOutputUtil<BusinessTableVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessTableService.queryByKey(key));
    }

    /**
     * 业务对象表-分页
     *
         * @folder 页面配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
//     @UdcNameClass
    @ApiOperation("业务对象表-分页")
    public TwOutputUtil<PagingVO<BusinessTableVO>> paging(BusinessTableQuery query) {
        return TwOutputUtil.ok(businessTableService.queryPaging(query));
    }

    /**
     * 业务对象表-查询列表
     *
     * @folder 页面配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("业务对象表-查询列表")
    public TwOutputUtil<List<BusinessTableVO>> queryList(BusinessTableQuery query) {
        return TwOutputUtil.ok(businessTableService.queryListDynamic(query));
    }

    /**
     * 业务对象表-删除
     *
         * @folder 页面配置
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务对象表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessTableService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

