package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessTableRepo;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessTableDAO;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessTableConvert;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTablePayload;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessTableDO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableQuery;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessTableConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 业务对象表
 *
 * @author duwh
 * @date 2023-06-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessTableServiceImpl extends BaseServiceImpl implements BusinessTableService {

    private final BusinessTableRepo businessTableRepo;
    private final BusinessTableDAO businessTableDAO;

    @Override
    public PagingVO<BusinessTableVO> queryPaging(BusinessTableQuery query){
        return businessTableDAO.queryPaging(query);
    }

    @Override
    public List<BusinessTableVO> queryListDynamic(BusinessTableQuery query){
        return businessTableDAO.queryListDynamic(query);
    }

    @Override
    public BusinessTableVO queryByKey(Long key) {
        BusinessTableDO entity = businessTableRepo.findById(key).orElseGet(BusinessTableDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessTableVO vo = BusinessTableConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessTableVO insert(BusinessTablePayload payload) {
        BusinessTableDO entityDo = BusinessTableConvert.INSTANCE.toDo(payload);
        return BusinessTableConvert.INSTANCE.toVo(businessTableRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessTableVO update(BusinessTablePayload payload) {
        BusinessTableDO entity = businessTableRepo.findById(payload.getId()).orElseGet(BusinessTableDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessTableDO entityDo = BusinessTableConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessTableConvert.INSTANCE.toVo(businessTableRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessTablePayload payload) {
        BusinessTableDO entity = businessTableRepo.findById(payload.getId()).orElseGet(BusinessTableDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessTableDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<BusinessTableDO> optional = businessTableRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessTableDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    businessTableRepo.save(entity);
                }
             });
        }
    }

}
