package com.elitesland.tw.tw5.server.common.log.contorller;


import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author carl
 */
@Api(tags = "通用日志")
@RestController
@RequestMapping("/api/com/log")
@RequiredArgsConstructor
public class ComLogController {

    private final ComLogService service;

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @ApiOperation("分页")
    public TwOutputUtil paging(ComLogQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @ApiOperation("查询列表")
    public TwOutputUtil list(ComLogQuery query) {
        return TwOutputUtil.ok(service.queryList(query));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(service.queryByKey(key));
    }
}
